/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import org.jmol.i18n.GT;

class JmolResourceHandler {
    private static JmolResourceHandler instance;
    private ResourceBundle stringsResourceBundle;
    private ResourceBundle generalResourceBundle;
    public static Object codePath;

    private JmolResourceHandler() {
        String language = "en";
        String country = "";
        String localeString = GT.getLanguage();
        if (localeString != null) {
            StringTokenizer st = new StringTokenizer(localeString, "_");
            if (st.hasMoreTokens()) {
                language = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                country = st.nextToken();
            }
        }
        Locale locale = new Locale(language, country);
        this.stringsResourceBundle = ResourceBundle.getBundle("org.openscience.jmol.app.jmolpanel.Properties.Jmol", locale);
        try {
            String t = "/org/openscience/jmol/app/jmolpanel/Properties/Jmol-resources.properties";
            this.generalResourceBundle = new PropertyResourceBundle(this.getClass().getResourceAsStream(t));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    static void clear() {
        instance = null;
    }

    static JmolResourceHandler getInstance() {
        if (instance == null) {
            instance = new JmolResourceHandler();
        }
        return instance;
    }

    static String getStringX(String key) {
        return JmolResourceHandler.getInstance().getString(key);
    }

    static ImageIcon getIconX(String key) {
        return JmolResourceHandler.getInstance().getIcon(key);
    }

    private synchronized ImageIcon getIcon(String key) {
        String resourceName = null;
        try {
            resourceName = this.getString(key);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (resourceName != null) {
            String imageName = "org/openscience/jmol/app/images/" + resourceName;
            URL imageUrl = this.getClass().getClassLoader().getResource(imageName);
            if (imageUrl != null) {
                String s = imageUrl.toString();
                codePath = s.substring(0, s.indexOf(imageName));
                return new ImageIcon(imageUrl);
            }
        }
        return null;
    }

    private synchronized String getString(String key) {
        String result = null;
        try {
            result = this.stringsResourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (result == null) {
            try {
                result = this.generalResourceBundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return result != null ? result : key;
    }
}

