/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import org.jmol.atomdata.RadiusData;
import org.jmol.c.VDW;
import org.jmol.java.BS;
import org.jmol.shapebio.BioShapeCollection;

public class Trace
extends BioShapeCollection {
    private static final int PUTTY_NormalizedNonlinear = 0;
    private static final int PUTTY_RelativeNonlinear = 1;
    private static final int PUTTY_ScaledNonlinear = 2;
    private static final int PUTTY_AbsoluteNonlinear = 3;
    private static final int PUTTY_NormalizedLinear = 4;
    private static final int PUTTY_RelativeLinear = 5;
    private static final int PUTTY_ScaledLinear = 6;
    private static final int PUTTY_AbsoluteLinear = 7;
    private static final int PUTTY_ImpliedRMS = 8;

    @Override
    public void initShape() {
        this.madOn = (short)600;
        this.madHelixSheet = (short)1500;
        this.madTurnRandom = (short)500;
        this.madDnaRna = (short)1500;
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bsSelected) {
        if (propertyName == "putty") {
            this.setPutty((float[])value, bsSelected);
            return;
        }
        this.setPropBSC(propertyName, value, bsSelected);
    }

    private void setPutty(float[] info, BS bsAtoms) {
        int n = bsAtoms.cardinality();
        if (n == 0) {
            return;
        }
        float[] data = new float[bsAtoms.length()];
        double sum = 0.0;
        double sumsq = 0.0;
        float min = Float.MAX_VALUE;
        float max = 0.0f;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            float value = this.atoms[i].atomPropertyFloat(null, 1111492620, null);
            sum += (double)value;
            sumsq += (double)(value * value);
            if (value < min) {
                min = value;
            }
            if (value > max) {
                max = value;
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        float mean = (float)(sum / (double)n);
        float stdev = (float)Math.sqrt((sumsq - sum * sum / (double)n) / (double)n);
        float rad = info[1];
        float range = info[2];
        float scale_min = info[3];
        float scale_max = info[4];
        float power = info[5];
        int transform = (int)info[6];
        float data_range = max - min;
        boolean nonlinear = false;
        switch (transform) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                nonlinear = true;
            }
        }
        int i2 = bsAtoms.nextSetBit(0);
        while (i2 >= 0) {
            float scale = this.atoms[i2].atomPropertyFloat(null, 1111492620, null);
            switch (transform) {
                default: {
                    break;
                }
                case 0: 
                case 4: {
                    scale = 1.0f + (scale - mean) / range / stdev;
                    break;
                }
                case 1: 
                case 5: {
                    scale = (scale - min) / data_range / range;
                    break;
                }
                case 2: 
                case 6: {
                    scale /= range;
                    break;
                }
                case 8: {
                    if (scale < 0.0f) {
                        scale = 0.0f;
                    }
                    scale = (float)(Math.sqrt((double)scale / 8.0) / Math.PI);
                }
            }
            if (scale < 0.0f) {
                scale = 0.0f;
            }
            if (nonlinear) {
                scale = (float)Math.pow(scale, power);
            }
            if (scale < scale_min && (double)scale_min >= 0.0) {
                scale = scale_min;
            }
            if (scale > scale_max && (double)scale_max >= 0.0) {
                scale = scale_max;
            }
            data[i2] = scale * rad;
            i2 = bsAtoms.nextSetBit(i2 + 1);
        }
        RadiusData rd = new RadiusData(data, 0.0f, RadiusData.EnumType.ABSOLUTE, VDW.AUTO);
        this.setShapeSizeRD(0, rd, bsAtoms);
    }
}

