/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Point;
import java.util.Random;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TemplatedTMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public class ScanexTileSource
extends TMSTileSource {
    private static final String DEFAULT_URL = "http://maps.kosmosnimki.ru";
    private static final int DEFAULT_MAXZOOM = 14;
    private static final String API_KEY = "4018C5A9AECAD8868ED5DEB2E41D09F7";
    private ScanexLayer layer = ScanexLayer.IRS;
    private TemplatedTMSTileSource TemplateSource = null;
    private double cachedLat;
    private static double RADIUS_E = 6378137.0;
    private static double EQUATOR = 4.007501668557849E7;
    private static double E = 0.0818191908426;

    public ScanexTileSource(TileSourceInfo tileSourceInfo) {
        super(tileSourceInfo);
        String string = tileSourceInfo.getUrl();
        this.tileSize = 256;
        for (ScanexLayer scanexLayer : ScanexLayer.values()) {
            if (!string.equalsIgnoreCase(scanexLayer.getName())) continue;
            this.layer = scanexLayer;
            this.baseUrl = DEFAULT_URL;
            if (this.maxZoom == 0) {
                this.maxZoom = 14;
            }
            return;
        }
        TemplatedTMSTileSource.checkUrl(tileSourceInfo.getUrl());
        this.TemplateSource = new TemplatedTMSTileSource(tileSourceInfo);
    }

    @Override
    public String getExtension() {
        return "jpeg";
    }

    @Override
    public String getTileUrl(int n, int n2, int n3) {
        if (this.TemplateSource != null) {
            return this.TemplateSource.getTileUrl(n, n2, n3);
        }
        return this.getBaseUrl() + this.getTilePath(n, n2, n3);
    }

    @Override
    public String getTilePath(int n, int n2, int n3) {
        int n4 = (int)Math.pow(2.0, n - 1);
        n3 = n4 - n3 - 1;
        return this.layer.getUri() + "&apikey=" + API_KEY + "&x=" + (n2 -= n4) + "&y=" + n3 + "&z=" + n;
    }

    @Override
    public Point latLonToXY(double d, double d2, int n) {
        return new Point((int)this.osmMercator.lonToX(d2, n), (int)this.latToTileY(d, n));
    }

    @Override
    public ICoordinate xyToLatLon(int n, int n2, int n3) {
        return new Coordinate(this.tileYToLat(n2, n3), this.osmMercator.xToLon(n, n3));
    }

    @Override
    public TileXY latLonToTileXY(double d, double d2, int n) {
        return new TileXY(this.osmMercator.lonToX(d2, n) / (double)this.getTileSize(), this.latToTileY(d, n));
    }

    @Override
    public ICoordinate tileXYToLatLon(int n, int n2, int n3) {
        return new Coordinate(this.tileYToLat(n2, n3), this.osmMercator.xToLon(n * this.getTileSize(), n3));
    }

    private double latToTileY(double d, int n) {
        double d2 = Math.tan(0.7853981633974483 * (1.0 + d / 90.0));
        double d3 = Math.pow(Math.tan(0.7853981633974483 + Math.asin(E * Math.sin(Math.toRadians(d))) / 2.0), E);
        return (EQUATOR / 2.0 - RADIUS_E * Math.log(d2 / d3)) * Math.pow(2.0, n) / EQUATOR;
    }

    private double tileYToLat(double d, int n) {
        double d2;
        double d3 = this.cachedLat;
        do {
            d2 = d3;
            if (!((d3 -= Math.toDegrees(ScanexTileSource.nextTerm(Math.toRadians(d3), d, n))) > 85.05112877980659) && !(d3 < -85.05112877980659)) continue;
            Random random = new Random();
            d3 = -85.05112877980659 + (double)random.nextInt(170);
        } while (Math.abs(d2 - d3) > 1.0E-6);
        this.cachedLat = d3;
        return d3;
    }

    private static double nextTerm(double d, double d2, int n) {
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        n = (int)Math.pow(2.0, n - 1);
        double d5 = Math.exp((1.0 - d2 / (double)n) * Math.PI);
        double d6 = Math.tan(0.7853981633974483 + d / 2.0) - d5 * Math.pow(Math.tan(0.7853981633974483 + Math.asin(E * d3) / 2.0), E);
        double d7 = 1.0 / (1.0 - d3) - d5 * E * d4 / ((1.0 - E * d3) * Math.sqrt(1.0 - E * E * d3 * d3));
        return d6 / d7;
    }

    private static enum ScanexLayer {
        IRS("irs", "/TileSender.ashx?ModeKey=tile&MapName=F7B8CF651682420FA1749D894C8AD0F6&LayerName=BAC78D764F0443BD9AF93E7A998C9F5B"),
        SPOT("spot", "/TileSender.ashx?ModeKey=tile&MapName=F7B8CF651682420FA1749D894C8AD0F6&LayerName=F51CE95441284AF6B2FC319B609C7DEC");

        private final String name;
        private final String uri;

        private ScanexLayer(String string2, String string3) {
            this.name = string2;
            this.uri = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

