/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableCellRenderer;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.tools.ImageProvider;

public class MemberTableLinkedCellRenderer
extends MemberTableCellRenderer {
    private static final Image arrowUp = ImageProvider.get("dialogs/relation", "arrowup").getImage();
    private static final Image arrowDown = ImageProvider.get("dialogs/relation", "arrowdown").getImage();
    private static final Image corners = ImageProvider.get("dialogs/relation", "roundedcorners").getImage();
    private static final Image roundabout_right = ImageProvider.get("dialogs/relation", "roundabout_right_tiny").getImage();
    private static final Image roundabout_left = ImageProvider.get("dialogs/relation", "roundabout_left_tiny").getImage();
    private transient WayConnectionType value = new WayConnectionType();

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.reset();
        if (object == null) {
            return this;
        }
        this.value = (WayConnectionType)object;
        this.setToolTipText(((WayConnectionType)object).getTooltip());
        this.renderBackgroundForeground(this.getModel(jTable), null, bl);
        return this;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int[] nArray;
        Object object;
        int n;
        int n2;
        super.paintComponent(graphics);
        if (this.value == null || !this.value.isValid()) {
            return;
        }
        int n3 = this.getSize().height - 1;
        int n4 = 10;
        int n5 = 0;
        if (this.value.isOnewayLoopForwardPart) {
            n5 = -3;
        }
        if (this.value.isOnewayLoopBackwardPart) {
            n5 = 3;
        }
        int n6 = this.getSize().width / 2;
        if (this.value.isLoop) {
            n6 -= n4 / 2 - 1;
        }
        int n7 = 2;
        int n8 = 2 + n7 + 1;
        if (this.value.linkPrev) {
            graphics.setColor(Color.black);
            if (this.value.isOnewayHead) {
                graphics.fillRect(n6 - 1, 0, 3, 1);
            } else {
                graphics.fillRect(n6 - 1 + n5, 0, 3, 1);
            }
            n2 = 0;
        } else if (this.value.isLoop) {
            graphics.setColor(Color.black);
            n2 = 5;
            graphics.drawImage(corners, n6, n2 - 3, n6 + 3, n2, 0, 0, 3, 3, new Color(0, 0, 0, 0), null);
            graphics.drawImage(corners, n6 + n4 - 2, n2 - 3, n6 + n4 + 1, n2, 2, 0, 5, 3, new Color(0, 0, 0, 0), null);
            graphics.drawLine(n6 + 3, n2 - 3, n6 + n4 - 3, n2 - 3);
        } else {
            graphics.setColor(Color.red);
            if (this.value.isOnewayHead) {
                graphics.drawRect(n6 - 1, n8 - 3 - n7, n7, n7);
            } else {
                graphics.drawRect(n6 - 1 + n5, n8 - 1 - n7, n7, n7);
            }
            n2 = n8;
        }
        if (this.value.linkNext) {
            graphics.setColor(Color.black);
            if (this.value.isOnewayTail) {
                graphics.fillRect(n6 - 1, n3, 3, 1);
            } else {
                graphics.fillRect(n6 - 1 + n5, n3, 3, 1);
            }
            n = n3;
        } else if (this.value.isLoop) {
            graphics.setColor(Color.black);
            n = n3 - 5;
            graphics.fillRect(n6 - 1, n + 2, 3, 3);
            graphics.drawLine(n6, n, n6, n + 2);
            graphics.drawImage(corners, n6 + n4 - 2, n + 1, n6 + n4 + 1, n + 4, 2, 2, 5, 5, new Color(0, 0, 0, 0), null);
            graphics.drawLine(n6 + 3 - 1, n + 3, n6 + n4 - 3, n + 3);
        } else {
            graphics.setColor(Color.red);
            if (this.value.isOnewayTail) {
                graphics.drawRect(n6 - 1, n3 - n8 + 3, n7, n7);
            } else {
                graphics.drawRect(n6 - 1 + n5, n3 - n8 + 1, n7, n7);
            }
            n = n3 - n8;
        }
        graphics.setColor(Color.black);
        if (this.value.isLoop) {
            graphics.drawLine(n6 + n4, n2, n6 + n4, n);
        }
        if (this.value.isOnewayHead) {
            MemberTableLinkedCellRenderer.setDotted(graphics);
            n2 = 7;
            object = new int[]{n6 - n5 + 1, n6 - n5 + 1, n6};
            nArray = new int[]{n3, n2 + 1, 1};
            graphics.drawPolyline((int[])object, nArray, 3);
            MemberTableLinkedCellRenderer.unsetDotted(graphics);
            graphics.drawLine(n6 + n5, n2 + 1, n6, 1);
        }
        if (this.value.isOnewayTail) {
            MemberTableLinkedCellRenderer.setDotted(graphics);
            n = n3 - 7;
            object = new int[]{n6 + 1, n6 - n5 + 1, n6 - n5 + 1};
            nArray = new int[]{n3 - 1, n, n2};
            graphics.drawPolyline((int[])object, nArray, 3);
            MemberTableLinkedCellRenderer.unsetDotted(graphics);
            graphics.drawLine(n6 + n5, n, n6, n3 - 1);
        }
        if ((this.value.isOnewayLoopForwardPart || this.value.isOnewayLoopBackwardPart) && !this.value.isOnewayTail && !this.value.isOnewayHead) {
            MemberTableLinkedCellRenderer.setDotted(graphics);
            graphics.drawLine(n6 - n5 + 1, n2, n6 - n5 + 1, n + 1);
            MemberTableLinkedCellRenderer.unsetDotted(graphics);
        }
        if (!this.value.isOnewayLoopForwardPart && !this.value.isOnewayLoopBackwardPart) {
            graphics.drawLine(n6, n2, n6, n);
        }
        graphics.drawLine(n6 + n5, n2, n6 + n5, n);
        switch (this.value.direction) {
            case FORWARD: {
                object = arrowDown;
                break;
            }
            case BACKWARD: {
                object = arrowUp;
                break;
            }
            default: {
                object = null;
            }
        }
        if (this.value.direction == WayConnectionType.Direction.ROUNDABOUT_LEFT) {
            graphics.drawImage(roundabout_left, n6 - 6, 1, null);
        } else if (this.value.direction == WayConnectionType.Direction.ROUNDABOUT_RIGHT) {
            graphics.drawImage(roundabout_right, n6 - 6, 1, null);
        }
        if (!this.value.isOnewayLoopForwardPart && !this.value.isOnewayLoopBackwardPart && object != null) {
            graphics.drawImage((Image)object, n6 - 3, (n2 + n) / 2 - 2, null);
        }
        if (this.value.isOnewayLoopBackwardPart && this.value.isOnewayLoopForwardPart) {
            if (object == arrowDown) {
                object = arrowUp;
            } else if (object == arrowUp) {
                object = arrowDown;
            }
        }
        if (object != null) {
            graphics.drawImage((Image)object, n6 + n5 - 3, (n2 + n) / 2 - 2, null);
        }
    }

    private static void setDotted(Graphics graphics) {
        ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{1.0f, 2.0f}, 0.0f));
    }

    private static void unsetDotted(Graphics graphics) {
        ((Graphics2D)graphics).setStroke(new BasicStroke());
    }
}

