/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TagTableColumnModelBuilder {
    private final DefaultTableColumnModel model = new DefaultTableColumnModel();

    public TagTableColumnModelBuilder(TableCellRenderer tableCellRenderer, String ... stringArray) {
        CheckParameterUtil.ensureParameterNotNull(stringArray, "headerValues");
        for (int i = 0; i < stringArray.length; ++i) {
            TableColumn tableColumn = new TableColumn(i);
            tableColumn.setHeaderValue(stringArray[i]);
            tableColumn.setResizable(true);
            tableColumn.setCellRenderer(tableCellRenderer);
            this.model.addColumn(tableColumn);
        }
    }

    public TagTableColumnModelBuilder setWidth(int n, int ... nArray) {
        for (int n2 : nArray) {
            this.model.getColumn(n2).setWidth(n);
        }
        return this;
    }

    public TagTableColumnModelBuilder setPreferredWidth(int n, int ... nArray) {
        for (int n2 : nArray) {
            this.model.getColumn(n2).setPreferredWidth(n);
        }
        return this;
    }

    public TagTableColumnModelBuilder setMaxWidth(int n, int ... nArray) {
        for (int n2 : nArray) {
            this.model.getColumn(n2).setMaxWidth(n);
        }
        return this;
    }

    public TagTableColumnModelBuilder setCellEditor(TableCellEditor tableCellEditor, int ... nArray) {
        for (int n : nArray) {
            this.model.getColumn(n).setCellEditor(tableCellEditor);
        }
        return this;
    }

    public TagTableColumnModelBuilder setSelectionModel(ListSelectionModel listSelectionModel) {
        this.model.setSelectionModel(listSelectionModel);
        return this;
    }

    public DefaultTableColumnModel build() {
        return this.model;
    }
}

