/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.DebugStackFrame;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.ValueInteropList;
import com.oracle.truffle.api.debug.ValuePropertiesCollection;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class DebugValue {
    abstract Class<? extends TruffleLanguage> getLanguage();

    abstract Object get();

    DebugValue() {
    }

    public abstract void set(DebugValue var1);

    public abstract <T> T as(Class<T> var1);

    public abstract String getName();

    public abstract boolean isReadable();

    public abstract boolean isWriteable();

    public final Collection<DebugValue> getProperties() {
        ValuePropertiesCollection properties;
        block4: {
            Map map;
            if (!this.isReadable()) {
                throw new IllegalStateException("Value is not readable");
            }
            Object value = this.get();
            properties = null;
            if (value instanceof TruffleObject && (map = JavaInterop.asJavaObject(Map.class, (TruffleObject)value)) != null) {
                try {
                    properties = new ValuePropertiesCollection(this.getDebugger(), this.getSourceRoot(), map.entrySet());
                }
                catch (Exception ex) {
                    if (ex.getCause() instanceof InteropException) break block4;
                    throw ex;
                }
            }
        }
        return properties;
    }

    public final boolean isArray() {
        Object value = this.get();
        if (value instanceof TruffleObject) {
            TruffleObject to = (TruffleObject)value;
            return JavaInterop.isArray(to);
        }
        return false;
    }

    public final List<DebugValue> getArray() {
        TruffleObject to;
        ValueInteropList arrayList = null;
        Object value = this.get();
        if (value instanceof TruffleObject && JavaInterop.isArray(to = (TruffleObject)value)) {
            List array = JavaInterop.asJavaObject(List.class, (TruffleObject)value);
            arrayList = new ValueInteropList(this.getDebugger(), this.getSourceRoot(), array);
        }
        return arrayList;
    }

    abstract Debugger getDebugger();

    abstract RootNode getSourceRoot();

    public String toString() {
        return "DebugValue(name=" + this.getName() + ", value = " + this.as(String.class) + ")";
    }

    static final class StackValue
    extends DebugValue {
        protected final DebugStackFrame origin;
        private final FrameSlot slot;

        StackValue(DebugStackFrame frame, FrameSlot slot) {
            this.origin = frame;
            this.slot = slot;
        }

        @Override
        public <T> T as(Class<T> clazz) {
            this.origin.verifyValidState(false);
            if (!this.isReadable()) {
                throw new IllegalStateException("Value is not readable");
            }
            if (clazz == String.class) {
                RootNode root = this.origin.findCurrentRoot();
                Object value = this.get();
                String stringValue = root == null ? value.toString() : this.origin.event.getSession().getDebugger().getEnv().toString(root, this.get());
                return (T)stringValue;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        Class<? extends TruffleLanguage> getLanguage() {
            return this.origin.findCurrentLanguage();
        }

        @Override
        Object get() {
            this.origin.verifyValidState(false);
            return this.origin.findTruffleFrame().getValue(this.slot);
        }

        @Override
        public void set(DebugValue value) {
            this.origin.verifyValidState(false);
            if (value.getLanguage() != this.getLanguage()) {
                throw new IllegalStateException(String.format("Languages of set values do not match %s != %s.", value.getLanguage(), this.getLanguage()));
            }
            MaterializedFrame frame = this.origin.findTruffleFrame();
            frame.setObject(this.slot, value.get());
        }

        @Override
        public String getName() {
            this.origin.verifyValidState(false);
            return this.slot.getIdentifier().toString();
        }

        @Override
        public boolean isReadable() {
            this.origin.verifyValidState(false);
            return true;
        }

        @Override
        public boolean isWriteable() {
            this.origin.verifyValidState(false);
            return true;
        }

        @Override
        Debugger getDebugger() {
            return this.origin.event.getSession().getDebugger();
        }

        @Override
        RootNode getSourceRoot() {
            return this.origin.findCurrentRoot();
        }
    }

    static final class PropertyValue
    extends HeapValue {
        private final Map.Entry<Object, Object> property;

        PropertyValue(Debugger debugger, RootNode root, Map.Entry<Object, Object> property) {
            super(debugger, root, null);
            this.property = property;
        }

        @Override
        Object get() {
            return this.property.getValue();
        }

        @Override
        public String getName() {
            RootNode sourceRoot = this.getSourceRoot();
            Object propertyKey = this.property.getKey();
            String name = propertyKey instanceof String ? (String)propertyKey : (sourceRoot == null ? Objects.toString(propertyKey) : this.getDebugger().getEnv().toString(sourceRoot, propertyKey));
            return name;
        }

        @Override
        public boolean isWriteable() {
            return true;
        }

        @Override
        public void set(DebugValue value) {
            this.property.setValue(value.get());
        }
    }

    static class HeapValue
    extends DebugValue {
        private final Debugger debugger;
        private final RootNode sourceRoot;
        private final Object value;

        HeapValue(Debugger debugger, RootNode root, Object value) {
            this.debugger = debugger;
            this.sourceRoot = root;
            this.value = value;
        }

        @Override
        Class<? extends TruffleLanguage> getLanguage() {
            return Debugger.ACCESSOR.findLanguage(this.sourceRoot);
        }

        @Override
        public <T> T as(Class<T> clazz) {
            if (!this.isReadable()) {
                throw new IllegalStateException("Value is not readable");
            }
            if (clazz == String.class) {
                Object val = this.get();
                String stringValue = this.sourceRoot == null ? val.toString() : this.debugger.getEnv().toString(this.sourceRoot, val);
                return (T)stringValue;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        Object get() {
            return this.value;
        }

        @Override
        public void set(DebugValue expression) {
            throw new IllegalStateException("Value is not writable");
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWriteable() {
            return false;
        }

        @Override
        Debugger getDebugger() {
            return this.debugger;
        }

        @Override
        RootNode getSourceRoot() {
            return this.sourceRoot;
        }
    }
}

