/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Array;

abstract class ArrayReadNode
extends Node {
    ArrayReadNode() {
    }

    protected abstract Object executeWithTarget(VirtualFrame var1, JavaObject var2, Object var3);

    @Specialization(guards={"index.getClass() == clazz"})
    protected static Object doNumber(JavaObject receiver, Number index, @Cached(value="index.getClass()") Class<?> clazz) {
        Class<?> numberClazz = clazz;
        return ArrayReadNode.doArrayAccess(receiver, ((Number)numberClazz.cast(index)).intValue());
    }

    @Specialization(contains={"doNumber"})
    protected static Object doNumberGeneric(JavaObject receiver, Number index) {
        return ArrayReadNode.doArrayAccess(receiver, index.intValue());
    }

    private static Object doArrayAccess(JavaObject object, int index) {
        Object obj = object.obj;
        Object val = null;
        try {
            val = Array.get(obj, index);
        }
        catch (IllegalArgumentException notAnArr) {
            throw UnsupportedMessageException.raise(Message.READ);
        }
        if (ToJavaNode.isPrimitive(val)) {
            return val;
        }
        return JavaInterop.asTruffleObject(val);
    }
}

