/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Content;
import com.oracle.truffle.api.source.Source;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Objects;

final class SourceImpl
extends Source
implements Cloneable {
    private static Ref SOURCES = null;
    private static long nextCheck;

    SourceImpl(Content content) {
        this(content, null, null, null, false, false);
    }

    SourceImpl(Content content, String mimeType, URI uri, String name, boolean internal, boolean interactive) {
        super(content, mimeType, uri, name, internal, interactive);
        SourceImpl.registerSource(this);
    }

    protected SourceImpl clone() throws CloneNotSupportedException {
        SourceImpl clone = (SourceImpl)super.clone();
        SourceImpl.registerSource(clone);
        return clone;
    }

    static synchronized void registerSource(SourceImpl source) {
        long now = System.currentTimeMillis();
        if (nextCheck < now) {
            SourceImpl.findSource(null);
            nextCheck = now + 1000L;
        }
        SOURCES = new Ref(source, SOURCES);
    }

    static synchronized Source findSource(String name) {
        Ref prev = null;
        Ref now = SOURCES;
        while (now != null) {
            SourceImpl source = (SourceImpl)now.get();
            if (source == null) {
                if (prev == null) {
                    SOURCES = now.next;
                } else {
                    prev.next = now.next;
                }
            } else {
                prev = now;
                if (Objects.equals(source.getName(), name)) {
                    return source;
                }
            }
            now = now.next;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean equals(Object obj) {
        if (obj instanceof Source) {
            Source other = (Source)obj;
            return this.content().equals(other.content()) && this.equalAttributes(other);
        }
        return false;
    }

    public int hashCode() {
        return this.content().hashCode();
    }

    private static final class Ref
    extends WeakReference<SourceImpl> {
        Ref next;

        Ref(SourceImpl source, Ref next) {
            super(source);
            this.next = next;
        }
    }
}

