/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.exception;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.AllocateObjectNode;

@CoreClass(value="NameError")
public abstract class NameErrorNodes {

    @Primitive(name="name_error_set_name")
    public static abstract class NameSetNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object setName(DynamicObject error, Object name) {
            Layouts.NAME_ERROR.setName(error, name);
            return name;
        }
    }

    @CoreMethod(names={"receiver"})
    public static abstract class ReceiverNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object receiver(DynamicObject self) {
            Object receiver = Layouts.NAME_ERROR.getReceiver(self);
            if (receiver == null) {
                throw new RaiseException(this.coreExceptions().argumentErrorNoReceiver(this));
            }
            return receiver;
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object name(DynamicObject self) {
            return Layouts.NAME_ERROR.getName(self);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        @Specialization
        public DynamicObject allocateNameError(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, this.nil(), null, null, this.nil());
        }
    }
}

