/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.write.bytes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.exceptions.NoImplicitConversionException;
import org.jruby.truffle.core.format.write.bytes.EncodeUM;
import org.jruby.truffle.core.string.ByteList;

@NodeChildren(value={@NodeChild(value="value", type=FormatNode.class)})
public abstract class WriteUUStringNode
extends FormatNode {
    private final int length;
    private final boolean ignoreStar;

    public WriteUUStringNode(int length, boolean ignoreStar) {
        this.length = length;
        this.ignoreStar = ignoreStar;
    }

    @Specialization
    public Object write(long bytes) {
        throw new NoImplicitConversionException(bytes, "String");
    }

    @Specialization(guards={"isEmpty(bytes)"})
    public Object writeEmpty(VirtualFrame frame, byte[] bytes) {
        return null;
    }

    @Specialization(guards={"!isEmpty(bytes)"})
    public Object write(VirtualFrame frame, byte[] bytes) {
        this.writeBytes(frame, this.encode(bytes));
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private byte[] encode(byte[] bytes) {
        ByteList output = new ByteList();
        EncodeUM.encodeUM(null, new ByteList(bytes, false), this.length, this.ignoreStar, 'u', output);
        return output.bytes();
    }

    protected boolean isEmpty(byte[] bytes) {
        return bytes.length == 0;
    }
}

