/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jcodings.Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.ByteList;
import org.jruby.truffle.language.RubyGuards;

public abstract class StringOperations {
    public static DynamicObject createString(RubyContext context, ByteList bytes) {
        return Layouts.STRING.createString(context.getCoreLibrary().getStringFactory(), RopeOperations.ropeFromByteList(bytes, CodeRange.CR_UNKNOWN));
    }

    public static DynamicObject createString(RubyContext context, Rope rope) {
        return Layouts.STRING.createString(context.getCoreLibrary().getStringFactory(), rope);
    }

    public static String getString(DynamicObject string) {
        return RopeOperations.decodeRope(StringOperations.rope(string));
    }

    public static int clampExclusiveIndex(DynamicObject string, int index) {
        assert (RubyGuards.isRubyString(string));
        return ArrayOperations.clampExclusiveIndex(StringOperations.rope(string).byteLength(), index);
    }

    @CompilerDirectives.TruffleBoundary
    public static Rope encodeRope(CharSequence value, Encoding encoding, CodeRange codeRange) {
        Charset charset = encoding.getCharset();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        ByteBuffer buffer = charset.encode(CharBuffer.wrap(value));
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        return RopeOperations.create(bytes, encoding, codeRange);
    }

    public static Rope encodeRope(CharSequence value, Encoding encoding) {
        return StringOperations.encodeRope(value, encoding, CodeRange.CR_UNKNOWN);
    }

    public static Rope rope(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return Layouts.STRING.getRope(string);
    }

    public static void setRope(DynamicObject string, Rope rope) {
        assert (RubyGuards.isRubyString(string));
        Layouts.STRING.setRope(string, rope);
    }

    public static Encoding encoding(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringOperations.rope(string).getEncoding();
    }

    public static CodeRange codeRange(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringOperations.rope(string).getCodeRange();
    }

    public static String decodeUTF8(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return RopeOperations.decodeUTF8(Layouts.STRING.getRope(string));
    }

    @CompilerDirectives.TruffleBoundary
    public static byte[] plain(CharSequence s) {
        if (s instanceof String) {
            return StandardCharsets.ISO_8859_1.encode(CharBuffer.wrap(s)).array();
        }
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)s.charAt(i);
        }
        return bytes;
    }
}

