/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.time;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.time.ZoneId;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.time.TimeNodes;
import org.jruby.truffle.core.time.TimeZoneAndName;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;

public abstract class GetTimeZoneNode
extends RubyNode {
    protected static final CyclicAssumption TZ_UNCHANGED = new CyclicAssumption("ENV['TZ'] is unmodified");
    @Node.Child
    private SnippetNode snippetNode = new SnippetNode();

    public static void invalidateTZ() {
        TZ_UNCHANGED.invalidate();
    }

    public abstract TimeZoneAndName executeGetTimeZone(VirtualFrame var1);

    @Specialization(assumptions={"TZ_UNCHANGED.getAssumption()"})
    public TimeZoneAndName getTimeZone(VirtualFrame frame, @Cached(value="getTimeZone(frame)") TimeZoneAndName zone) {
        return zone;
    }

    protected TimeZoneAndName getTimeZone(VirtualFrame frame) {
        Object tz = this.snippetNode.execute(frame, "ENV['TZ']", new Object[0]);
        String tzString = "";
        if (RubyGuards.isRubyString(tz)) {
            tzString = StringOperations.getString((DynamicObject)tz);
        }
        if (tz == this.nil()) {
            return new TimeZoneAndName(ZoneId.systemDefault(), null);
        }
        if (tzString.equalsIgnoreCase("localtime")) {
            return new TimeZoneAndName(ZoneId.systemDefault(), null);
        }
        if (RubyGuards.isRubyString(tz)) {
            return TimeNodes.TimeZoneParser.parse(this, tzString);
        }
        throw new UnsupportedOperationException();
    }
}

