/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.backtrace;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.RubyLanguage;
import org.jruby.truffle.core.string.StringUtils;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.backtrace.Activation;
import org.jruby.truffle.language.backtrace.Backtrace;
import org.jruby.truffle.language.backtrace.BacktraceInterleaver;
import org.jruby.truffle.language.control.RaiseException;

public class BacktraceFormatter {
    private final RubyContext context;
    private final EnumSet<FormattingFlags> flags;

    public static BacktraceFormatter createDefaultFormatter(RubyContext context) {
        EnumSet<FormattingFlags> flags = EnumSet.noneOf(FormattingFlags.class);
        if (!context.getOptions().BACKTRACES_HIDE_CORE_FILES) {
            flags.add(FormattingFlags.INCLUDE_CORE_FILES);
        }
        if (context.getOptions().BACKTRACES_INTERLEAVE_JAVA) {
            flags.add(FormattingFlags.INTERLEAVE_JAVA);
        }
        return new BacktraceFormatter(context, flags);
    }

    private static List<String> rubyBacktrace(RubyContext context, Node node) {
        return new BacktraceFormatter(context, EnumSet.of(FormattingFlags.INCLUDE_CORE_FILES)).formatBacktrace(context, null, context.getCallStack().getBacktrace(node));
    }

    public static String printableRubyBacktrace(RubyContext context, Node node) {
        StringBuilder builder = new StringBuilder();
        for (String line : BacktraceFormatter.rubyBacktrace(context, node)) {
            builder.append("\n");
            builder.append(line);
        }
        return builder.toString().substring(1);
    }

    public BacktraceFormatter(RubyContext context, EnumSet<FormattingFlags> flags) {
        this.context = context;
        this.flags = flags;
    }

    @CompilerDirectives.TruffleBoundary
    public void printBacktrace(RubyContext context, DynamicObject exception, Backtrace backtrace) {
        this.printBacktrace(context, exception, backtrace, new PrintWriter(System.err, true));
    }

    @CompilerDirectives.TruffleBoundary
    public void printBacktrace(RubyContext context, DynamicObject exception, Backtrace backtrace, PrintWriter writer) {
        for (String line : this.formatBacktrace(context, exception, backtrace)) {
            writer.println(line);
        }
    }

    public List<String> formatBacktrace(RubyContext context, DynamicObject exception, Backtrace backtrace) {
        if (backtrace == null) {
            backtrace = context.getCallStack().getBacktrace(null);
        }
        List<Activation> activations = backtrace.getActivations();
        ArrayList<String> lines = new ArrayList<String>();
        for (int n = 0; n < activations.size(); ++n) {
            try {
                lines.add(this.formatLine(activations, n, exception));
                continue;
            }
            catch (Exception e) {
                if (context.getOptions().EXCEPTIONS_PRINT_JAVA) {
                    e.printStackTrace();
                }
                lines.add(StringUtils.format("(exception %s %s", e.getMessage(), e.getStackTrace()[0].toString()));
            }
        }
        if (backtrace.getJavaThrowable() != null && this.flags.contains((Object)FormattingFlags.INTERLEAVE_JAVA)) {
            return BacktraceInterleaver.interleave(lines, backtrace.getJavaThrowable().getStackTrace());
        }
        return lines;
    }

    public String formatLine(List<Activation> activations, int n, DynamicObject exception) {
        RootNode rootNode;
        Activation activation = activations.get(n);
        if (activation == Activation.OMITTED_LIMIT) {
            return this.context.getCoreStrings().BACKTRACE_OMITTED_LIMIT.toString();
        }
        if (activation == Activation.OMITTED_UNUSED) {
            return this.context.getCoreStrings().BACKTRACE_OMITTED_UNUSED.toString();
        }
        StringBuilder builder = new StringBuilder();
        if (!this.flags.contains((Object)FormattingFlags.OMIT_FROM_PREFIX) && n > 0) {
            builder.append("\tfrom ");
        }
        if ((rootNode = activation.getCallNode().getRootNode().getRootNode()) instanceof RubyRootNode) {
            String reportedName;
            SourceSection reportedSourceSection;
            SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
            if (this.isJavaCore(sourceSection) || BacktraceFormatter.isCore(this.context, sourceSection) && !this.flags.contains((Object)FormattingFlags.INCLUDE_CORE_FILES)) {
                SourceSection nextUserSourceSection = this.nextUserSourceSection(activations, n);
                reportedSourceSection = nextUserSourceSection != null ? nextUserSourceSection : sourceSection;
                reportedName = this.getMethodNameFromActivation(activation);
            } else {
                reportedSourceSection = sourceSection;
                reportedName = rootNode.getName();
            }
            if (reportedSourceSection == null) {
                builder.append("???");
            } else {
                builder.append(reportedSourceSection.getSource().getName());
                builder.append(":");
                builder.append(reportedSourceSection.getStartLine());
            }
            builder.append(":in `");
            builder.append(reportedName);
            builder.append("'");
        } else {
            builder.append(this.formatForeign(activation.getCallNode()));
        }
        if (!this.flags.contains((Object)FormattingFlags.OMIT_EXCEPTION) && exception != null && n == 0) {
            String message;
            try {
                Object messageObject = this.context.send(exception, "message", null, new Object[0]);
                message = RubyGuards.isRubyString(messageObject) ? messageObject.toString() : Layouts.EXCEPTION.getMessage(exception).toString();
            }
            catch (RaiseException e) {
                message = Layouts.EXCEPTION.getMessage(exception).toString();
            }
            builder.append(": ");
            builder.append(message);
            builder.append(" (");
            builder.append(Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(exception)).getName());
            builder.append(")");
        }
        return builder.toString();
    }

    private String getMethodNameFromActivation(Activation activation) {
        try {
            return activation.getMethod().getName();
        }
        catch (Exception e) {
            return "???";
        }
    }

    private SourceSection nextUserSourceSection(List<Activation> activations, int n) {
        while (n < activations.size()) {
            SourceSection sourceSection;
            Node callNode = activations.get(n).getCallNode();
            if (callNode != null && !BacktraceFormatter.isCore(this.context, sourceSection = callNode.getEncapsulatingSourceSection())) {
                return sourceSection;
            }
            ++n;
        }
        return null;
    }

    public boolean isJavaCore(SourceSection sourceSection) {
        return sourceSection == this.context.getCoreLibrary().getSourceSection();
    }

    public static boolean isCore(RubyContext context, SourceSection sourceSection) {
        if (sourceSection == null) {
            return true;
        }
        if (sourceSection.getSource() == context.getCoreLibrary().getSource()) {
            return true;
        }
        Source source = sourceSection.getSource();
        if (source == null) {
            return true;
        }
        String path = source.getPath();
        if (path != null) {
            return path.startsWith("truffle:");
        }
        String name = source.getName();
        if (name != null) {
            return name.startsWith("truffle:");
        }
        return true;
    }

    public static boolean isUserSourceSection(RubyContext context, SourceSection sourceSection) {
        if (!BacktraceFormatter.isCore(context, sourceSection)) {
            return false;
        }
        String path = sourceSection.getSource().getPath();
        if (path.startsWith(context.getCoreLibrary().getCoreLoadPath())) {
            return false;
        }
        return path.indexOf("/lib/ruby/stdlib/rubygems") == -1;
    }

    private String formatForeign(Node callNode) {
        StringBuilder builder = new StringBuilder();
        SourceSection sourceSection = callNode.getEncapsulatingSourceSection();
        if (sourceSection != null) {
            String shortDescription = RubyLanguage.fileLine(sourceSection);
            builder.append(shortDescription);
            RootNode rootNode = callNode.getRootNode();
            String identifier = rootNode.getName();
            if (identifier != null && !identifier.isEmpty()) {
                builder.append(":in `");
                builder.append(identifier);
                builder.append("'");
            }
        } else {
            builder.append(this.getRootOrTopmostNode(callNode).getClass().getSimpleName());
        }
        return builder.toString();
    }

    private Node getRootOrTopmostNode(Node node) {
        while (node.getParent() != null) {
            node = node.getParent();
        }
        return node;
    }

    public static enum FormattingFlags {
        OMIT_EXCEPTION,
        OMIT_FROM_PREFIX,
        INCLUDE_CORE_FILES,
        INTERLEAVE_JAVA;

    }
}

