/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.constants;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.string.StringUtils;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.constants.GetConstantNodeGen;
import org.jruby.truffle.language.constants.LookupConstantInterface;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.loader.RequireNode;
import org.jruby.truffle.parser.Identifiers;

@NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name"), @NodeChild(value="constant"), @NodeChild(value="lookupConstantNode")})
public abstract class GetConstantNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode constMissingNode;

    public static GetConstantNode create() {
        return GetConstantNodeGen.create(null, null, null, null);
    }

    public abstract Object executeGetConstant(VirtualFrame var1, Object var2, String var3, RubyConstant var4, LookupConstantInterface var5);

    @Specialization(guards={"constant != null", "!constant.isAutoload()"})
    protected Object getConstant(DynamicObject module, String name, RubyConstant constant, LookupConstantInterface lookupConstantNode) {
        return constant.getValue();
    }

    @Specialization(guards={"constant != null", "constant.isAutoload()"})
    protected Object autoloadConstant(VirtualFrame frame, DynamicObject module, String name, RubyConstant constant, LookupConstantInterface lookupConstantNode, @Cached(value="create()") RequireNode requireNode) {
        DynamicObject path = (DynamicObject)constant.getValue();
        Layouts.MODULE.getFields(constant.getDeclaringModule()).removeConstant(this.getContext(), this, name);
        try {
            requireNode.executeRequire(frame, StringOperations.getString(path));
            RubyConstant resolvedConstant = lookupConstantNode.lookupConstant(frame, module, name);
            return this.executeGetConstant(frame, module, name, resolvedConstant, lookupConstantNode);
        }
        catch (RaiseException e) {
            Layouts.MODULE.getFields(constant.getDeclaringModule()).setAutoloadConstant(this.getContext(), this, name, path);
            throw e;
        }
    }

    @Specialization(guards={"constant == null", "guardName(name, cachedName, sameNameProfile)"}, limit="getCacheLimit()")
    protected Object missingConstantCached(VirtualFrame frame, DynamicObject module, String name, Object constant, LookupConstantInterface lookupConstantNode, @Cached(value="name") String cachedName, @Cached(value="isValidConstantName(name)") boolean isValidConstantName, @Cached(value="getSymbol(name)") DynamicObject symbolName, @Cached(value="createBinaryProfile()") ConditionProfile sameNameProfile) {
        return this.doMissingConstant(frame, module, name, isValidConstantName, symbolName);
    }

    @Specialization(guards={"constant == null"})
    protected Object missingConstantUncached(VirtualFrame frame, DynamicObject module, String name, Object constant, LookupConstantInterface lookupConstantNode, @Cached(value="createBinaryProfile()") ConditionProfile validNameProfile) {
        boolean isValidConstantName = validNameProfile.profile(this.isValidConstantName(name));
        return this.doMissingConstant(frame, module, name, isValidConstantName, this.getSymbol(name));
    }

    private Object doMissingConstant(VirtualFrame frame, DynamicObject module, String name, boolean isValidConstantName, DynamicObject symbolName) {
        if (!isValidConstantName) {
            throw new RaiseException(this.coreExceptions().nameError(this.formatError(name), module, name, this));
        }
        if (this.constMissingNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.constMissingNode = this.insert(DispatchHeadNodeFactory.createMethodCall());
        }
        return this.constMissingNode.call(frame, module, "const_missing", symbolName);
    }

    @CompilerDirectives.TruffleBoundary
    private String formatError(String name) {
        return StringUtils.format("wrong constant name %s", name);
    }

    protected boolean isValidConstantName(String name) {
        return Identifiers.isValidConstantName19(name);
    }

    protected boolean guardName(String name, String cachedName, ConditionProfile sameNameProfile) {
        if (sameNameProfile.profile(name == cachedName)) {
            return true;
        }
        return name.equals(cachedName);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().CONSTANT_CACHE;
    }
}

