/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.globals.GlobalVariableStorage;

public abstract class ReadGlobalVariableNode
extends RubyNode {
    private final String name;

    public ReadGlobalVariableNode(String name) {
        this.name = name;
    }

    @Specialization(assumptions={"storage.getUnchangedAssumption()"})
    public Object readConstant(@Cached(value="getStorage()") GlobalVariableStorage storage, @Cached(value="storage.getValue()") Object value) {
        return value;
    }

    @Specialization
    public Object read(@Cached(value="getStorage()") GlobalVariableStorage storage) {
        return storage.getValue();
    }

    protected GlobalVariableStorage getStorage() {
        return this.getContext().getCoreLibrary().getGlobalVariables().getStorage(this.name);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        if (this.coreLibrary().getGlobalVariables().get(this.name) != this.nil()) {
            return this.coreStrings().GLOBAL_VARIABLE.createInstance();
        }
        return this.nil();
    }
}

