/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public class ArgsCatParseNode
extends ParseNode {
    private final ParseNode firstNode;
    private final ParseNode secondNode;

    public ArgsCatParseNode(SourceIndexLength position, ParseNode firstNode, ParseNode secondNode) {
        super(position, firstNode.containsVariableAssignment() || secondNode.containsVariableAssignment());
        assert (firstNode != null) : "ArgsCatParseNode.first == null";
        assert (secondNode != null) : "ArgsCatParseNode.second == null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSCATNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitArgsCatNode(this);
    }

    public ParseNode getFirstNode() {
        return this.firstNode;
    }

    public ParseNode getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.firstNode, this.secondNode);
    }
}

