/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.AssignableParseNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.types.INameNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public class ConstDeclParseNode
extends AssignableParseNode
implements INameNode {
    private final String name;
    private final INameNode constNode;

    public ConstDeclParseNode(SourceIndexLength position, String name, INameNode constNode, ParseNode valueNode) {
        super(position, valueNode, valueNode != null && valueNode.containsVariableAssignment());
        this.name = name;
        this.constNode = constNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CONSTDECLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitConstDeclNode(this);
    }

    @Override
    public String getName() {
        return this.name == null ? this.constNode.getName() : this.name;
    }

    public ParseNode getConstNode() {
        return (ParseNode)((Object)this.constNode);
    }

    @Override
    public List<ParseNode> childNodes() {
        return ConstDeclParseNode.createList(this.getConstNode(), this.getValueNode());
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

