/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.collections.Tuple;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.types.ILiteralNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public class HashParseNode
extends ParseNode
implements ILiteralNode {
    private final List<Tuple<ParseNode, ParseNode>> pairs = new ArrayList<Tuple<ParseNode, ParseNode>>();

    public HashParseNode(SourceIndexLength position) {
        super(position, false);
    }

    public HashParseNode(SourceIndexLength position, Tuple<ParseNode, ParseNode> pair) {
        this(position);
        this.pairs.add(pair);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.HASHNODE;
    }

    public HashParseNode add(Tuple<ParseNode, ParseNode> pair) {
        if (pair.getKey() != null && pair.getKey().containsVariableAssignment() || pair.getValue() != null && pair.getValue().containsVariableAssignment()) {
            this.containsVariableAssignment = true;
        }
        this.pairs.add(pair);
        return this;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitHashNode(this);
    }

    public boolean isEmpty() {
        return this.pairs.isEmpty();
    }

    public List<Tuple<ParseNode, ParseNode>> getPairs() {
        return this.pairs;
    }

    @Override
    public List<ParseNode> childNodes() {
        ArrayList<ParseNode> children = new ArrayList<ParseNode>();
        for (Tuple<ParseNode, ParseNode> pair : this.pairs) {
            children.add(pair.getKey());
            children.add(pair.getValue());
        }
        return children;
    }
}

