/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.lexer;

import java.io.IOException;
import org.jcodings.Encoding;
import org.jruby.truffle.parser.ParserByteList;
import org.jruby.truffle.parser.ParserByteListBuilder;
import org.jruby.truffle.parser.lexer.RubyLexer;
import org.jruby.truffle.parser.lexer.StrTerm;
import org.jruby.truffle.parser.lexer.StringTerm;

public class HeredocTerm
extends StrTerm {
    private final ParserByteList nd_lit;
    private final int flags;
    protected final int nth;
    protected final int line;
    protected final ParserByteList lastLine;

    public HeredocTerm(ParserByteList marker, int func, int nth, int line, ParserByteList lastLine) {
        this.nd_lit = marker;
        this.flags = func;
        this.nth = nth;
        this.line = line;
        this.lastLine = lastLine;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    protected int error(RubyLexer lexer, int len, ParserByteList str, ParserByteList eos) {
        lexer.compile_error("can't find string \"" + eos.toString() + "\" anywhere before EOF");
        return -1;
    }

    protected int restore(RubyLexer lexer) {
        lexer.heredoc_restore(this);
        lexer.setStrTerm(null);
        return -1;
    }

    @Override
    public int parseString(RubyLexer lexer) throws IOException {
        ParserByteListBuilder str = null;
        ParserByteList eos = this.nd_lit;
        int len = this.nd_lit.getLength() - 1;
        boolean indent = (this.flags & 0x20) != 0;
        int c = lexer.nextc();
        if (c == -1) {
            return this.error(lexer, len, str.toParserByteList(), eos);
        }
        if (lexer.was_bol() && lexer.whole_match_p(this.nd_lit, indent)) {
            lexer.heredoc_restore(this);
            return 373;
        }
        if ((this.flags & 2) == 0) {
            do {
                ParserByteList lbuf = lexer.lex_lastline;
                int pend = lexer.lex_pend;
                int p = 0;
                if (pend > p) {
                    switch (lexer.p(pend - 1)) {
                        case 10: {
                            if (--pend != p && lexer.p(pend - 1) != 13) break;
                            ++pend;
                            break;
                        }
                        case 13: {
                            --pend;
                        }
                    }
                }
                if (lexer.getHeredocIndent() > 0) {
                    long i = 0L;
                    while ((long)p + i < (long)pend && lexer.update_heredoc_indent(lexer.p(p))) {
                        ++i;
                    }
                    lexer.setHeredocLineIndent(0);
                }
                if (str != null) {
                    str.append(lbuf.makeShared(p, pend - p));
                } else {
                    ParserByteListBuilder builder = new ParserByteListBuilder();
                    builder.append(lbuf.makeShared(p, pend - p));
                    str = builder;
                }
                if (pend < lexer.lex_pend) {
                    str.append(10);
                }
                lexer.lex_goto_eol();
                if (lexer.getHeredocIndent() > 0) {
                    lexer.setValue(lexer.createStr(str, 0));
                    return 378;
                }
                if (lexer.nextc() != -1) continue;
                return this.error(lexer, len, null, eos);
            } while (!lexer.whole_match_p(eos, indent));
        } else {
            ParserByteListBuilder tok = new ParserByteListBuilder();
            tok.setEncoding(lexer.getEncoding());
            if (c == 35) {
                c = lexer.nextc();
                switch (c) {
                    case 36: 
                    case 64: {
                        lexer.pushback(c);
                        return 372;
                    }
                    case 123: {
                        lexer.commandStart = true;
                        return 371;
                    }
                }
                tok.append(35);
            }
            do {
                lexer.pushback(c);
                Encoding[] enc = new Encoding[]{lexer.getEncoding()};
                c = new StringTerm(this.flags, 0, 10).parseStringIntoBuffer(lexer, tok, enc);
                if (c == -1) {
                    if (lexer.eofp) {
                        return this.error(lexer, len, str.toParserByteList(), eos);
                    }
                    return this.restore(lexer);
                }
                if (c != 10) {
                    lexer.setValue(lexer.createStr(tok, 0));
                    return 378;
                }
                tok.append(lexer.nextc());
                if (lexer.getHeredocIndent() > 0) {
                    lexer.lex_goto_eol();
                    lexer.setValue(lexer.createStr(tok, 0));
                    return 378;
                }
                c = lexer.nextc();
                if (c != -1) continue;
                return this.error(lexer, len, str.toParserByteList(), eos);
            } while (!lexer.whole_match_p(eos, indent));
            str = tok;
        }
        lexer.heredoc_restore(this);
        lexer.setStrTerm(new StringTerm(-1, 0, 0));
        lexer.setValue(lexer.createStr(str, 0));
        return 378;
    }
}

