/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.parser;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.EUCJPEncoding;
import org.jcodings.specific.SJISEncoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.collections.Tuple;
import org.jruby.truffle.core.regexp.ClassicRegexp;
import org.jruby.truffle.core.regexp.RegexpOptions;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.parser.ParserByteList;
import org.jruby.truffle.parser.RubyWarnings;
import org.jruby.truffle.parser.Signature;
import org.jruby.truffle.parser.ast.AliasParseNode;
import org.jruby.truffle.parser.ast.AndParseNode;
import org.jruby.truffle.parser.ast.ArgsCatParseNode;
import org.jruby.truffle.parser.ast.ArgsParseNode;
import org.jruby.truffle.parser.ast.ArgsPushParseNode;
import org.jruby.truffle.parser.ast.ArgumentParseNode;
import org.jruby.truffle.parser.ast.ArrayParseNode;
import org.jruby.truffle.parser.ast.AssignableParseNode;
import org.jruby.truffle.parser.ast.AttrAssignParseNode;
import org.jruby.truffle.parser.ast.BackRefParseNode;
import org.jruby.truffle.parser.ast.BeginParseNode;
import org.jruby.truffle.parser.ast.BignumParseNode;
import org.jruby.truffle.parser.ast.BinaryOperatorParseNode;
import org.jruby.truffle.parser.ast.BlockArgParseNode;
import org.jruby.truffle.parser.ast.BlockParseNode;
import org.jruby.truffle.parser.ast.BlockPassParseNode;
import org.jruby.truffle.parser.ast.CallParseNode;
import org.jruby.truffle.parser.ast.CaseParseNode;
import org.jruby.truffle.parser.ast.ClassVarParseNode;
import org.jruby.truffle.parser.ast.Colon2ConstParseNode;
import org.jruby.truffle.parser.ast.Colon2ImplicitParseNode;
import org.jruby.truffle.parser.ast.Colon2ParseNode;
import org.jruby.truffle.parser.ast.Colon3ParseNode;
import org.jruby.truffle.parser.ast.ComplexParseNode;
import org.jruby.truffle.parser.ast.ConstParseNode;
import org.jruby.truffle.parser.ast.DAsgnParseNode;
import org.jruby.truffle.parser.ast.DRegexpParseNode;
import org.jruby.truffle.parser.ast.DStrParseNode;
import org.jruby.truffle.parser.ast.DSymbolParseNode;
import org.jruby.truffle.parser.ast.DefinedParseNode;
import org.jruby.truffle.parser.ast.DotParseNode;
import org.jruby.truffle.parser.ast.EvStrParseNode;
import org.jruby.truffle.parser.ast.FCallParseNode;
import org.jruby.truffle.parser.ast.FalseParseNode;
import org.jruby.truffle.parser.ast.FixnumParseNode;
import org.jruby.truffle.parser.ast.FlipParseNode;
import org.jruby.truffle.parser.ast.FloatParseNode;
import org.jruby.truffle.parser.ast.GlobalAsgnParseNode;
import org.jruby.truffle.parser.ast.GlobalVarParseNode;
import org.jruby.truffle.parser.ast.HashParseNode;
import org.jruby.truffle.parser.ast.IArgumentNode;
import org.jruby.truffle.parser.ast.IfParseNode;
import org.jruby.truffle.parser.ast.InstAsgnParseNode;
import org.jruby.truffle.parser.ast.InstVarParseNode;
import org.jruby.truffle.parser.ast.KeywordArgParseNode;
import org.jruby.truffle.parser.ast.KeywordRestArgParseNode;
import org.jruby.truffle.parser.ast.ListParseNode;
import org.jruby.truffle.parser.ast.LocalAsgnParseNode;
import org.jruby.truffle.parser.ast.Match2CaptureParseNode;
import org.jruby.truffle.parser.ast.Match2ParseNode;
import org.jruby.truffle.parser.ast.Match3ParseNode;
import org.jruby.truffle.parser.ast.MatchParseNode;
import org.jruby.truffle.parser.ast.MultipleAsgnParseNode;
import org.jruby.truffle.parser.ast.NilImplicitParseNode;
import org.jruby.truffle.parser.ast.NilParseNode;
import org.jruby.truffle.parser.ast.NthRefParseNode;
import org.jruby.truffle.parser.ast.NumericParseNode;
import org.jruby.truffle.parser.ast.OpAsgnConstDeclParseNode;
import org.jruby.truffle.parser.ast.OpAsgnParseNode;
import org.jruby.truffle.parser.ast.OpElementAsgnParseNode;
import org.jruby.truffle.parser.ast.OrParseNode;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.RationalParseNode;
import org.jruby.truffle.parser.ast.RegexpParseNode;
import org.jruby.truffle.parser.ast.RescueBodyParseNode;
import org.jruby.truffle.parser.ast.RescueModParseNode;
import org.jruby.truffle.parser.ast.RestArgParseNode;
import org.jruby.truffle.parser.ast.RootParseNode;
import org.jruby.truffle.parser.ast.SValueParseNode;
import org.jruby.truffle.parser.ast.SplatParseNode;
import org.jruby.truffle.parser.ast.StrParseNode;
import org.jruby.truffle.parser.ast.SuperParseNode;
import org.jruby.truffle.parser.ast.SymbolParseNode;
import org.jruby.truffle.parser.ast.TrueParseNode;
import org.jruby.truffle.parser.ast.UndefParseNode;
import org.jruby.truffle.parser.ast.WhenOneArgParseNode;
import org.jruby.truffle.parser.ast.WhenParseNode;
import org.jruby.truffle.parser.ast.YieldParseNode;
import org.jruby.truffle.parser.ast.types.ILiteralNode;
import org.jruby.truffle.parser.ast.types.INameNode;
import org.jruby.truffle.parser.lexer.RubyLexer;
import org.jruby.truffle.parser.lexer.SyntaxException;
import org.jruby.truffle.parser.parser.ArgsTailHolder;
import org.jruby.truffle.parser.parser.ParserConfiguration;
import org.jruby.truffle.parser.parser.RubyParserResult;
import org.jruby.truffle.parser.scope.DynamicScope;
import org.jruby.truffle.parser.scope.StaticScope;

public class ParserSupport {
    protected StaticScope currentScope;
    protected RubyLexer lexer;
    private int inSingleton;
    private boolean inDefinition;
    protected RubyWarnings warnings;
    protected ParserConfiguration configuration;
    private RubyParserResult result;
    private final RubyContext context;
    private String file;
    private static final int BIT_SIZE = 64;
    private static final long MAX = Long.MAX_VALUE;
    public static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);

    public ParserSupport(RubyContext context, String file) {
        this.context = context;
        this.file = file;
    }

    public RubyContext getContext() {
        return this.context;
    }

    public void reset() {
        this.inSingleton = 0;
        this.inDefinition = false;
    }

    public StaticScope getCurrentScope() {
        return this.currentScope;
    }

    public ParserConfiguration getConfiguration() {
        return this.configuration;
    }

    public void popCurrentScope() {
        if (!this.currentScope.isBlockScope()) {
            this.lexer.getCmdArgumentState().reset(this.currentScope.getCommandArgumentStack());
        }
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    public void pushBlockScope() {
        this.currentScope = new StaticScope(StaticScope.Type.BLOCK, this.currentScope, this.lexer.getFile());
    }

    public void pushLocalScope() {
        this.currentScope = new StaticScope(StaticScope.Type.LOCAL, this.currentScope, this.lexer.getFile());
        this.currentScope.setCommandArgumentStack(this.lexer.getCmdArgumentState().getStack());
        this.lexer.getCmdArgumentState().reset(0L);
    }

    public ParseNode arg_concat(SourceIndexLength position, ParseNode node1, ParseNode node2) {
        return node2 == null ? node1 : new ArgsCatParseNode(position, node1, node2);
    }

    public ParseNode arg_blk_pass(ParseNode firstNode, BlockPassParseNode secondNode) {
        if (secondNode != null) {
            secondNode.setArgsNode(firstNode);
            return secondNode;
        }
        return firstNode;
    }

    public ParseNode gettable2(ParseNode node) {
        switch (node.getNodeType()) {
            case DASGNNODE: 
            case LOCALASGNNODE: {
                String name = ((INameNode)((Object)node)).getName();
                if (name.equals(this.lexer.getCurrentArg())) {
                    this.warn(RubyWarnings.ID.AMBIGUOUS_ARGUMENT, node.getPosition(), "circular argument reference - " + name, new Object[0]);
                }
                return this.currentScope.declare(node.getPosition(), name);
            }
            case CONSTDECLNODE: {
                return new ConstParseNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case INSTASGNNODE: {
                return new InstVarParseNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case CLASSVARDECLNODE: 
            case CLASSVARASGNNODE: {
                return new ClassVarParseNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case GLOBALASGNNODE: {
                return new GlobalVarParseNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
        }
        this.getterIdentifierError(node.getPosition(), ((INameNode)((Object)node)).getName());
        return null;
    }

    public ParseNode declareIdentifier(String name) {
        if (name.equals(this.lexer.getCurrentArg())) {
            this.warn(RubyWarnings.ID.AMBIGUOUS_ARGUMENT, this.lexer.getPosition(), "circular argument reference - " + name, new Object[0]);
        }
        return this.currentScope.declare(this.lexer.tokline, name);
    }

    public AssignableParseNode assignableLabelOrIdentifier(String name, ParseNode value) {
        return this.currentScope.assign(this.lexer.getPosition(), name.intern(), this.makeNullNil(value));
    }

    public AssignableParseNode assignableLabel(String name, ParseNode value) {
        return this.currentScope.assign(this.lexer.getPosition(), name, this.makeNullNil(value));
    }

    protected void getterIdentifierError(SourceIndexLength position, String identifier) {
        this.lexer.compile_error(SyntaxException.PID.BAD_IDENTIFIER, "identifier " + identifier + " is not valid to get");
    }

    public ParseNode newline_node(ParseNode node, SourceIndexLength position) {
        if (node == null) {
            return null;
        }
        node.setNewline();
        return node;
    }

    public ParseNode addRootNode(ParseNode topOfAST) {
        SourceIndexLength position;
        int endPosition = this.lexer.isEndSeen() ? this.lexer.getLineOffset() : -1;
        if (this.result.getBeginNodes().isEmpty()) {
            if (topOfAST == null) {
                topOfAST = NilImplicitParseNode.NIL;
                position = this.lexer.getPosition();
            } else {
                position = topOfAST.getPosition();
            }
        } else {
            position = topOfAST != null ? topOfAST.getPosition() : this.result.getBeginNodes().get(0).getPosition();
            BlockParseNode newTopOfAST = new BlockParseNode(position);
            for (ParseNode beginNode : this.result.getBeginNodes()) {
                this.appendToBlock(newTopOfAST, beginNode);
            }
            if (topOfAST != null) {
                newTopOfAST.add(topOfAST);
            }
            topOfAST = newTopOfAST;
        }
        return new RootParseNode(position, this.result.getScope(), topOfAST, this.lexer.getFile(), endPosition, false);
    }

    public ParseNode appendToBlock(ParseNode head, ParseNode tail) {
        if (tail == null) {
            return head;
        }
        if (head == null) {
            return tail;
        }
        if (!(head instanceof BlockParseNode)) {
            head = new BlockParseNode(head.getPosition()).add(head);
        }
        if (this.warnings.isVerbose() && this.isBreakStatement(((ListParseNode)head).getLast())) {
            this.warnings.warning(RubyWarnings.ID.STATEMENT_NOT_REACHED, this.file, tail.getPosition().toSourceSection(this.lexer.getSource()).getStartLine(), "statement not reached");
        }
        ((ListParseNode)head).addAll(tail);
        return head;
    }

    public AssignableParseNode assignableInCurr(String name, ParseNode value) {
        this.currentScope.addVariableThisScope(name);
        return this.currentScope.assign(this.lexer.getPosition(), name, this.makeNullNil(value));
    }

    public ParseNode getOperatorCallNode(ParseNode firstNode, String operator) {
        this.checkExpression(firstNode);
        return new CallParseNode(firstNode.getPosition(), firstNode, operator, null, null);
    }

    public ParseNode getOperatorCallNode(ParseNode firstNode, String operator, ParseNode secondNode) {
        return this.getOperatorCallNode(firstNode, operator, secondNode, null);
    }

    public ParseNode getOperatorCallNode(ParseNode firstNode, String operator, ParseNode secondNode, SourceIndexLength defaultPosition) {
        if (defaultPosition != null) {
            firstNode = this.checkForNilNode(firstNode, defaultPosition);
            secondNode = this.checkForNilNode(secondNode, defaultPosition);
        }
        this.checkExpression(firstNode);
        this.checkExpression(secondNode);
        return new CallParseNode(firstNode.getPosition(), firstNode, operator, new ArrayParseNode(secondNode.getPosition(), secondNode), null);
    }

    public ParseNode getMatchNode(ParseNode firstNode, ParseNode secondNode) {
        if (firstNode instanceof DRegexpParseNode) {
            return new Match2ParseNode(firstNode.getPosition(), firstNode, secondNode);
        }
        if (firstNode instanceof RegexpParseNode) {
            List<Integer> locals = this.allocateNamedLocals((RegexpParseNode)firstNode);
            if (locals.size() > 0) {
                int[] primitiveLocals = new int[locals.size()];
                for (int i = 0; i < primitiveLocals.length; ++i) {
                    primitiveLocals[i] = locals.get(i);
                }
                return new Match2CaptureParseNode(firstNode.getPosition(), firstNode, secondNode, primitiveLocals);
            }
            return new Match2ParseNode(firstNode.getPosition(), firstNode, secondNode);
        }
        if (secondNode instanceof DRegexpParseNode || secondNode instanceof RegexpParseNode) {
            return new Match3ParseNode(firstNode.getPosition(), firstNode, secondNode);
        }
        return this.getOperatorCallNode(firstNode, "=~", secondNode);
    }

    public ParseNode aryset(ParseNode receiver, ParseNode index) {
        this.checkExpression(receiver);
        return this.new_attrassign(receiver.getPosition(), receiver, "[]=", index, false);
    }

    public ParseNode attrset(ParseNode receiver, String name) {
        return this.attrset(receiver, ".", name);
    }

    public ParseNode attrset(ParseNode receiver, String callType, String name) {
        this.checkExpression(receiver);
        return this.new_attrassign(receiver.getPosition(), receiver, name + "=", null, this.isLazy(callType));
    }

    public void backrefAssignError(ParseNode node) {
        if (node instanceof NthRefParseNode) {
            String varName = "$" + ((NthRefParseNode)node).getMatchNumber();
            this.lexer.compile_error(SyntaxException.PID.INVALID_ASSIGNMENT, "Can't set variable " + varName + '.');
        } else if (node instanceof BackRefParseNode) {
            String varName = "$" + ((BackRefParseNode)node).getType();
            this.lexer.compile_error(SyntaxException.PID.INVALID_ASSIGNMENT, "Can't set variable " + varName + '.');
        }
    }

    public ParseNode arg_add(SourceIndexLength position, ParseNode node1, ParseNode node2) {
        if (node1 == null) {
            if (node2 == null) {
                return new ArrayParseNode(position, NilImplicitParseNode.NIL);
            }
            return new ArrayParseNode(node2.getPosition(), node2);
        }
        if (node1 instanceof ArrayParseNode) {
            return ((ArrayParseNode)node1).add(node2);
        }
        return new ArgsPushParseNode(position, node1, node2);
    }

    public ParseNode node_assign(ParseNode lhs, ParseNode rhs) {
        if (lhs == null) {
            return null;
        }
        ParseNode newNode = lhs;
        this.checkExpression(rhs);
        if (lhs instanceof AssignableParseNode) {
            ((AssignableParseNode)lhs).setValueNode(rhs);
        } else if (lhs instanceof IArgumentNode) {
            IArgumentNode invokableNode = (IArgumentNode)((Object)lhs);
            return invokableNode.setArgsNode(this.arg_add(lhs.getPosition(), invokableNode.getArgsNode(), rhs));
        }
        return newNode;
    }

    public ParseNode ret_args(ParseNode node, SourceIndexLength position) {
        if (node != null) {
            if (node instanceof BlockPassParseNode) {
                this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, "block argument should not be given");
            } else if (node instanceof ArrayParseNode && ((ArrayParseNode)node).size() == 1) {
                node = ((ArrayParseNode)node).get(0);
            } else if (node instanceof SplatParseNode) {
                node = this.newSValueNode(position, node);
            }
        }
        if (node == null) {
            node = NilImplicitParseNode.NIL;
        }
        return node;
    }

    public boolean isBreakStatement(ParseNode node) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case BREAKNODE: 
            case NEXTNODE: 
            case REDONODE: 
            case RETRYNODE: 
            case RETURNNODE: {
                return true;
            }
        }
        return false;
    }

    public void warnUnlessEOption(RubyWarnings.ID id, ParseNode node, String message) {
        if (!this.configuration.isInlineSource()) {
            this.warnings.warn(id, this.file, node.getPosition().toSourceSection(this.lexer.getSource()).getStartLine(), message);
        }
    }

    public void warningUnlessEOption(RubyWarnings.ID id, ParseNode node, String message) {
        if (this.warnings.isVerbose() && !this.configuration.isInlineSource()) {
            this.warnings.warning(id, this.file, node.getPosition().toSourceSection(this.lexer.getSource()).getStartLine(), message);
        }
    }

    public boolean checkExpression(ParseNode node) {
        boolean conditional = false;
        block7: while (node != null) {
            switch (node.getNodeType()) {
                case BREAKNODE: 
                case NEXTNODE: 
                case REDONODE: 
                case RETRYNODE: 
                case RETURNNODE: {
                    if (!conditional) {
                        this.lexer.compile_error(SyntaxException.PID.VOID_VALUE_EXPRESSION, "void value expression");
                    }
                    return false;
                }
                case BLOCKNODE: {
                    node = ((BlockParseNode)node).getLast();
                    continue block7;
                }
                case BEGINNODE: {
                    node = ((BeginParseNode)node).getBodyNode();
                    continue block7;
                }
                case IFNODE: {
                    if (!this.checkExpression(((IfParseNode)node).getThenBody())) {
                        return false;
                    }
                    node = ((IfParseNode)node).getElseBody();
                    continue block7;
                }
                case ANDNODE: 
                case ORNODE: {
                    conditional = true;
                    node = ((BinaryOperatorParseNode)((Object)node)).getSecondNode();
                    continue block7;
                }
            }
            return true;
        }
        return true;
    }

    public boolean isLiteral(ParseNode node) {
        return node != null && (node instanceof FixnumParseNode || node instanceof BignumParseNode || node instanceof FloatParseNode || node instanceof SymbolParseNode || node instanceof RegexpParseNode && ((RegexpParseNode)node).getOptions().toJoniOptions() == 0);
    }

    private void handleUselessWarn(ParseNode node, String useless) {
        this.warnings.warn(RubyWarnings.ID.USELESS_EXPRESSION, this.file, node.getPosition().toSourceSection(this.lexer.getSource()).getStartLine(), "Useless use of " + useless + " in void context.");
    }

    public void checkUselessStatement(ParseNode node) {
        if (!this.warnings.isVerbose() || !this.configuration.isInlineSource() && this.configuration.isEvalParse()) {
            return;
        }
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case CALLNODE: {
                String name = ((CallParseNode)node).getName();
                if (name == "+" || name == "-" || name == "*" || name == "/" || name == "%" || name == "**" || name == "+@" || name == "-@" || name == "|" || name == "^" || name == "&" || name == "<=>" || name == ">" || name == ">=" || name == "<" || name == "<=" || name == "==" || name == "!=") {
                    this.handleUselessWarn(node, name);
                }
                return;
            }
            case BACKREFNODE: 
            case DVARNODE: 
            case GLOBALVARNODE: 
            case LOCALVARNODE: 
            case NTHREFNODE: 
            case CLASSVARNODE: 
            case INSTVARNODE: {
                this.handleUselessWarn(node, "a variable");
                return;
            }
            case BIGNUMNODE: 
            case DREGEXPNODE: 
            case DSTRNODE: 
            case DSYMBOLNODE: 
            case FIXNUMNODE: 
            case FLOATNODE: 
            case REGEXPNODE: 
            case STRNODE: 
            case SYMBOLNODE: {
                this.handleUselessWarn(node, "a literal");
                return;
            }
            case DOTNODE: {
                this.handleUselessWarn(node, ((DotParseNode)node).isExclusive() ? "..." : "..");
                return;
            }
            case DEFINEDNODE: {
                this.handleUselessWarn(node, "defined?");
                return;
            }
            case FALSENODE: {
                this.handleUselessWarn(node, "false");
                return;
            }
            case NILNODE: {
                this.handleUselessWarn(node, "nil");
                return;
            }
            case TRUENODE: {
                this.handleUselessWarn(node, "true");
                return;
            }
        }
    }

    public void checkUselessStatements(BlockParseNode blockNode) {
        if (this.warnings.isVerbose()) {
            ParseNode lastNode = blockNode.getLast();
            for (int i = 0; i < blockNode.size(); ++i) {
                ParseNode currentNode = blockNode.get(i);
                if (lastNode == currentNode) continue;
                this.checkUselessStatement(currentNode);
            }
        }
    }

    private boolean checkAssignmentInCondition(ParseNode node) {
        if (node instanceof MultipleAsgnParseNode) {
            this.lexer.compile_error(SyntaxException.PID.MULTIPLE_ASSIGNMENT_IN_CONDITIONAL, "multiple assignment in conditional");
        } else if (node instanceof LocalAsgnParseNode || node instanceof DAsgnParseNode || node instanceof GlobalAsgnParseNode || node instanceof InstAsgnParseNode) {
            ParseNode valueNode = ((AssignableParseNode)node).getValueNode();
            if (this.isStaticContent(valueNode)) {
                this.warnings.warn(RubyWarnings.ID.ASSIGNMENT_IN_CONDITIONAL, this.file, node.getPosition().toSourceSection(this.lexer.getSource()).getStartLine(), "found = in conditional, should be ==");
            }
            return true;
        }
        return false;
    }

    private boolean isStaticContent(ParseNode node) {
        if (node instanceof HashParseNode) {
            HashParseNode hash = (HashParseNode)node;
            for (Tuple<ParseNode, ParseNode> pair : hash.getPairs()) {
                if (this.isStaticContent(pair.getKey()) && this.isStaticContent(pair.getValue())) continue;
                return false;
            }
            return true;
        }
        if (node instanceof ArrayParseNode) {
            ArrayParseNode array = (ArrayParseNode)node;
            int size = array.size();
            for (int i = 0; i < size; ++i) {
                if (this.isStaticContent(array.get(i))) continue;
                return false;
            }
            return true;
        }
        return node instanceof ILiteralNode || node instanceof NilParseNode || node instanceof TrueParseNode || node instanceof FalseParseNode;
    }

    protected ParseNode makeNullNil(ParseNode node) {
        return node == null ? NilImplicitParseNode.NIL : node;
    }

    private ParseNode cond0(ParseNode node) {
        this.checkAssignmentInCondition(node);
        if (node == null) {
            return new NilParseNode(this.lexer.getPosition());
        }
        switch (node.getNodeType()) {
            case DREGEXPNODE: {
                SourceIndexLength position = node.getPosition();
                return new Match2ParseNode(position, node, new GlobalVarParseNode(position, "$_"));
            }
            case ANDNODE: {
                ParseNode leftNode = this.cond0(((AndParseNode)node).getFirstNode());
                ParseNode rightNode = this.cond0(((AndParseNode)node).getSecondNode());
                return new AndParseNode(node.getPosition(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case ORNODE: {
                ParseNode leftNode = this.cond0(((OrParseNode)node).getFirstNode());
                ParseNode rightNode = this.cond0(((OrParseNode)node).getSecondNode());
                return new OrParseNode(node.getPosition(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case DOTNODE: {
                DotParseNode dotNode = (DotParseNode)node;
                if (dotNode.isLiteral()) {
                    return node;
                }
                String label = String.valueOf("FLIP" + node.hashCode());
                this.currentScope.getLocalScope().addVariable(label);
                int slot = this.currentScope.isDefined(label);
                return new FlipParseNode(node.getPosition(), this.getFlipConditionNode(((DotParseNode)node).getBeginNode()), this.getFlipConditionNode(((DotParseNode)node).getEndNode()), dotNode.isExclusive(), slot);
            }
            case REGEXPNODE: {
                this.warningUnlessEOption(RubyWarnings.ID.REGEXP_LITERAL_IN_CONDITION, node, "regex literal in condition");
                return new MatchParseNode(node.getPosition(), node);
            }
        }
        return node;
    }

    public ParseNode getConditionNode(ParseNode node) {
        ParseNode cond = this.cond0(node);
        cond.setNewline();
        return cond;
    }

    private ParseNode getFlipConditionNode(ParseNode node) {
        if (!this.configuration.isInlineSource()) {
            return node;
        }
        if ((node = this.getConditionNode(node)) instanceof FixnumParseNode) {
            this.warnUnlessEOption(RubyWarnings.ID.LITERAL_IN_CONDITIONAL_RANGE, node, "integer literal in conditional range");
            return this.getOperatorCallNode(node, "==", new GlobalVarParseNode(node.getPosition(), "$."));
        }
        return node;
    }

    public SValueParseNode newSValueNode(SourceIndexLength position, ParseNode node) {
        return new SValueParseNode(position, node);
    }

    public SplatParseNode newSplatNode(SourceIndexLength position, ParseNode node) {
        return new SplatParseNode(position, this.makeNullNil(node));
    }

    public ArrayParseNode newArrayNode(SourceIndexLength position, ParseNode firstNode) {
        return new ArrayParseNode(position, this.makeNullNil(firstNode));
    }

    public SourceIndexLength position(ParseNode one, ParseNode two) {
        return one == null ? two.getPosition() : one.getPosition();
    }

    public AndParseNode newAndNode(SourceIndexLength position, ParseNode left, ParseNode right) {
        this.checkExpression(left);
        if (left == null && right == null) {
            return new AndParseNode(position, this.makeNullNil(left), this.makeNullNil(right));
        }
        return new AndParseNode(this.position(left, right), this.makeNullNil(left), this.makeNullNil(right));
    }

    public OrParseNode newOrNode(SourceIndexLength position, ParseNode left, ParseNode right) {
        this.checkExpression(left);
        if (left == null && right == null) {
            return new OrParseNode(position, this.makeNullNil(left), this.makeNullNil(right));
        }
        return new OrParseNode(this.position(left, right), this.makeNullNil(left), this.makeNullNil(right));
    }

    public CaseParseNode newCaseNode(SourceIndexLength position, ParseNode expression, ParseNode firstWhenNode) {
        ArrayParseNode cases = new ArrayParseNode(firstWhenNode != null ? firstWhenNode.getPosition() : position);
        CaseParseNode caseNode = new CaseParseNode(position, expression, cases);
        ParseNode current = firstWhenNode;
        while (current != null) {
            if (current instanceof WhenOneArgParseNode) {
                cases.add(current);
            } else if (current instanceof WhenParseNode) {
                this.simplifyMultipleArgumentWhenNodes((WhenParseNode)current, cases);
            } else {
                caseNode.setElseNode(current);
                break;
            }
            current = ((WhenParseNode)current).getNextCase();
        }
        return caseNode;
    }

    private void simplifyMultipleArgumentWhenNodes(WhenParseNode sourceWhen, ArrayParseNode cases) {
        ParseNode expressionNodes = sourceWhen.getExpressionNodes();
        if (expressionNodes instanceof SplatParseNode || expressionNodes instanceof ArgsCatParseNode) {
            cases.add(sourceWhen);
            return;
        }
        if (expressionNodes instanceof ListParseNode) {
            ListParseNode list = (ListParseNode)expressionNodes;
            SourceIndexLength position = sourceWhen.getPosition();
            ParseNode bodyNode = sourceWhen.getBodyNode();
            for (int i = 0; i < list.size(); ++i) {
                ParseNode expression = list.get(i);
                if (expression instanceof SplatParseNode || expression instanceof ArgsCatParseNode) {
                    cases.add(new WhenParseNode(position, expression, bodyNode, null));
                    continue;
                }
                cases.add(new WhenOneArgParseNode(position, expression, bodyNode, null));
            }
        } else {
            cases.add(sourceWhen);
        }
    }

    public WhenParseNode newWhenNode(SourceIndexLength position, ParseNode expressionNodes, ParseNode bodyNode, ParseNode nextCase) {
        ParseNode element;
        if (bodyNode == null) {
            bodyNode = NilImplicitParseNode.NIL;
        }
        if (expressionNodes instanceof SplatParseNode || expressionNodes instanceof ArgsCatParseNode || expressionNodes instanceof ArgsPushParseNode) {
            return new WhenParseNode(position, expressionNodes, bodyNode, nextCase);
        }
        ListParseNode list = (ListParseNode)expressionNodes;
        if (list.size() == 1 && !((element = list.get(0)) instanceof SplatParseNode)) {
            return new WhenOneArgParseNode(position, element, bodyNode, nextCase);
        }
        return new WhenParseNode(position, expressionNodes, bodyNode, nextCase);
    }

    public ParseNode new_opElementAsgnNode(ParseNode receiverNode, String operatorName, ParseNode argsNode, ParseNode valueNode) {
        SourceIndexLength position = this.lexer.tokline;
        OpElementAsgnParseNode newNode = new OpElementAsgnParseNode(position, receiverNode, operatorName, argsNode, valueNode);
        this.fixpos(newNode, receiverNode);
        return newNode;
    }

    public ParseNode newOpAsgn(SourceIndexLength position, ParseNode receiverNode, String callType, ParseNode valueNode, String variableName, String operatorName) {
        return new OpAsgnParseNode(position, receiverNode, valueNode, variableName, operatorName, this.isLazy(callType));
    }

    public ParseNode newOpConstAsgn(SourceIndexLength position, ParseNode lhs, String operatorName, ParseNode rhs) {
        if (lhs != null) {
            return new OpAsgnConstDeclParseNode(position, lhs, operatorName, rhs);
        }
        return new BeginParseNode(position, NilImplicitParseNode.NIL);
    }

    public boolean isLazy(String callType) {
        return "&.".equals(callType);
    }

    public ParseNode new_attrassign(SourceIndexLength position, ParseNode receiver, String name, ParseNode args, boolean isLazy) {
        return new AttrAssignParseNode(position, receiver, name, args, isLazy);
    }

    private boolean isNumericOperator(String name) {
        if (name.length() == 1) {
            switch (name.charAt(0)) {
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case '<': 
                case '>': {
                    return true;
                }
            }
        } else if (name.length() == 2) {
            switch (name.charAt(0)) {
                case '<': 
                case '=': 
                case '>': {
                    switch (name.charAt(1)) {
                        case '<': 
                        case '=': {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public ParseNode new_call(ParseNode receiver, String callType, String name, ParseNode argsNode, ParseNode iter) {
        if (argsNode instanceof BlockPassParseNode) {
            if (iter != null) {
                this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, "Both block arg and actual block given.");
            }
            BlockPassParseNode blockPass = (BlockPassParseNode)argsNode;
            return new CallParseNode(this.position(receiver, argsNode), receiver, name, blockPass.getArgsNode(), blockPass, this.isLazy(callType));
        }
        return new CallParseNode(this.position(receiver, argsNode), receiver, name, argsNode, iter, this.isLazy(callType));
    }

    public ParseNode new_call(ParseNode receiver, String name, ParseNode argsNode, ParseNode iter) {
        return this.new_call(receiver, ".", name, argsNode, iter);
    }

    public Colon2ParseNode new_colon2(SourceIndexLength position, ParseNode leftNode, String name) {
        if (leftNode == null) {
            return new Colon2ImplicitParseNode(position, name);
        }
        return new Colon2ConstParseNode(position, leftNode, name);
    }

    public Colon3ParseNode new_colon3(SourceIndexLength position, String name) {
        return new Colon3ParseNode(position, name);
    }

    public void frobnicate_fcall_args(FCallParseNode fcall, ParseNode args, ParseNode iter) {
        if (args instanceof BlockPassParseNode) {
            if (iter != null) {
                this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, "Both block arg and actual block given.");
            }
            BlockPassParseNode blockPass = (BlockPassParseNode)args;
            args = blockPass.getArgsNode();
            iter = blockPass;
        }
        fcall.setArgsNode(args);
        fcall.setIterNode(iter);
    }

    public void fixpos(ParseNode node, ParseNode orig) {
        if (node == null || orig == null) {
            return;
        }
        node.setPosition(orig.getPosition());
    }

    public ParseNode new_fcall(String operation) {
        return new FCallParseNode(this.lexer.tokline, operation);
    }

    public ParseNode new_super(SourceIndexLength position, ParseNode args) {
        if (args != null && args instanceof BlockPassParseNode) {
            return new SuperParseNode(position, ((BlockPassParseNode)args).getArgsNode(), args);
        }
        return new SuperParseNode(position, args);
    }

    public void initTopLocalVariables() {
        DynamicScope scope = this.configuration.getScope(this.lexer.getFile());
        this.currentScope = scope.getStaticScope();
        this.result.setScope(scope);
    }

    public boolean isInSingle() {
        return this.inSingleton != 0;
    }

    public void setInSingle(int inSingle) {
        this.inSingleton = inSingle;
    }

    public boolean isInDef() {
        return this.inDefinition;
    }

    public void setInDef(boolean inDef) {
        this.inDefinition = inDef;
    }

    public int getInSingle() {
        return this.inSingleton;
    }

    public RubyParserResult getResult() {
        return this.result;
    }

    public void setResult(RubyParserResult result) {
        this.result = result;
    }

    public void setConfiguration(ParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setWarnings(RubyWarnings warnings) {
        this.warnings = warnings;
    }

    public void setLexer(RubyLexer lexer) {
        this.lexer = lexer;
    }

    public DStrParseNode createDStrNode(SourceIndexLength position) {
        DStrParseNode dstr = new DStrParseNode(position, this.lexer.getEncoding());
        if (this.getConfiguration().isFrozenStringLiteral()) {
            dstr.setFrozen(true);
        }
        return dstr;
    }

    public Tuple<ParseNode, ParseNode> createKeyValue(ParseNode key, ParseNode value) {
        if (key != null && key instanceof StrParseNode) {
            ((StrParseNode)key).setFrozen(true);
        }
        return new Tuple<ParseNode, ParseNode>(key, value);
    }

    public ParseNode asSymbol(SourceIndexLength position, String value) {
        return new SymbolParseNode(position, value, this.lexer.getEncoding(), this.lexer.getTokenCR());
    }

    public ParseNode asSymbol(SourceIndexLength position, ParseNode value) {
        return value instanceof StrParseNode ? new SymbolParseNode(position, ((StrParseNode)value).getValue()) : new DSymbolParseNode(position, (DStrParseNode)value);
    }

    public ParseNode literal_concat(SourceIndexLength position, ParseNode head, ParseNode tail) {
        if (head == null) {
            return tail;
        }
        if (tail == null) {
            return head;
        }
        if (head instanceof EvStrParseNode) {
            head = this.createDStrNode(head.getPosition()).add(head);
        }
        if (this.lexer.getHeredocIndent() > 0) {
            if (head instanceof StrParseNode) {
                head = this.createDStrNode(head.getPosition()).add(head);
                return this.list_append(head, tail);
            }
            if (head instanceof DStrParseNode) {
                return this.list_append(head, tail);
            }
        }
        if (tail instanceof StrParseNode) {
            if (head instanceof StrParseNode) {
                StrParseNode front = (StrParseNode)head;
                if (front.getValue().getLength() > 0) {
                    return new StrParseNode(head.getPosition(), front, (StrParseNode)tail);
                }
                return tail;
            }
            head.setPosition(head.getPosition());
            return ((ListParseNode)head).add(tail);
        }
        if (tail instanceof DStrParseNode) {
            if (head instanceof StrParseNode) {
                DStrParseNode newDStr = new DStrParseNode(head.getPosition(), ((DStrParseNode)tail).getEncoding());
                newDStr.add(head);
                newDStr.addAll(tail);
                if (this.getConfiguration().isFrozenStringLiteral()) {
                    newDStr.setFrozen(true);
                }
                return newDStr;
            }
            return ((ListParseNode)head).addAll(tail);
        }
        if (head instanceof StrParseNode) {
            head = ((StrParseNode)head).getValue().getLength() == 0 ? this.createDStrNode(head.getPosition()) : this.createDStrNode(head.getPosition()).add(head);
        }
        return ((DStrParseNode)head).add(tail);
    }

    public ParseNode newRescueModNode(ParseNode body, ParseNode rescueBody) {
        if (rescueBody == null) {
            rescueBody = NilImplicitParseNode.NIL;
        }
        SourceIndexLength pos = this.getPosition(body);
        return new RescueModParseNode(pos, body, new RescueBodyParseNode(pos, null, rescueBody, null));
    }

    public ParseNode newEvStrNode(SourceIndexLength position, ParseNode node) {
        if (node instanceof StrParseNode || node instanceof DStrParseNode || node instanceof EvStrParseNode) {
            return node;
        }
        return new EvStrParseNode(position, node);
    }

    public ParseNode new_yield(SourceIndexLength position, ParseNode node) {
        if (node != null && node instanceof BlockPassParseNode) {
            this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, "Block argument should not be given.");
        }
        return new YieldParseNode(position, node);
    }

    public NumericParseNode negateInteger(NumericParseNode integerNode) {
        if (integerNode instanceof FixnumParseNode) {
            FixnumParseNode fixnumNode = (FixnumParseNode)integerNode;
            fixnumNode.setValue(-fixnumNode.getValue());
            return fixnumNode;
        }
        if (integerNode instanceof BignumParseNode) {
            BignumParseNode bignumNode = (BignumParseNode)integerNode;
            BigInteger value = bignumNode.getValue().negate();
            if (value.compareTo(LONG_MIN) >= 0) {
                return new FixnumParseNode(bignumNode.getPosition(), value.longValue());
            }
            bignumNode.setValue(value);
        }
        return integerNode;
    }

    public FloatParseNode negateFloat(FloatParseNode floatNode) {
        floatNode.setValue(-floatNode.getValue());
        return floatNode;
    }

    public ComplexParseNode negateComplexNode(ComplexParseNode complexNode) {
        complexNode.setNumber(this.negateNumeric(complexNode.getNumber()));
        return complexNode;
    }

    public RationalParseNode negateRational(RationalParseNode rationalNode) {
        return new RationalParseNode(rationalNode.getPosition(), -rationalNode.getNumerator(), rationalNode.getDenominator());
    }

    private ParseNode checkForNilNode(ParseNode node, SourceIndexLength defaultPosition) {
        return node == null ? new NilParseNode(defaultPosition) : node;
    }

    public ParseNode new_args(SourceIndexLength position, ListParseNode pre, ListParseNode optional, RestArgParseNode rest, ListParseNode post, ArgsTailHolder tail) {
        ArgsParseNode argsNode = tail == null ? new ArgsParseNode(position, pre, optional, rest, post, null) : new ArgsParseNode(position, pre, optional, rest, post, tail.getKeywordArgs(), tail.getKeywordRestArgNode(), tail.getBlockArg());
        this.getCurrentScope().setSignature(Signature.from(argsNode));
        return argsNode;
    }

    public ArgsTailHolder new_args_tail(SourceIndexLength position, ListParseNode keywordArg, String keywordRestArgName, BlockArgParseNode blockArg) {
        if (keywordRestArgName == null) {
            return new ArgsTailHolder(position, keywordArg, null, blockArg);
        }
        String restKwargsName = keywordRestArgName;
        int slot = this.currentScope.exists(restKwargsName);
        if (slot == -1) {
            slot = this.currentScope.addVariable(restKwargsName);
        }
        KeywordRestArgParseNode keywordRestArg = new KeywordRestArgParseNode(position, restKwargsName, slot);
        return new ArgsTailHolder(position, keywordArg, keywordRestArg, blockArg);
    }

    public ParseNode remove_duplicate_keys(HashParseNode hash) {
        ArrayList<ParseNode> encounteredKeys = new ArrayList<ParseNode>();
        for (Tuple<ParseNode, ParseNode> pair : hash.getPairs()) {
            ParseNode key = pair.getKey();
            if (key == null) continue;
            int index = encounteredKeys.indexOf(key);
            if (index >= 0) {
                this.warn(RubyWarnings.ID.AMBIGUOUS_ARGUMENT, hash.getPosition(), "key " + key + " is duplicated and overwritten on line " + ((ParseNode)encounteredKeys.get(index)).getPosition().toSourceSection(this.lexer.getSource()).getStartLine(), new Object[0]);
                continue;
            }
            encounteredKeys.add(key);
        }
        return hash;
    }

    public ParseNode newAlias(SourceIndexLength position, ParseNode newNode, ParseNode oldNode) {
        return new AliasParseNode(position, newNode, oldNode);
    }

    public ParseNode newUndef(SourceIndexLength position, ParseNode nameNode) {
        return new UndefParseNode(position, nameNode);
    }

    public void yyerror(String message) {
        this.lexer.compile_error(SyntaxException.PID.GRAMMAR_ERROR, message);
    }

    public void yyerror(String message, String[] expected, String found) {
        this.lexer.compile_error(SyntaxException.PID.GRAMMAR_ERROR, message + ", unexpected " + found + "\n");
    }

    public SourceIndexLength getPosition(ParseNode start) {
        if (start != null) {
            SourceIndexLength startPosition = start.getPosition();
            if (startPosition != null) {
                return startPosition;
            }
            return this.lexer.getPosition();
        }
        return this.lexer.getPosition();
    }

    public void warn(RubyWarnings.ID id, SourceIndexLength position, String message, Object ... data) {
        this.warnings.warn(id, this.file, position.toSourceSection(this.lexer.getSource()).getStartLine(), message);
    }

    public void warning(RubyWarnings.ID id, SourceIndexLength position, String message, Object ... data) {
        if (this.warnings.isVerbose()) {
            this.warnings.warning(id, this.file, position.toSourceSection(this.lexer.getSource()).getStartLine(), message);
        }
    }

    public boolean is_local_id(String name) {
        return this.lexer.isIdentifierChar(name.charAt(0));
    }

    public ListParseNode list_append(ParseNode list, ParseNode item) {
        if (list == null) {
            return new ArrayParseNode(item.getPosition(), item);
        }
        if (!(list instanceof ListParseNode)) {
            return new ArrayParseNode(list.getPosition(), list).add(item);
        }
        return ((ListParseNode)list).add(item);
    }

    public ParseNode new_bv(String identifier) {
        if (!this.is_local_id(identifier)) {
            this.getterIdentifierError(this.lexer.getPosition(), identifier);
        }
        this.shadowing_lvar(identifier);
        return this.arg_var(identifier);
    }

    public ArgumentParseNode arg_var(String name) {
        StaticScope current = this.getCurrentScope();
        if (name == "_") {
            int count = 0;
            while (current.exists(name) >= 0) {
                name = ("_$" + count++).intern();
            }
        }
        return new ArgumentParseNode(this.lexer.getPosition(), name, current.addVariableThisScope(name));
    }

    public String formal_argument(String identifier) {
        this.lexer.validateFormalIdentifier(identifier);
        return this.shadowing_lvar(identifier);
    }

    public String shadowing_lvar(String name) {
        if (name == "_") {
            return name;
        }
        StaticScope current = this.getCurrentScope();
        if (current.isBlockScope()) {
            if (current.exists(name) >= 0) {
                this.yyerror("duplicated argument name");
            }
            if (this.warnings.isVerbose() && current.isDefined(name) >= 0 && !this.skipTruffleRubiniusWarnings(this.lexer)) {
                this.warnings.warning(RubyWarnings.ID.STATEMENT_NOT_REACHED, this.file, this.lexer.getPosition().toSourceSection(this.lexer.getSource()).getStartLine(), "shadowing outer local variable - " + name);
            }
        } else if (current.exists(name) >= 0) {
            this.yyerror("duplicated argument name");
        }
        return name;
    }

    public ListParseNode list_concat(ParseNode first, ParseNode second) {
        if (first instanceof ListParseNode) {
            if (second instanceof ListParseNode) {
                return ((ListParseNode)first).addAll((ListParseNode)second);
            }
            return ((ListParseNode)first).addAll(second);
        }
        return new ArrayParseNode(first.getPosition(), first).add(second);
    }

    public ParseNode splat_array(ParseNode node) {
        if (node instanceof SplatParseNode) {
            node = ((SplatParseNode)node).getValue();
        }
        if (node instanceof ArrayParseNode) {
            return node;
        }
        return null;
    }

    public ParseNode arg_append(ParseNode node1, ParseNode node2) {
        if (node1 == null) {
            return new ArrayParseNode(node2.getPosition(), node2);
        }
        if (node1 instanceof ListParseNode) {
            return ((ListParseNode)node1).add(node2);
        }
        if (node1 instanceof BlockPassParseNode) {
            return this.arg_append(((BlockPassParseNode)node1).getBodyNode(), node2);
        }
        if (node1 instanceof ArgsPushParseNode) {
            ArgsPushParseNode pushNode = (ArgsPushParseNode)node1;
            ParseNode body = pushNode.getSecondNode();
            return new ArgsCatParseNode(pushNode.getPosition(), pushNode.getFirstNode(), new ArrayParseNode(body.getPosition(), body).add(node2));
        }
        return new ArgsPushParseNode(this.position(node1, node2), node1, node2);
    }

    public ParserByteList regexpFragmentCheck(RegexpParseNode end, ParserByteList value) {
        value = this.setRegexpEncoding(end, value);
        try {
            ClassicRegexp.preprocessCheck(this.configuration.getContext(), value.toRope());
        }
        catch (RaiseException re) {
            this.compile_error(re.getMessage());
        }
        return value;
    }

    private List<Integer> allocateNamedLocals(RegexpParseNode regexpNode) {
        ClassicRegexp pattern = ClassicRegexp.newRegexp(this.configuration.getContext(), regexpNode.getValue().toRope(), regexpNode.getOptions());
        pattern.setLiteral();
        String[] names = pattern.getNames();
        int length = names.length;
        ArrayList<Integer> locals = new ArrayList<Integer>();
        StaticScope scope = this.getCurrentScope();
        for (int i = 0; i < length; ++i) {
            if (RubyLexer.getKeyword(names[i]) != null || Character.isUpperCase(names[i].charAt(0))) continue;
            int slot = scope.isDefined(names[i]);
            if (slot >= 0) {
                if (this.warnings.isVerbose() && !scope.isNamedCapture(slot)) {
                    this.warn(RubyWarnings.ID.AMBIGUOUS_ARGUMENT, this.getPosition(regexpNode), "named capture conflicts a local variable - " + names[i], new Object[0]);
                }
                locals.add(slot);
                continue;
            }
            locals.add(this.getCurrentScope().addNamedCaptureVariable(names[i]));
        }
        return locals;
    }

    private boolean is7BitASCII(ParserByteList value) {
        return value.codeRangeScan() == CodeRange.CR_7BIT;
    }

    private char optionsEncodingChar(Encoding optionEncoding) {
        if (optionEncoding == RubyLexer.USASCII_ENCODING) {
            return 'n';
        }
        if (optionEncoding == EUCJPEncoding.INSTANCE) {
            return 'e';
        }
        if (optionEncoding == SJISEncoding.INSTANCE) {
            return 's';
        }
        if (optionEncoding == RubyLexer.UTF8_ENCODING) {
            return 'u';
        }
        return ' ';
    }

    public void compile_error(String message) {
        String line = this.lexer.getCurrentLine();
        SourceIndexLength position = this.lexer.getPosition();
        String errorMessage = this.lexer.getFile() + ":" + position.toSourceSection(this.lexer.getSource()).getStartLine() + ": ";
        if (line != null && line.length() > 5) {
            boolean addNewline = message != null && !message.endsWith("\n");
            message = message + (addNewline ? "\n" : "") + line;
        }
        throw new RaiseException(this.getConfiguration().getContext().getCoreExceptions().syntaxError(errorMessage + message, null));
    }

    protected void compileError(Encoding optionEncoding, Encoding encoding) {
        this.lexer.compile_error(SyntaxException.PID.REGEXP_ENCODING_MISMATCH, "regexp encoding option '" + this.optionsEncodingChar(optionEncoding) + "' differs from source encoding '" + encoding + "'");
    }

    public ParserByteList setRegexpEncoding(RegexpParseNode end, ParserByteList value) {
        RegexpOptions options = end.getOptions();
        Encoding optionsEncoding = options.setup(this.configuration.getContext());
        if (optionsEncoding != null) {
            if (optionsEncoding != value.getEncoding() && !this.is7BitASCII(value)) {
                this.compileError(optionsEncoding, value.getEncoding());
            }
            value = value.withEncoding(optionsEncoding);
        } else if (options.isEncodingNone()) {
            if (value.getEncoding() == RubyLexer.ASCII8BIT_ENCODING && !this.is7BitASCII(value)) {
                this.compileError(optionsEncoding, value.getEncoding());
            }
            value = value.withEncoding(RubyLexer.ASCII8BIT_ENCODING);
        } else if (this.lexer.getEncoding() == RubyLexer.USASCII_ENCODING) {
            value = !this.is7BitASCII(value) ? value.withEncoding(RubyLexer.USASCII_ENCODING) : value.withEncoding(RubyLexer.ASCII8BIT_ENCODING);
        }
        return value;
    }

    protected void checkRegexpSyntax(ParserByteList value, RegexpOptions options) {
        String stringValue = value.toString();
        if (stringValue.startsWith("(?u)") || stringValue.startsWith("(?a)") || stringValue.startsWith("(?d)")) {
            return;
        }
        try {
            ClassicRegexp.newRegexpParser(this.getConfiguration().getContext(), value.toRope(), (RegexpOptions)options.clone());
        }
        catch (RaiseException re) {
            this.compile_error(re.getMessage());
        }
    }

    public ParseNode newRegexpNode(SourceIndexLength position, ParseNode contents, RegexpParseNode end) {
        RegexpOptions options = end.getOptions();
        Encoding encoding = this.lexer.getEncoding();
        if (contents == null) {
            ParserByteList newValue = new ParserByteList(new byte[0]);
            if (encoding != null) {
                newValue = newValue.withEncoding(encoding);
            }
            newValue = this.regexpFragmentCheck(end, newValue);
            return new RegexpParseNode(position, newValue, options.withoutOnce());
        }
        if (contents instanceof StrParseNode) {
            ParserByteList meat = ((StrParseNode)contents).getValue();
            meat = this.regexpFragmentCheck(end, meat);
            this.checkRegexpSyntax(meat, options.withoutOnce());
            return new RegexpParseNode(contents.getPosition(), meat, options.withoutOnce());
        }
        if (contents instanceof DStrParseNode) {
            DStrParseNode dStrNode = (DStrParseNode)contents;
            for (int i = 0; i < dStrNode.size(); ++i) {
                ParseNode fragment = dStrNode.get(i);
                if (!(fragment instanceof StrParseNode)) continue;
                ParserByteList frag = ((StrParseNode)fragment).getValue();
                frag = this.regexpFragmentCheck(end, frag);
            }
            DRegexpParseNode dRegexpNode = new DRegexpParseNode(position, options, encoding);
            dRegexpNode.add(new StrParseNode(contents.getPosition(), this.createMaster(options)));
            dRegexpNode.addAll(dStrNode);
            return dRegexpNode;
        }
        ParserByteList master = this.createMaster(options);
        master = this.regexpFragmentCheck(end, master);
        encoding = master.getEncoding();
        DRegexpParseNode node = new DRegexpParseNode(position, options, encoding);
        node.add(new StrParseNode(contents.getPosition(), master));
        node.add(contents);
        return node;
    }

    private ParserByteList createMaster(RegexpOptions options) {
        Encoding encoding = options.setup(this.configuration.getContext());
        return new ParserByteList(new byte[]{}, encoding == null ? ASCIIEncoding.INSTANCE : encoding);
    }

    public KeywordArgParseNode keyword_arg(SourceIndexLength position, AssignableParseNode assignable) {
        return new KeywordArgParseNode(position, assignable);
    }

    public NumericParseNode negateNumeric(NumericParseNode node) {
        switch (node.getNodeType()) {
            case BIGNUMNODE: 
            case FIXNUMNODE: {
                return this.negateInteger(node);
            }
            case COMPLEXNODE: {
                return this.negateComplexNode((ComplexParseNode)node);
            }
            case FLOATNODE: {
                return this.negateFloat((FloatParseNode)node);
            }
            case RATIONALNODE: {
                return this.negateRational((RationalParseNode)node);
            }
        }
        this.yyerror("Invalid or unimplemented numeric to negate: " + node.toString());
        return null;
    }

    public ParseNode new_defined(SourceIndexLength position, ParseNode something) {
        return new DefinedParseNode(position, something);
    }

    public String internalId() {
        return "";
    }

    public boolean skipTruffleRubiniusWarnings(RubyLexer lexer) {
        return lexer.getFile().startsWith(this.context.getOptions().CORE_LOAD_PATH);
    }

    public SourceIndexLength extendedUntil(SourceIndexLength start, SourceIndexLength end) {
        return new SourceIndexLength(start.getCharIndex(), end.getCharEnd() - start.getCharIndex());
    }
}

