/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.readline;

import com.oracle.truffle.api.CompilerDirectives;
import java.io.IOException;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import org.jruby.truffle.stdlib.readline.ReadlineNodes;

public class ConsoleHolder {
    private final ConsoleReader readline;
    private final Completer currentCompleter;
    private final History history;

    @CompilerDirectives.TruffleBoundary
    public ConsoleHolder() {
        try {
            this.readline = new ConsoleReader();
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Couldn't initialize readline", e);
        }
        this.readline.setHistoryEnabled(false);
        this.readline.setPaginationEnabled(true);
        this.readline.setBellEnabled(true);
        this.currentCompleter = new ReadlineNodes.RubyFileNameCompleter();
        this.readline.addCompleter(this.currentCompleter);
        this.history = new MemoryHistory();
        this.readline.setHistory(this.history);
    }

    public ConsoleReader getReadline() {
        return this.readline;
    }

    public Completer getCurrentCompleter() {
        return this.currentCompleter;
    }

    public History getHistory() {
        return this.history;
    }
}

