/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.MavenComparableVersion;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000289B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J&\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J \u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010*\u001a\u00020'2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0006H\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001d\u001a\u00020%2\u0006\u0010/\u001a\u000200H\u0002J'\u00101\u001a\u0002H2\"\u0004\b\u0000\u00102*\u0004\u0018\u0001H22\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000603H\u0002\u00a2\u0006\u0002\u00104J\f\u00105\u001a\u00020\u0004*\u000200H\u0002J\u001e\u00106\u001a\u00020 *\u00020\u001c2\b\u00107\u001a\u0004\u0018\u00010%2\u0006\u0010-\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker;", "", "()V", "CURRENT_COMPILER_VERSION", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "KOTLIN_REFLECT_MODULE", "", "KOTLIN_RUNTIME_COMPONENT_ATTRIBUTE", "KOTLIN_RUNTIME_COMPONENT_CORE", "KOTLIN_STDLIB_MODULE", "KOTLIN_VERSION_ATTRIBUTE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MANIFEST_KOTLIN_RUNTIME_COMPONENT", "MANIFEST_KOTLIN_RUNTIME_COMPONENT_CORE", "MANIFEST_KOTLIN_VERSION_ATTRIBUTE", "MANIFEST_KOTLIN_VERSION_VALUE", "MANIFEST_MF", "META_INF", "VERSION_ISSUE_SEVERITY", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "MavenComparableVersion", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "checkCompatibleWithLanguageVersion", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "jar", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$KotlinLibraryFile;", "checkCompilerClasspathConsistency", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "classpathJarRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "runtimeJarsInfo", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$RuntimeJarsInfo;", "checkMatchingVersions", "checkNotNewerThanCompiler", "collectRuntimeJarsInfo", "fatal", "", "message", "getKotlinRuntimeComponent", "manifest", "Ljava/util/jar/Manifest;", "assertNotNull", "T", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getKotlinLanguageVersion", "issue", "file", "KotlinLibraryFile", "RuntimeJarsInfo", "kotlin-compiler"})
public final class JvmRuntimeVersionsConsistencyChecker {
    private static final Logger LOG;
    private static final CompilerMessageSeverity VERSION_ISSUE_SEVERITY;
    private static final String MANIFEST_MF = "META-INF/MANIFEST.MF";
    private static final String MANIFEST_KOTLIN_VERSION_ATTRIBUTE = "manifest.impl.attribute.kotlin.version";
    private static final String MANIFEST_KOTLIN_VERSION_VALUE = "manifest.impl.value.kotlin.version";
    private static final String MANIFEST_KOTLIN_RUNTIME_COMPONENT = "manifest.impl.attribute.kotlin.runtime.component";
    private static final String MANIFEST_KOTLIN_RUNTIME_COMPONENT_CORE = "manifest.impl.value.kotlin.runtime.component.core";
    private static final String KOTLIN_STDLIB_MODULE = "META-INF/kotlin-stdlib.kotlin_module";
    private static final String KOTLIN_REFLECT_MODULE = "META-INF/kotlin-reflection.kotlin_module";
    private static final String KOTLIN_VERSION_ATTRIBUTE;
    private static final MavenComparableVersion CURRENT_COMPILER_VERSION;
    private static final String KOTLIN_RUNTIME_COMPONENT_ATTRIBUTE;
    private static final String KOTLIN_RUNTIME_COMPONENT_CORE;
    public static final JvmRuntimeVersionsConsistencyChecker INSTANCE;

    private final Void fatal(String message) {
        LOG.error(message);
        throw (Throwable)((Object)new AssertionError((Object)message));
    }

    private final <T> T assertNotNull(@Nullable T $receiver, Function0<String> message) {
        if ($receiver == null) {
            Void void_ = this.fatal(message.invoke());
            throw null;
        }
        return $receiver;
    }

    public final void checkCompilerClasspathConsistency(@NotNull MessageCollector messageCollector, @Nullable LanguageVersionSettings languageVersionSettings, @NotNull List<? extends VirtualFile> classpathJarRoots) {
        block4: {
            Object languageVersion;
            RuntimeJarsInfo runtimeJarsInfo;
            block6: {
                Object object;
                block5: {
                    Intrinsics.checkParameterIsNotNull(messageCollector, "messageCollector");
                    Intrinsics.checkParameterIsNotNull(classpathJarRoots, "classpathJarRoots");
                    runtimeJarsInfo = this.collectRuntimeJarsInfo(classpathJarRoots);
                    if (!runtimeJarsInfo.getHasAnyJarsToCheck()) break block4;
                    object = languageVersionSettings;
                    if (object == null) break block5;
                    LanguageVersionSettings languageVersionSettings2 = object;
                    LanguageVersionSettings it = languageVersionSettings2;
                    object = INSTANCE.MavenComparableVersion(it.getLanguageVersion());
                    if (object != null) break block6;
                }
                object = languageVersion = CURRENT_COMPILER_VERSION;
            }
            if (this.checkCompilerClasspathConsistency(messageCollector, (MavenComparableVersion)languageVersion, runtimeJarsInfo)) {
                this.issue(messageCollector, null, "Some runtime JAR files in the classpath have an incompatible version. Remove them from the classpath or use '-Xskip-runtime-version-check' to suppress errors");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkCompilerClasspathConsistency(MessageCollector messageCollector, MavenComparableVersion languageVersion, RuntimeJarsInfo runtimeJarsInfo) {
        boolean bl;
        block7: {
            boolean bl2;
            Object element$iv2;
            Boolean bl3;
            void it;
            void var13_13;
            void destination$iv$iv;
            Object item$iv$iv;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            block6: {
                Iterable iterable = runtimeJarsInfo.getCoreJars();
                Iterator iterator2 = $receiver$iv;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                Iterator iterator3 = $receiver$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    item$iv$iv = iterator3.next();
                    KotlinLibraryFile kotlinLibraryFile = (KotlinLibraryFile)item$iv$iv;
                    var13_13 = destination$iv$iv;
                    bl3 = INSTANCE.checkNotNewerThanCompiler(messageCollector, (KotlinLibraryFile)it);
                    var13_13.add(bl3);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv2 : $receiver$iv) {
                    boolean it2 = (Boolean)element$iv2;
                    if (!it2) continue;
                    bl2 = true;
                    break block6;
                }
                bl2 = false;
            }
            if (bl2) {
                return true;
            }
            $receiver$iv = runtimeJarsInfo.getCoreJars();
            $receiver$iv$iv = $receiver$iv;
            element$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            Iterator it2 = $receiver$iv$iv.iterator();
            while (it2.hasNext()) {
                item$iv$iv = it2.next();
                KotlinLibraryFile $i$f$any = (KotlinLibraryFile)item$iv$iv;
                var13_13 = destination$iv$iv;
                bl3 = INSTANCE.checkCompatibleWithLanguageVersion(messageCollector, (KotlinLibraryFile)it, languageVersion);
                var13_13.add(bl3);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv2 : $receiver$iv) {
                boolean it3 = (Boolean)element$iv2;
                if (!it3) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        return this.checkMatchingVersions(messageCollector, runtimeJarsInfo);
    }

    private final boolean checkNotNewerThanCompiler(MessageCollector messageCollector, KotlinLibraryFile jar) {
        if (jar.getVersion().compareTo(CURRENT_COMPILER_VERSION) > 0) {
            this.issue(messageCollector, jar.getFile(), "Runtime JAR file has version " + jar.getVersion() + " which is newer than compiler version " + CURRENT_COMPILER_VERSION);
            return true;
        }
        return false;
    }

    private final boolean checkCompatibleWithLanguageVersion(MessageCollector messageCollector, KotlinLibraryFile jar, MavenComparableVersion languageVersion) {
        if (jar.getVersion().compareTo(languageVersion) < 0) {
            this.issue(messageCollector, jar.getFile(), "Runtime JAR file has version " + jar.getVersion() + " which is older than required for language version " + languageVersion);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkMatchingVersions(MessageCollector messageCollector, RuntimeJarsInfo runtimeJarsInfo) {
        Object maxElem$iv;
        Object v2;
        void $receiver$iv;
        Object v0;
        void $receiver$iv2;
        Iterable iterable = runtimeJarsInfo.getCoreJars();
        Iterator iterator$iv = $receiver$iv2.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            KotlinLibraryFile it = (KotlinLibraryFile)minElem$iv;
            Comparable minValue$iv = it.getVersion();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                KotlinLibraryFile it2 = (KotlinLibraryFile)e$iv;
                Comparable v$iv = it2.getVersion();
                if (minValue$iv.compareTo(v$iv) <= 0) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            }
            v0 = minElem$iv;
        }
        KotlinLibraryFile kotlinLibraryFile = v0;
        if (kotlinLibraryFile == null) {
            return false;
        }
        KotlinLibraryFile oldestCoreJar = kotlinLibraryFile;
        iterator$iv = runtimeJarsInfo.getCoreJars();
        Object iterator$iv2 = $receiver$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v2 = null;
        } else {
            maxElem$iv = iterator$iv2.next();
            KotlinLibraryFile it = (KotlinLibraryFile)maxElem$iv;
            Comparable maxValue$iv = it.getVersion();
            while (iterator$iv2.hasNext()) {
                Object e$iv = iterator$iv2.next();
                KotlinLibraryFile it3 = (KotlinLibraryFile)e$iv;
                Comparable v$iv = it3.getVersion();
                if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            }
            v2 = maxElem$iv;
        }
        KotlinLibraryFile kotlinLibraryFile2 = v2;
        if (kotlinLibraryFile2 == null) {
            return false;
        }
        KotlinLibraryFile newestCoreJar = kotlinLibraryFile2;
        if (Intrinsics.areEqual(oldestCoreJar.getVersion(), newestCoreJar.getVersion()) ^ true) {
            void $receiver;
            VirtualFile virtualFile = null;
            MessageCollector messageCollector2 = messageCollector;
            JvmRuntimeVersionsConsistencyChecker jvmRuntimeVersionsConsistencyChecker = this;
            CharSequence charSequence = new StringBuilder();
            iterator$iv2 = charSequence;
            maxElem$iv = $receiver;
            String string = "Runtime JAR files in the classpath must have the same version. These files were found in the classpath:";
            StringsKt.appendln(((StringBuilder)maxElem$iv).append(string));
            for (KotlinLibraryFile jar : runtimeJarsInfo.getCoreJars()) {
                void var9_8 = $receiver;
                String string2 = "    " + jar.getFile().getPath() + " (version " + jar.getVersion() + ")";
                StringsKt.appendln(var9_8.append(string2));
            }
            String string3 = charSequence.toString();
            Intrinsics.checkExpressionValueIsNotNull(string3, "StringBuilder().apply(builderAction).toString()");
            String string4 = string3;
            charSequence = string4;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string4 = ((Object)StringsKt.trimEnd(charSequence2)).toString();
            jvmRuntimeVersionsConsistencyChecker.issue(messageCollector2, virtualFile, string4);
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final void issue(@NotNull MessageCollector $receiver, VirtualFile file, String message) {
        v0 = $receiver;
        v1 = JvmRuntimeVersionsConsistencyChecker.VERSION_ISSUE_SEVERITY;
        v2 = message;
        v3 = CompilerMessageLocation.Companion;
        v4 = file;
        if (v4 == null) ** GOTO lbl-1000
        var4_4 = v4;
        var10_5 = v3;
        var9_6 = v2;
        var8_7 = v1;
        var7_8 = v0;
        p1 = var4_4;
        var11_10 = VfsUtilCore.virtualToIoFile(p1);
        v0 = var7_8;
        v1 = var8_7;
        v2 = var9_6;
        v3 = var10_5;
        v4 = var11_10;
        if (v4 != null) {
            v5 = v4.getPath();
        } else lbl-1000:
        // 2 sources

        {
            v5 = null;
        }
        v0.report(v1, v2, v3.create(v5));
    }

    private final RuntimeJarsInfo collectRuntimeJarsInfo(List<? extends VirtualFile> classpathJarRoots) {
        ArrayList<KotlinLibraryFile> kotlinCoreJars = new ArrayList<KotlinLibraryFile>(2);
        for (VirtualFile virtualFile : classpathJarRoots) {
            VirtualFile jarFile;
            String runtimeComponent;
            Cloneable manifestFile;
            try {
                VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(MANIFEST_MF);
                if (virtualFile2 == null) {
                    continue;
                }
                manifestFile = virtualFile2;
                manifestFile = new Manifest(manifestFile.getInputStream());
            }
            catch (Exception e) {
                continue;
            }
            Cloneable manifest = manifestFile;
            if (this.getKotlinRuntimeComponent(virtualFile, (Manifest)manifest) == null) {
                continue;
            }
            MavenComparableVersion version = this.getKotlinLanguageVersion((Manifest)manifest);
            if (!Intrinsics.areEqual(runtimeComponent, KOTLIN_RUNTIME_COMPONENT_CORE)) continue;
            if (VfsUtilCore.getVirtualFileForJar(virtualFile) == null) {
                continue;
            }
            VirtualFile virtualFile3 = jarFile;
            Intrinsics.checkExpressionValueIsNotNull(virtualFile3, "jarFile");
            kotlinCoreJars.add(new KotlinLibraryFile(runtimeComponent, virtualFile3, version));
        }
        return new RuntimeJarsInfo((List<KotlinLibraryFile>)kotlinCoreJars);
    }

    private final String getKotlinRuntimeComponent(VirtualFile jar, Manifest manifest) {
        String string = manifest.getMainAttributes().getValue(KOTLIN_RUNTIME_COMPONENT_ATTRIBUTE);
        if (string != null) {
            String string2 = string;
            String it = string2;
            return it;
        }
        if (jar.findFileByRelativePath(KOTLIN_STDLIB_MODULE) != null) {
            return KOTLIN_RUNTIME_COMPONENT_CORE;
        }
        if (jar.findFileByRelativePath(KOTLIN_REFLECT_MODULE) != null) {
            return KOTLIN_RUNTIME_COMPONENT_CORE;
        }
        return null;
    }

    private final MavenComparableVersion getKotlinLanguageVersion(@NotNull Manifest $receiver) {
        String string = $receiver.getMainAttributes().getValue(KOTLIN_VERSION_ATTRIBUTE);
        if (string == null) {
            string = LanguageVersion.KOTLIN_1_0.getVersionString();
        }
        return new MavenComparableVersion(string);
    }

    private final MavenComparableVersion MavenComparableVersion(LanguageVersion languageVersion) {
        return new MavenComparableVersion(languageVersion.getVersionString());
    }

    /*
     * WARNING - void declaration
     */
    private JvmRuntimeVersionsConsistencyChecker() {
        Object object;
        INSTANCE = this;
        LOG = Logger.getInstance(JvmRuntimeVersionsConsistencyChecker.class);
        VERSION_ISSUE_SEVERITY = CompilerMessageSeverity.ERROR;
        try {
            void $receiver;
            object = JvmRuntimeVersionsConsistencyChecker.class.getResourceAsStream("/kotlinManifest.properties");
            InputStream input = object;
            Properties properties2 = new Properties();
            Properties properties3 = properties2;
            $receiver.load(input);
            object = properties2;
        }
        catch (Exception e) {
            LOG.error(e);
            throw (Throwable)e;
        }
        Object manifestProperties = object;
        KOTLIN_VERSION_ATTRIBUTE = this.assertNotNull(((Properties)manifestProperties).getProperty(MANIFEST_KOTLIN_VERSION_ATTRIBUTE), 1.INSTANCE);
        object = this;
        JvmRuntimeVersionsConsistencyChecker $receiver = (JvmRuntimeVersionsConsistencyChecker)object;
        String kotlinVersionString2 = $receiver.assertNotNull(((Properties)manifestProperties).getProperty(MANIFEST_KOTLIN_VERSION_VALUE), new Function0<String>($receiver){
            final /* synthetic */ JvmRuntimeVersionsConsistencyChecker receiver$0;

            @NotNull
            public final String invoke() {
                return JvmRuntimeVersionsConsistencyChecker.access$getMANIFEST_KOTLIN_VERSION_VALUE$p(this.receiver$0) + " not found in kotlinManifest.properties";
            }
            {
                this.receiver$0 = jvmRuntimeVersionsConsistencyChecker;
                super(0);
            }
        });
        CURRENT_COMPILER_VERSION = new MavenComparableVersion(kotlinVersionString2);
        if (Intrinsics.areEqual(CURRENT_COMPILER_VERSION, this.MavenComparableVersion(LanguageVersion.LATEST)) ^ true) {
            Void void_ = this.fatal("Kotlin compiler version " + CURRENT_COMPILER_VERSION + " in kotlinManifest.properties doesn't match " + LanguageVersion.LATEST);
            throw null;
        }
        KOTLIN_RUNTIME_COMPONENT_ATTRIBUTE = this.assertNotNull(((Properties)manifestProperties).getProperty(MANIFEST_KOTLIN_RUNTIME_COMPONENT), 3.INSTANCE);
        KOTLIN_RUNTIME_COMPONENT_CORE = this.assertNotNull(((Properties)manifestProperties).getProperty(MANIFEST_KOTLIN_RUNTIME_COMPONENT_CORE), 4.INSTANCE);
    }

    static {
        new JvmRuntimeVersionsConsistencyChecker();
    }

    @NotNull
    public static final /* synthetic */ String access$getMANIFEST_KOTLIN_VERSION_ATTRIBUTE$p(JvmRuntimeVersionsConsistencyChecker $this) {
        JvmRuntimeVersionsConsistencyChecker jvmRuntimeVersionsConsistencyChecker = $this;
        return MANIFEST_KOTLIN_VERSION_ATTRIBUTE;
    }

    @NotNull
    public static final /* synthetic */ String access$getMANIFEST_KOTLIN_VERSION_VALUE$p(JvmRuntimeVersionsConsistencyChecker $this) {
        JvmRuntimeVersionsConsistencyChecker jvmRuntimeVersionsConsistencyChecker = $this;
        return MANIFEST_KOTLIN_VERSION_VALUE;
    }

    @NotNull
    public static final /* synthetic */ String access$getMANIFEST_KOTLIN_RUNTIME_COMPONENT$p(JvmRuntimeVersionsConsistencyChecker $this) {
        JvmRuntimeVersionsConsistencyChecker jvmRuntimeVersionsConsistencyChecker = $this;
        return MANIFEST_KOTLIN_RUNTIME_COMPONENT;
    }

    @NotNull
    public static final /* synthetic */ String access$getMANIFEST_KOTLIN_RUNTIME_COMPONENT_CORE$p(JvmRuntimeVersionsConsistencyChecker $this) {
        JvmRuntimeVersionsConsistencyChecker jvmRuntimeVersionsConsistencyChecker = $this;
        return MANIFEST_KOTLIN_RUNTIME_COMPONENT_CORE;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$KotlinLibraryFile;", "", "component", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "version", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/config/MavenComparableVersion;)V", "getComponent", "()Ljava/lang/String;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getVersion", "()Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "toString", "kotlin-compiler"})
    private static final class KotlinLibraryFile {
        @NotNull
        private final String component;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final MavenComparableVersion version;

        @NotNull
        public String toString() {
            return this.file.getName() + ":" + this.version + " (" + this.component + ")";
        }

        @NotNull
        public final String getComponent() {
            return this.component;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final MavenComparableVersion getVersion() {
            return this.version;
        }

        public KotlinLibraryFile(@NotNull String component, @NotNull VirtualFile file, @NotNull MavenComparableVersion version) {
            Intrinsics.checkParameterIsNotNull(component, "component");
            Intrinsics.checkParameterIsNotNull(file, "file");
            Intrinsics.checkParameterIsNotNull(version, "version");
            this.component = component;
            this.file = file;
            this.version = version;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$RuntimeJarsInfo;", "", "coreJars", "", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$KotlinLibraryFile;", "(Ljava/util/List;)V", "getCoreJars", "()Ljava/util/List;", "hasAnyJarsToCheck", "", "getHasAnyJarsToCheck", "()Z", "kotlin-compiler"})
    private static final class RuntimeJarsInfo {
        @NotNull
        private final List<KotlinLibraryFile> coreJars;

        public final boolean getHasAnyJarsToCheck() {
            Collection collection = this.coreJars;
            return !collection.isEmpty();
        }

        @NotNull
        public final List<KotlinLibraryFile> getCoreJars() {
            return this.coreJars;
        }

        public RuntimeJarsInfo(@NotNull List<KotlinLibraryFile> coreJars) {
            Intrinsics.checkParameterIsNotNull(coreJars, "coreJars");
            this.coreJars = coreJars;
        }
    }
}

