/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.general;

import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsObjectScope;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsThrow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.general.ModuleWrapperTranslation$WhenMappings;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J4\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J<\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J4\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J4\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/js/translate/general/ModuleWrapperTranslation;", "", "()V", "addModuleValidation", "Lcom/google/dart/compiler/backend/js/ast/JsStatement;", "currentModuleId", "", "program", "Lcom/google/dart/compiler/backend/js/ast/JsProgram;", "moduleName", "makePlainInvocation", "Lcom/google/dart/compiler/backend/js/ast/JsInvocation;", "function", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "importedModules", "", "makePlainModuleRef", "moduleId", "wrapAmd", "wrapCommonJs", "wrapIfNecessary", "kind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "wrapPlain", "wrapUmd", "kotlin-compiler"})
public final class ModuleWrapperTranslation {
    public static final ModuleWrapperTranslation INSTANCE;

    @JvmStatic
    @NotNull
    public static final List<JsStatement> wrapIfNecessary(@NotNull String moduleId, @NotNull JsExpression function, @NotNull List<String> importedModules, @NotNull JsProgram program, @NotNull ModuleKind kind) {
        List<JsStatement> list2;
        Intrinsics.checkParameterIsNotNull(moduleId, "moduleId");
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(importedModules, "importedModules");
        Intrinsics.checkParameterIsNotNull(program, "program");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        switch (ModuleWrapperTranslation$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                list2 = INSTANCE.wrapAmd(moduleId, function, importedModules, program);
                break;
            }
            case 2: {
                list2 = INSTANCE.wrapCommonJs(function, importedModules, program);
                break;
            }
            case 3: {
                list2 = INSTANCE.wrapUmd(moduleId, function, importedModules, program);
                break;
            }
            case 4: {
                list2 = INSTANCE.wrapPlain(moduleId, function, importedModules, program);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    private final List<JsStatement> wrapUmd(String moduleId, JsExpression function, List<String> importedModules, JsProgram program) {
        JsObjectScope scope = program.getScope();
        JsName defineName = scope.declareName("define");
        JsName exportsName = scope.declareName("exports");
        JsBlock adapterBody = new JsBlock();
        JsFunction adapter = new JsFunction((JsScope)program.getScope(), adapterBody, "Adapter");
        JsName rootName = adapter.getScope().declareName("root");
        JsName factoryName = adapter.getScope().declareName("factory");
        Collection collection = adapter.getParameters();
        JsParameter jsParameter = new JsParameter(rootName);
        collection.add(jsParameter);
        collection = adapter.getParameters();
        jsParameter = new JsParameter(factoryName);
        collection.add(jsParameter);
        JsBinaryOperation amdTest = JsAstUtils.and(JsAstUtils.typeOfIs(defineName.makeRef(), program.getStringLiteral("function")), new JsNameRef("amd", (JsExpression)defineName.makeRef()));
        JsBinaryOperation commonJsTest = JsAstUtils.typeOfIs(exportsName.makeRef(), program.getStringLiteral("object"));
        JsExpression jsExpression = factoryName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "factoryName.makeRef()");
        JsBlock amdBody = new JsBlock(this.wrapAmd(moduleId, jsExpression, importedModules, program));
        JsExpression jsExpression2 = factoryName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "factoryName.makeRef()");
        JsBlock commonJsBody = new JsBlock(this.wrapCommonJs(jsExpression2, importedModules, program));
        JsExpression jsExpression3 = factoryName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "factoryName.makeRef()");
        JsInvocation plainInvocation = this.makePlainInvocation(jsExpression3, importedModules, program);
        JsExpression lhs = Namer.requiresEscaping(moduleId) ? (JsExpression)new JsArrayAccess(rootName.makeRef(), program.getStringLiteral(moduleId)) : (JsExpression)new JsNameRef(scope.declareName(moduleId), (JsExpression)rootName.makeRef());
        JsBlock plainBlock = new JsBlock();
        for (String string : importedModules) {
            Collection collection2 = plainBlock.getStatements();
            JsStatement jsStatement = this.addModuleValidation(moduleId, program, string);
            collection2.add(jsStatement);
        }
        Collection collection3 = plainBlock.getStatements();
        Object object = JsAstUtils.assignment(lhs, plainInvocation).makeStmt();
        collection3.add(object);
        JsIf jsIf = JsAstUtils.newJsIf(amdTest, amdBody, JsAstUtils.newJsIf(commonJsTest, commonJsBody, plainBlock));
        object = adapterBody.getStatements();
        object.add(jsIf);
        return CollectionsKt.listOf(new JsInvocation((JsExpression)adapter, JsLiteral.THIS, function).makeStmt());
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> wrapAmd(String moduleId, JsExpression function, List<String> importedModules, JsProgram program) {
        List list2;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        JsArrayLiteral jsArrayLiteral;
        JsObjectScope scope = program.getScope();
        JsName defineName = scope.declareName("define");
        JsExpression[] jsExpressionArray = new JsExpression[3];
        JsStringLiteral jsStringLiteral = program.getStringLiteral(moduleId);
        Intrinsics.checkExpressionValueIsNotNull(jsStringLiteral, "program.getStringLiteral(moduleId)");
        jsExpressionArray[0] = jsStringLiteral;
        Iterable iterable = importedModules;
        JsArrayLiteral jsArrayLiteral2 = jsArrayLiteral;
        JsArrayLiteral jsArrayLiteral3 = jsArrayLiteral;
        int n = 1;
        JsExpression[] jsExpressionArray2 = jsExpressionArray;
        JsExpression[] jsExpressionArray3 = jsExpressionArray;
        void var9_13 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            list2 = destination$iv$iv;
            JsStringLiteral jsStringLiteral2 = program.getStringLiteral((String)it);
            list2.add(jsStringLiteral2);
        }
        list2 = (List)destination$iv$iv;
        jsArrayLiteral2(list2);
        jsExpressionArray2[n] = jsArrayLiteral3;
        jsExpressionArray3[2] = function;
        List<JsExpression[]> invocationArgs = CollectionsKt.listOf(jsExpressionArray3);
        JsInvocation invocation = new JsInvocation((JsExpression)defineName.makeRef(), invocationArgs);
        return CollectionsKt.listOf(invocation.makeStmt());
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> wrapCommonJs(JsExpression function, List<String> importedModules, JsProgram program) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        JsObjectScope scope = program.getScope();
        JsName moduleName = scope.declareName("module");
        JsName requireName = scope.declareName("require");
        Iterable iterable = importedModules;
        void var9_8 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            void var17_13 = destination$iv$iv;
            JsInvocation jsInvocation = new JsInvocation((JsExpression)requireName.makeRef(), program.getStringLiteral((String)it));
            var17_13.add(jsInvocation);
        }
        List invocationArgs = (List)destination$iv$iv;
        JsInvocation invocation = new JsInvocation(function, invocationArgs);
        JsBinaryOperation assignment = JsAstUtils.assignment(new JsNameRef("exports", (JsExpression)moduleName.makeRef()), invocation);
        return CollectionsKt.listOf(assignment.makeStmt());
    }

    private final List<JsStatement> wrapPlain(String moduleId, JsExpression function, List<String> importedModules, JsProgram program) {
        JsInvocation invocation = this.makePlainInvocation(function, importedModules, program);
        List<JsStatement> statements = CollectionsKt.mutableListOf(new JsStatement[0]);
        for (String importedModule : importedModules) {
            Collection collection = statements;
            JsStatement jsStatement = this.addModuleValidation(moduleId, program, importedModule);
            collection.add(jsStatement);
        }
        Collection collection = statements;
        JsStatement jsStatement = Namer.requiresEscaping(moduleId) ? JsAstUtils.assignment(this.makePlainModuleRef(moduleId, program), invocation).makeStmt() : (JsStatement)JsAstUtils.newVar(program.getRootScope().declareName(moduleId), invocation);
        collection.add(jsStatement);
        return statements;
    }

    private final JsStatement addModuleValidation(String currentModuleId, JsProgram program, String moduleName) {
        JsExpression moduleRef = this.makePlainModuleRef(moduleName, program);
        JsBinaryOperation moduleExistsCond = JsAstUtils.typeOfIs(moduleRef, program.getStringLiteral("undefined"));
        JsStringLiteral moduleNotFoundMessage = program.getStringLiteral("Error loading module '" + currentModuleId + "'. Its dependency '" + moduleName + "' was not found. " + "Please, check whether '" + moduleName + "' is loaded prior to '" + currentModuleId + "'.");
        JsExpression jsExpression = new JsNameRef("Error");
        JsStringLiteral jsStringLiteral = moduleNotFoundMessage;
        Intrinsics.checkExpressionValueIsNotNull(jsStringLiteral, "moduleNotFoundMessage");
        JsThrow moduleNotFoundThrow = new JsThrow(new JsNew(jsExpression, CollectionsKt.listOf(jsStringLiteral)));
        return new JsIf(moduleExistsCond, new JsBlock(moduleNotFoundThrow));
    }

    /*
     * WARNING - void declaration
     */
    private final JsInvocation makePlainInvocation(JsExpression function, List<String> importedModules, JsProgram program) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = importedModules;
        void var6_5 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            void var14_10 = destination$iv$iv;
            JsExpression jsExpression = INSTANCE.makePlainModuleRef((String)it, program);
            var14_10.add(jsExpression);
        }
        List invocationArgs = (List)destination$iv$iv;
        return new JsInvocation(function, invocationArgs);
    }

    private final JsExpression makePlainModuleRef(String moduleId, JsProgram program) {
        JsExpression jsExpression;
        if (Namer.requiresEscaping(moduleId)) {
            jsExpression = new JsArrayAccess(JsLiteral.THIS, program.getStringLiteral(moduleId));
        } else {
            JsExpression jsExpression2 = program.getScope().declareName(moduleId).makeRef();
            jsExpression = jsExpression2;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "program.scope.declareName(moduleId).makeRef()");
        }
        return jsExpression;
    }

    private ModuleWrapperTranslation() {
        INSTANCE = this;
    }

    static {
        new ModuleWrapperTranslation();
    }
}

