/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.util.extendable.UnmodifiableExtendableItem;

public final class ModuleRevisionId
extends UnmodifiableExtendableItem {
    private static final Map CACHE = new WeakHashMap();
    private final ModuleId moduleId;
    private final String branch;
    private final String revision;
    private int hash;

    public static ModuleRevisionId newInstance(String string, String string2, String string3) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(string, string2), string3));
    }

    public static ModuleRevisionId newInstance(String string, String string2, String string3, String string4) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(string, string2), string3, string4));
    }

    public static ModuleRevisionId newInstance(String string, String string2, String string3, String string4, Map map2) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(string, string2), string3, string4, map2));
    }

    public static ModuleRevisionId newInstance$24f5ceb1(String string, String string2, String string3, String string4, Map map2) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(string, string2), string3, string4, map2, false));
    }

    public static ModuleRevisionId newInstance(ModuleRevisionId moduleRevisionId, String string) {
        return ModuleRevisionId.intern(new ModuleRevisionId(moduleRevisionId.moduleId, moduleRevisionId.branch, string, moduleRevisionId.getQualifiedExtraAttributes()));
    }

    private static ModuleRevisionId intern(ModuleRevisionId moduleRevisionId) {
        ModuleRevisionId moduleRevisionId2 = null;
        Map map2 = CACHE;
        synchronized (map2) {
            WeakReference weakReference = (WeakReference)CACHE.get(moduleRevisionId);
            if (weakReference != null) {
                moduleRevisionId2 = (ModuleRevisionId)weakReference.get();
            }
            if (moduleRevisionId2 == null) {
                moduleRevisionId2 = moduleRevisionId;
                CACHE.put(moduleRevisionId2, new WeakReference<ModuleRevisionId>(moduleRevisionId2));
            }
        }
        return moduleRevisionId2;
    }

    public ModuleRevisionId(ModuleId moduleId, String string) {
        this(moduleId, null, string, null);
    }

    private ModuleRevisionId(ModuleId moduleId, String string, String string2) {
        this(moduleId, string, string2, null);
    }

    private ModuleRevisionId(ModuleId moduleId, String string, String string2, Map map2) {
        this(moduleId, string, string2, map2, true);
    }

    private ModuleRevisionId(ModuleId moduleId, String string, String string2, Map map2, boolean bl) {
        super(null, map2);
        String string3;
        this.moduleId = moduleId;
        IvyContext ivyContext = IvyContext.getContext();
        Object object = bl && string == null ? (ivyContext.peekIvy() == null ? null : ivyContext.getSettings().getDefaultBranch(moduleId)) : (this.branch = string);
        this.revision = string2 == null ? Ivy.getWorkingRevision() : ((string3 = string2).startsWith("[") && string3.endsWith("]") && string3.indexOf(44) == -1 && !IvyPatternHelper.getTokenString("revision").equals(string3) ? string3.substring(1, string3.length() - 1) : string3);
        this.setStandardAttribute("organisation", this.moduleId.getOrganisation());
        this.setStandardAttribute("module", this.moduleId.getName());
        this.setStandardAttribute("branch", this.branch);
        this.setStandardAttribute("revision", this.revision);
    }

    public final ModuleId getModuleId() {
        return this.moduleId;
    }

    public final String getName() {
        return this.moduleId.getName();
    }

    public final String getOrganisation() {
        return this.moduleId.getOrganisation();
    }

    public final String getRevision() {
        return this.revision;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof ModuleRevisionId)) {
            return false;
        }
        ModuleRevisionId moduleRevisionId = (ModuleRevisionId)object;
        if (!moduleRevisionId.revision.equals(this.revision)) {
            return false;
        }
        if (moduleRevisionId.branch == null && this.branch != null) {
            return false;
        }
        if (moduleRevisionId.branch != null && !moduleRevisionId.branch.equals(this.branch)) {
            return false;
        }
        if (!moduleRevisionId.moduleId.equals(this.moduleId)) {
            return false;
        }
        return ((Object)moduleRevisionId.getQualifiedExtraAttributes()).equals(this.getQualifiedExtraAttributes());
    }

    public final int hashCode() {
        if (this.hash == 0) {
            this.hash = 31;
            this.hash = this.hash * 13 + (this.branch == null ? 0 : this.branch.hashCode());
            this.hash = this.hash * 13 + this.revision.hashCode();
            this.hash = this.hash * 13 + this.moduleId.hashCode();
            this.hash = this.hash * 13 + ((Object)this.getQualifiedExtraAttributes()).hashCode();
        }
        return this.hash;
    }

    public final String toString() {
        return this.moduleId + (this.branch == null || this.branch.length() == 0 ? "" : "#" + this.branch) + ";" + (this.revision == null ? "NONE" : this.revision);
    }

    public final String encodeToString() {
        StringBuffer stringBuffer = new StringBuffer();
        HashMap hashMap = new HashMap(this.getAttributes());
        hashMap.keySet().removeAll(this.getExtraAttributes().keySet());
        hashMap.putAll(this.getQualifiedExtraAttributes());
        for (String string : hashMap.keySet()) {
            String string2 = (String)hashMap.get(string);
            string2 = string2 == null ? "@#:NULL:#@" : string2;
            stringBuffer.append("+").append(string).append(":#@#:+").append(string2).append(":#@#:");
        }
        return stringBuffer.toString();
    }

    public final String getBranch() {
        return this.branch;
    }

    static {
        Pattern.compile("([a-zA-Z0-9\\-/\\._+=]*)#([a-zA-Z0-9\\-/\\._+=]+)(?:#([a-zA-Z0-9\\-/\\._+=]+))?;([a-zA-Z0-9\\-/\\._+=,\\[\\]\\{\\}\\(\\):@]+)");
        Pattern.compile("(?:[a-zA-Z0-9\\-/\\._+=]*)#(?:[a-zA-Z0-9\\-/\\._+=]+)(?:#(?:[a-zA-Z0-9\\-/\\._+=]+))?;(?:[a-zA-Z0-9\\-/\\._+=,\\[\\]\\{\\}\\(\\):@]+)");
    }
}

