/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.FigureTransferCommand;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;

public class DeleteCommand
extends FigureTransferCommand {
    public DeleteCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selectionElements());
        this.deleteFigures(this.getUndoActivity().getAffectedFigures());
        this.view().checkDamage();
    }

    protected boolean isExecutableWithView() {
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private FigureTransferCommand myCommand;

        public UndoActivity(FigureTransferCommand newCommand) {
            super(newCommand.view());
            this.myCommand = newCommand;
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (super.undo() && this.getAffectedFigures().hasMoreElements()) {
                this.getDrawingView().clearSelection();
                this.setAffectedFigures(this.myCommand.insertFigures(this.getAffectedFigures(), 0, 0));
                return true;
            }
            return false;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                this.myCommand.deleteFigures(this.getAffectedFigures());
                this.getDrawingView().clearSelection();
                return true;
            }
            return false;
        }
    }
}

