/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view.swingext;

import ch.softenvironment.util.Tracer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterGraphics;
import javax.swing.JPanel;

public class JPanelPrintable
implements Printable {
    private JPanel panel = null;

    public JPanelPrintable(JPanel panel) {
        this.panel = panel;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= 1) {
            return 1;
        }
        PrinterGraphics gp = (PrinterGraphics)((Object)graphics);
        Tracer.getInstance().logBackendCommand("<" + gp.getPrinterJob().getJobName() + "> is being printed");
        double x0 = pageFormat.getImageableX() + 1.0;
        double y0 = pageFormat.getImageableY() + 1.0;
        double w0 = pageFormat.getImageableWidth() - 1.0;
        double h0 = pageFormat.getImageableHeight() - 1.0;
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate(x0, y0);
        Dimension dim = new Dimension(this.panel.getWidth(), this.panel.getHeight());
        double scaleX = 1.0;
        double scaleY = 1.0;
        double diag_w = dim.getWidth();
        double diag_h = dim.getHeight();
        if (diag_w > w0) {
            scaleX = w0 / diag_w;
        }
        if (diag_h > h0) {
            scaleY = h0 / diag_h;
        }
        if (scaleX < 1.0) {
            if (scaleX <= scaleY) {
                g2.scale(scaleX, scaleX);
            } else {
                g2.scale(scaleY, scaleY);
            }
        } else if (scaleY < 1.0) {
            g2.scale(scaleY, scaleY);
        }
        g2.clipRect(0, 0, (int)diag_w, (int)diag_h);
        this.panel.printAll(g2);
        return 0;
    }
}

