/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.Util;
import java.io.PrintWriter;
import java.util.Vector;

class PrintXML {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int LINE_LENGTH = 72;
    private static final String COMMENT_BORDER;
    private static final String EMPTY_COMMENT;
    private static final String IXT_EXT_SET = "ixafs";
    private static final String IXT_EXT_TV = "ixaftv";
    private static PrintWriter writer;
    private static String encoding;

    PrintXML() {
    }

    public static void printAttListDecl(String string, Vector vector, int n, int n2) throws Exception {
        Util.indent(writer, n);
        writer.write("<!ATTLIST " + string);
        int n3 = 0;
        while (n3 < vector.size()) {
            PrintXML.printLine("            " + vector.elementAt(n3));
            ++n3;
        }
        PrintXML.printLine(">");
    }

    public static void printBlankLine() throws Exception {
        Util.indent(writer, 0);
    }

    public static void printComment(String string, boolean bl) throws Exception {
        Util.indent(writer, 0);
        PrintXML.printCommentLine(COMMENT_BORDER, false, 0);
        PrintXML.printCommentLine(EMPTY_COMMENT, false, 0);
        int n = 63;
        if (string.length() < n) {
            PrintXML.printCommentLine(string, bl, 0);
        } else {
            int n2 = string.lastIndexOf(" ", n);
            String string2 = string.substring(n2 + 1);
            String string3 = string.substring(0, n2);
            PrintXML.printCommentLine(string3, bl, 0);
            while (string2.length() > n) {
                n2 = string2.lastIndexOf(" ", n - 1);
                string3 = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
                PrintXML.printCommentLine(string3, bl, 0);
            }
            PrintXML.printCommentLine(string2, bl, 0);
        }
        PrintXML.printCommentLine(COMMENT_BORDER, false, 0);
    }

    public static void printCommentLine(String string, boolean bl, int n) throws Exception {
        if (bl) {
            while (string.length() < 63) {
                string = string + " ";
            }
        }
        Util.indent(writer, n);
        writer.write("<!-- ");
        writer.write(string);
        writer.write(" -->");
    }

    public static void printDoctype(String string, String string2) throws Exception {
        Util.indent(writer, 0);
        writer.write("<!DOCTYPE ");
        writer.write(string);
        writer.write(" ");
        writer.write("SYSTEM \"");
        writer.write(string2);
        writer.write("\" ");
        writer.write("[");
        String string3 = IXT_EXT_SET;
        String string4 = "(ixaftv)+";
        Vector<String> vector = new Vector<String>();
        vector.addElement("n CDATA #REQUIRED");
        PrintXML.printElementDecl(string3, string4, null, vector, 0, 0);
        string3 = IXT_EXT_TV;
        string4 = "EMPTY";
        vector = new Vector();
        vector.addElement("t CDATA #REQUIRED");
        vector.addElement("v CDATA #REQUIRED");
        PrintXML.printElementDecl(string3, string4, null, vector, 0, 0);
        writer.write("]>");
    }

    public static void printDoctype(String string, String string2, String string3, String string4, Vector vector, int n) throws Exception {
        writer.write("<!DOCTYPE ");
        writer.write(string);
        writer.write(" ");
        writer.write("SYSTEM \"");
        writer.write(string2);
        writer.write("\" ");
        writer.write("[");
        PrintXML.printElementDecl(string3, string4, null, vector, n, n);
        String string5 = IXT_EXT_SET;
        String string6 = "(ixaftv)+";
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("s");
        vector2.addElement("CDATA");
        vector2.addElement("#REQUIRED");
        PrintXML.printElementDecl(string5, string6, null, vector2, n, n);
        string5 = IXT_EXT_TV;
        string6 = "EMPTY";
        vector2 = new Vector();
        vector2.addElement("t");
        vector2.addElement("CDATA");
        vector2.addElement("#REQUIRED");
        vector2.addElement("v");
        vector2.addElement("CDATA");
        vector2.addElement("#REQUIRED");
        PrintXML.printElementDecl(string5, string6, null, vector2, n, n);
        writer.write("]>");
    }

    public static void printElementDecl(String string, String string2, String string3, Vector vector, int n, int n2) throws Exception {
        if (string3 != null && string3.length() > 0) {
            PrintXML.printComment(string3, true);
            PrintXML.printBlankLine();
        }
        if (string2.length() + string.length() + 13 <= 72) {
            String string4 = "<!ELEMENT " + string + " " + string2 + " >";
            PrintXML.printLine(string4);
        } else {
            String string5 = "<!ELEMENT " + string + " ";
            int n3 = string5.length() + 1;
            String string6 = " ";
            while (string6.length() < n3) {
                string6 = string6 + " ";
            }
            int n4 = string2.lastIndexOf(" ", 72 - n3);
            if (n4 == -1) {
                n4 = string2.indexOf(" ");
            }
            if (n4 == -1) {
                PrintXML.printLine(string5);
                PrintXML.printLine(string6 + string2 + " >");
            } else {
                String string7 = string2.substring(n4 + 1);
                String string8 = string2.substring(0, n4);
                if (string7.substring(0, 1).equals("|")) {
                    string8 = string8 + " |";
                    string7 = string7.substring(2);
                }
                string5 = string5 + string8;
                PrintXML.printLine(string5);
                while (string7.length() > 72 - n3 && string7.length() > 0) {
                    n4 = string7.lastIndexOf(" ", 72 - n3);
                    if (n4 == -1) {
                        n4 = string7.indexOf(" ");
                    }
                    if (n4 != -1) {
                        string8 = string6 + string7.substring(0, n4);
                        string7 = string7.substring(n4 + 1);
                    } else {
                        string8 = string7;
                        string7 = "";
                    }
                    if (!string7.equals("") && string7.substring(0, 1).equals("|")) {
                        string8 = string8 + " |";
                        string7 = string7.substring(2);
                    }
                    if (!string8.substring(0, 1).equals(" ")) {
                        PrintXML.printLine(string6 + string8);
                        continue;
                    }
                    PrintXML.printLine(string8);
                }
                PrintXML.printLine(string6 + string7 + " >");
            }
        }
        if (vector != null && vector.size() > 0) {
            PrintXML.printAttListDecl(string, vector, n, n2);
        }
    }

    public static void printEndDocument() throws Exception {
        writer.flush();
    }

    public static void printEntityDecl(String string, String string2, String string3, int n, int n2) throws Exception {
        if (string3 != null && string3.length() > 0) {
            PrintXML.printComment(string3, true);
            PrintXML.printBlankLine();
        }
        Util.indent(writer, n);
        int n3 = string.length() + string2.length() + 16;
        if (n3 <= 72) {
            String string4 = "<!ENTITY % " + string + " '" + string2 + "' >";
            PrintXML.printLine(string4);
        } else {
            String string5;
            String string6;
            String string7 = "<!ENTITY % " + string;
            PrintXML.printLine(string7);
            String string8 = " ";
            while (string8.length() < 15) {
                string8 = string8 + " ";
            }
            int n4 = string2.lastIndexOf(" ", 57);
            if (string2.length() + 16 <= 72 || n4 == -1) {
                n4 = string2.length() - 1;
                string6 = "";
                string5 = string8 + "'" + string2 + "' >";
            } else {
                string6 = string2.substring(n4 + 1);
                string5 = string8 + "'" + string2.substring(0, n4);
            }
            PrintXML.printLine(string5);
            while (string6.length() + 16 > 72) {
                n4 = string6.lastIndexOf(" ", 57);
                string5 = string8 + " " + string6.substring(0, n4);
                string6 = string6.substring(n4 + 1);
                PrintXML.printLine(string5);
            }
            if (!string6.equals("")) {
                PrintXML.printLine(string8 + " " + string6 + "' >");
            }
        }
    }

    public static void printEndElement(String string, int n) throws Exception {
        if (n >= 0) {
            Util.indent(writer, n);
        }
        writer.write("</");
        writer.write(string);
        writer.write(">");
    }

    private static void printLine(String string) throws Exception {
        Util.indent(writer, 0);
        writer.write(string);
    }

    public static void printStartElement(String string, String[] stringArray, boolean bl, int n) throws Exception {
        if (n >= 0) {
            Util.indent(writer, n);
        }
        writer.write("<" + string);
        if (stringArray != null && stringArray.length > 0) {
            int n2 = 0;
            while (n2 < stringArray.length - 1) {
                if (stringArray[n2] != null) {
                    writer.write(" ");
                    writer.write(stringArray[n2]);
                    writer.write("=\"");
                    writer.write(Util.backReference(stringArray[n2 + 1], "<&\"", encoding));
                    writer.write("\"");
                }
                n2 += 2;
            }
        }
        if (bl) {
            writer.write("/");
        }
        writer.write(">");
    }

    public static void printText(String string) {
        writer.write(Util.backReference(string, encoding));
    }

    public static void printXMLPI(String string) throws Exception {
        writer.write("<?xml version=\"" + string + "\"");
        if (encoding != null && !encoding.equals("")) {
            writer.write(" encoding=\"" + encoding + "\"");
        }
        writer.write("?>");
    }

    public static void setEncoding(String string) {
        encoding = string;
    }

    public static void setPrintWriter(PrintWriter printWriter) {
        writer = printWriter;
    }

    static {
        String string = "_";
        while (string.length() < 63) {
            string = string + "_";
        }
        String string2 = " ";
        while (string2.length() < 63) {
            string2 = string2 + " ";
        }
        COMMENT_BORDER = string;
        EMPTY_COMMENT = string2;
    }
}

