/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Font;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.LogFontW;
import org.freehep.graphicsio.emf.Panose;

public class ExtLogFontW
implements EMFConstants {
    private LogFontW font;
    private String fullName;
    private String style;
    private int version;
    private int styleSize;
    private int match;
    private byte[] vendorID;
    private int culture;
    private Panose panose;

    public ExtLogFontW(LogFontW font, String fullName, String style, int version, int styleSize, int match, byte[] vendorID, int culture, Panose panose) {
        this.font = font;
        this.fullName = fullName;
        this.style = style;
        this.version = version;
        this.styleSize = styleSize;
        this.match = match;
        this.vendorID = vendorID;
        this.culture = culture;
        this.panose = panose;
    }

    public ExtLogFontW(Font font) {
        this.font = new LogFontW(font);
        this.fullName = "";
        this.style = "";
        this.version = 0;
        this.styleSize = 0;
        this.match = 0;
        this.vendorID = new byte[]{0, 0, 0, 0};
        this.culture = 0;
        this.panose = new Panose();
    }

    ExtLogFontW(EMFInputStream emf) throws IOException {
        this.font = new LogFontW(emf);
        this.fullName = emf.readWCHAR(64);
        this.style = emf.readWCHAR(32);
        this.version = emf.readDWORD();
        this.styleSize = emf.readDWORD();
        this.match = emf.readDWORD();
        emf.readDWORD();
        this.vendorID = emf.readBYTE(4);
        this.culture = emf.readDWORD();
        this.panose = new Panose(emf);
        emf.readWORD();
    }

    public void write(EMFOutputStream emf) throws IOException {
        this.font.write(emf);
        emf.writeWCHAR(this.fullName, 64);
        emf.writeWCHAR(this.style, 32);
        emf.writeDWORD(this.version);
        emf.writeDWORD(this.styleSize);
        emf.writeDWORD(this.match);
        emf.writeDWORD(0);
        emf.writeBYTE(this.vendorID);
        emf.writeDWORD(this.culture);
        this.panose.write(emf);
        emf.writeWORD(0);
    }

    public String toString() {
        return super.toString() + "\n" + "  LogFontW\n" + this.font.toString() + "\n" + "    fullname: " + this.fullName + "\n" + "    style: " + this.style + "\n" + "    version: " + this.version + "\n" + "    stylesize: " + this.styleSize + "\n" + "    match: " + this.match + "\n" + "    vendorID: " + this.vendorID + "\n" + "    culture: " + this.culture + "\n" + this.panose.toString();
    }
}

