/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.system;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.owasp.jbrofuzz.system.FileListener;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.system.SimpleFileMonitor;
import org.owasp.jbrofuzz.ui.AbstractPanel;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;

public class SystemPanel
extends AbstractPanel {
    private static final long serialVersionUID = 6122485751450521994L;
    private final JTextPane listTextArea;
    private final DefaultStyledDocument styleDoc;
    private int lineCount = 0;

    public SystemPanel(JBroFuzzWindow m) {
        super(" System ", m);
        this.setOptionsAvailable(true, false, true, true, false);
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" System Logger "), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.styleDoc = new DefaultStyledDocument();
        this.listTextArea = new JTextPane(this.styleDoc);
        this.listTextArea.setFont(new Font("Monospaced", 0, 12));
        this.listTextArea.setOpaque(true);
        this.listTextArea.setEditable(false);
        this.listTextArea.setBackground(Color.BLACK);
        AbstractPanel.popupText(this.listTextArea, false, true, false, true);
        JScrollPane scrollPane = new JScrollPane(this.listTextArea);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        listPanel.add(scrollPane);
        JPanel topPanel = new JPanel(new FlowLayout(2, 50, 33));
        JSplitPane mainPane = new JSplitPane(0);
        mainPane.setOneTouchExpandable(false);
        mainPane.setTopComponent(topPanel);
        mainPane.setBottomComponent(listPanel);
        mainPane.setDividerLocation(50);
        topPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        listPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.add((Component)mainPane, "Center");
        this.listTextArea.setCaretPosition(0);
        this.monitorLog();
    }

    @Override
    public void add() {
        Date currentTime = new Date();
        SimpleDateFormat dateTime = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss:SSS", new Locale("en"));
        Logger.log("JBroFuzz Timestamp --- " + dateTime.format(currentTime) + " --- JBroFuzz Timestamp", 0);
    }

    @Override
    public void pause() {
    }

    @Override
    public void remove() {
    }

    @Override
    public void start() {
        Logger.log();
    }

    private void start(String str, int level) {
        StringBuffer toLog = new StringBuffer();
        Color cColour = level <= 0 ? new Color(152, 229, 255) : (level == 1 ? Color.GREEN : (level == 2 ? Color.YELLOW : (level == 3 ? new Color(255, 128, 0) : Color.RED)));
        toLog.append(str);
        toLog.append('\n');
        ++this.lineCount;
        this.lineCount %= 10;
        try {
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setForeground(attr, cColour);
            this.styleDoc.insertString(this.styleDoc.getLength(), toLog.toString(), attr);
            this.listTextArea.setCaretPosition(this.styleDoc.getLength());
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void stop() {
    }

    private final void monitorLog() {
        try {
            final SimpleFileMonitor monitor = new SimpleFileMonitor(1000L, Logger.getLogFile());
            monitor.addListener(new FileListener(){

                @Override
                public void fileChanged(File file) {
                    SystemPanel.this.writeLinesFromFile(monitor);
                }
            });
        }
        catch (IOException e) {
            this.start("Log file is corrupted or does not exist", 4);
        }
    }

    private void writeLinesFromFile(SimpleFileMonitor monitor) {
        try {
            long length = monitor.getLastLength();
            ArrayList<String> linesToWrite = Logger.readLogFile(length);
            int i = 0;
            while (i < linesToWrite.size()) {
                String line = linesToWrite.get(i);
                if (line.indexOf("[INFO]") != -1) {
                    this.start(line, 0);
                } else if (line.indexOf("[OPPR]") != -1) {
                    this.start(line, 1);
                } else if (line.indexOf("[WARN]") != -1) {
                    this.start(line, 2);
                } else if (line.indexOf("[SHOT]") != -1) {
                    this.start(line, 3);
                } else {
                    this.start(line, 4);
                }
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            this.start("Log file not found", 4);
        }
        catch (IOException e) {
            this.start("Error reading log file", 4);
        }
    }
}

