/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.View;
import java.util.HashMap;
import java.util.Map;

public class TouchInputSupport {
    private int touchCount = 0;
    private boolean filterTouchCoordinates;
    private Map<Long, Integer> touchX;
    private Map<Long, Integer> touchY;
    private TouchCountListener listener;
    private int curTouchCount;
    private View curView;
    private int curModifiers;
    private boolean curIsDirect;

    public TouchInputSupport(TouchCountListener listener, boolean filterTouchCoordinates) {
        this.listener = listener;
        this.filterTouchCoordinates = filterTouchCoordinates;
        if (filterTouchCoordinates) {
            this.touchX = new HashMap<Long, Integer>();
            this.touchY = new HashMap<Long, Integer>();
        }
    }

    public int getTouchCount() {
        return this.touchCount;
    }

    public void notifyBeginTouchEvent(View view, int modifiers, boolean isDirect, int touchEventCount) {
        this.curTouchCount = this.touchCount;
        this.curView = view;
        this.curModifiers = modifiers;
        this.curIsDirect = isDirect;
        if (view != null) {
            view.notifyBeginTouchEvent(modifiers, isDirect, touchEventCount);
        }
    }

    public void notifyEndTouchEvent(View view) {
        if (view == null) {
            return;
        }
        view.notifyEndTouchEvent();
        if (this.curTouchCount != 0 && this.touchCount != 0 && this.curTouchCount != this.touchCount && this.listener != null) {
            this.listener.touchCountChanged(this, this.curView, this.curModifiers, this.curIsDirect);
        }
    }

    public void notifyNextTouchEvent(View view, int state, long id, int x, int y, int xAbs, int yAbs) {
        switch (state) {
            case 813: {
                --this.touchCount;
                break;
            }
            case 811: {
                ++this.touchCount;
            }
        }
        if (this.filterTouchCoordinates) {
            state = this.filterTouchInputState(state, id, x, y);
        }
        if (view != null) {
            view.notifyNextTouchEvent(state, id, x, y, xAbs, yAbs);
        }
    }

    private int filterTouchInputState(int state, long id, int x, int y) {
        switch (state) {
            case 813: {
                this.touchX.remove(id);
                this.touchY.remove(id);
                break;
            }
            case 812: {
                if (x == this.touchX.get(id) && y == this.touchY.get(id)) {
                    state = 814;
                    break;
                }
            }
            case 811: {
                this.touchX.put(id, x);
                this.touchY.put(id, y);
            }
        }
        return state;
    }

    public static interface TouchCountListener {
        public void touchCountChanged(TouchInputSupport var1, View var2, int var3, boolean var4);
    }
}

