/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.scene.layout.region.BorderImage;
import com.sun.javafx.scene.layout.region.Margins;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.geometry.Insets;
import javafx.scene.image.Image;

public final class BorderImageConverter
extends StyleConverter<ParsedValue[], List<BorderImage>> {
    public static BorderImageConverter getInstance() {
        return Holder.BORDER_IMAGE_CONVERTER;
    }

    private BorderImageConverter() {
    }

    @Override
    public List<BorderImage> convert(Map<StyleableProperty, Object> map) {
        Object object;
        int n;
        String[] stringArray = null;
        BorderImage.BorderImageRepeat[] borderImageRepeatArray = null;
        BorderImage.BorderImageSlice[] borderImageSliceArray = null;
        Margins[] marginsArray = null;
        Insets[] insetsArray = null;
        List<StyleableProperty> list = BorderImage.impl_CSS_STYLEABLES();
        for (n = 0; n < list.size(); ++n) {
            object = list.get(n);
            Object object2 = map.get(object);
            if (object2 == null) continue;
            if ("-fx-border-image-source".equals(((StyleableProperty)object).getProperty())) {
                stringArray = (String[])object2;
                continue;
            }
            if ("-fx-border-image-repeat".equals(((StyleableProperty)object).getProperty())) {
                borderImageRepeatArray = (BorderImage.BorderImageRepeat[])object2;
                continue;
            }
            if ("-fx-border-image-slice".equals(((StyleableProperty)object).getProperty())) {
                borderImageSliceArray = (BorderImage.BorderImageSlice[])object2;
                continue;
            }
            if ("-fx-border-image-width".equals(((StyleableProperty)object).getProperty())) {
                marginsArray = (Margins[])object2;
                continue;
            }
            if (!"-fx-border-image-insets".equals(((StyleableProperty)object).getProperty())) continue;
            insetsArray = (Insets[])object2;
        }
        n = stringArray != null ? stringArray.length : 0;
        object = new ArrayList();
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) continue;
            BorderImage.BorderImageRepeat borderImageRepeat = borderImageRepeatArray != null ? borderImageRepeatArray[Math.min(i, borderImageRepeatArray.length - 1)] : null;
            BorderImage.BorderImageSlice borderImageSlice = borderImageSliceArray != null ? borderImageSliceArray[Math.min(i, borderImageSliceArray.length - 1)] : null;
            Margins margins = marginsArray != null ? marginsArray[Math.min(i, marginsArray.length - 1)] : null;
            Insets insets = insetsArray != null ? insetsArray[Math.min(i, insetsArray.length - 1)] : null;
            BorderImage.Builder builder = new BorderImage.Builder();
            builder.setImage(new Image(stringArray[i]));
            if (margins != null) {
                builder.setTopWidth(margins.getTop()).setRightWidth(margins.getRight()).setBottomWidth(margins.getBottom()).setLeftWidth(margins.getLeft()).setProportionalWidth(margins.isProportional());
            }
            if (insets != null) {
                builder.setOffsets(insets);
            }
            if (borderImageSlice != null) {
                builder.setFillCenter(borderImageSlice.isFill()).setTopSlice(borderImageSlice.getTop()).setRightSlice(borderImageSlice.getRight()).setBottomSlice(borderImageSlice.getBottom()).setLeftSlice(borderImageSlice.getLeft()).setProportionalSlice(borderImageSlice.isProportional());
            }
            if (borderImageRepeat != null) {
                builder.setRepeatX(borderImageRepeat.getRepeatX()).setRepeatY(borderImageRepeat.getRepeatY());
            }
            object.add(builder.build());
        }
        return object;
    }

    private static class Holder {
        private static final BorderImageConverter BORDER_IMAGE_CONVERTER = new BorderImageConverter();

        private Holder() {
        }
    }
}

