/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.net.URL;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.extension.report.ReportGenerator;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class Alert
implements Comparable<Alert> {
    public static final int RISK_INFO = 0;
    public static final int RISK_LOW = 1;
    public static final int RISK_MEDIUM = 2;
    public static final int RISK_HIGH = 3;
    public static final int CONFIDENCE_FALSE_POSITIVE = 0;
    @Deprecated
    public static final int SUSPICIOUS = 1;
    public static final int CONFIDENCE_LOW = 1;
    @Deprecated
    public static final int WARNING = 2;
    public static final int CONFIDENCE_MEDIUM = 2;
    public static final int CONFIDENCE_HIGH = 3;
    public static final int CONFIDENCE_USER_CONFIRMED = 4;
    public static final String[] MSG_RISK = new String[]{"Informational", "Low", "Medium", "High"};
    @Deprecated
    public static final String[] MSG_RELIABILITY = new String[]{"False Positive", "Low", "Medium", "High", "Confirmed"};
    public static final String[] MSG_CONFIDENCE = new String[]{"False Positive", "Low", "Medium", "High", "Confirmed"};
    private int alertId = -1;
    private int pluginId = 0;
    private String name = "";
    private int risk = 0;
    @Deprecated
    private int reliability = 2;
    private int confidence = 2;
    private String description = "";
    private String uri = "";
    private String param = "";
    private String attack = "";
    private String otherInfo = "";
    private String solution = "";
    private String reference = "";
    private String evidence = "";
    private int cweId = -1;
    private int wascId = -1;
    private HttpMessage message = null;
    private int sourceHistoryId = 0;
    private HistoryReference historyRef = null;
    private static final Logger logger = Logger.getLogger(Alert.class);
    private String method = null;
    private String postData;
    private URI msgUri = null;

    public Alert(int n) {
        this.pluginId = n;
    }

    public Alert(int n, int n2, int n3, String string) {
        this(n);
        this.setRiskConfidence(n2, n3);
        this.setName(string);
    }

    public Alert(RecordAlert recordAlert) {
        this(recordAlert.getPluginId(), recordAlert.getRisk(), recordAlert.getConfidence(), recordAlert.getAlert());
        this.alertId = recordAlert.getAlertId();
        try {
            HistoryReference historyReference = new HistoryReference(recordAlert.getHistoryId());
            this.setDetail(recordAlert.getDescription(), recordAlert.getUri(), recordAlert.getParam(), recordAlert.getAttack(), recordAlert.getOtherInfo(), recordAlert.getSolution(), recordAlert.getReference(), recordAlert.getEvidence(), recordAlert.getCweId(), recordAlert.getWascId(), null);
            this.setHistoryRef(historyReference);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            logger.debug((Object)httpMalformedHeaderException.getMessage(), (Throwable)httpMalformedHeaderException);
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public Alert(RecordAlert recordAlert, HistoryReference historyReference) {
        this(recordAlert.getPluginId(), recordAlert.getRisk(), recordAlert.getConfidence(), recordAlert.getAlert());
        this.alertId = recordAlert.getAlertId();
        this.setDetail(recordAlert.getDescription(), recordAlert.getUri(), recordAlert.getParam(), recordAlert.getAttack(), recordAlert.getOtherInfo(), recordAlert.getSolution(), recordAlert.getReference(), recordAlert.getEvidence(), recordAlert.getCweId(), recordAlert.getWascId(), null);
        this.setHistoryRef(historyReference);
    }

    @Deprecated
    public void setRiskReliability(int n, int n2) {
        this.risk = n;
        this.confidence = n2;
    }

    public void setRiskConfidence(int n, int n2) {
        this.risk = n;
        this.confidence = n2;
    }

    @Deprecated
    public void setAlert(String string) {
        this.setName(string);
    }

    public void setName(String string) {
        if (string == null) {
            return;
        }
        this.name = string;
    }

    @Deprecated
    public void setDetail(String string, String string2, String string3, String string4, String string5, String string6, String string7, HttpMessage httpMessage) {
        this.setDetail(string, string2, string3, string4, string5, string6, string7, "", -1, -1, httpMessage);
    }

    public void setDetail(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, int n2, HttpMessage httpMessage) {
        this.setDescription(string);
        this.setUri(string2);
        this.setParam(string3);
        this.setAttack(string4);
        this.setOtherInfo(string5);
        this.setSolution(string6);
        this.setReference(string7);
        this.setMessage(httpMessage);
        this.setEvidence(string8);
        this.setCweId(n);
        this.setWascId(n2);
        if (httpMessage != null) {
            this.setHistoryRef(httpMessage.getHistoryRef());
        }
    }

    private void setDetail(String string, String string2, String string3, String string4, String string5, String string6, String string7, HistoryReference historyReference) {
        this.setDescription(string);
        this.setUri(string2);
        this.setParam(string3);
        this.setAttack(string4);
        this.setOtherInfo(string5);
        this.setSolution(string6);
        this.setReference(string7);
        this.setHistoryRef(historyReference);
    }

    public void setUri(String string) {
        if (string == null) {
            return;
        }
        this.uri = string;
    }

    public void setDescription(String string) {
        if (string == null) {
            return;
        }
        this.description = string;
    }

    public void setParam(String string) {
        if (string == null) {
            return;
        }
        this.param = string;
    }

    public void setOtherInfo(String string) {
        if (string == null) {
            return;
        }
        this.otherInfo = string;
    }

    public void setSolution(String string) {
        if (string == null) {
            return;
        }
        this.solution = string;
    }

    public void setReference(String string) {
        if (string == null) {
            return;
        }
        this.reference = string;
    }

    public void setMessage(HttpMessage httpMessage) {
        if (httpMessage != null) {
            this.message = httpMessage;
            this.method = httpMessage.getRequestHeader().getMethod();
            this.postData = httpMessage.getRequestBody().toString();
            this.msgUri = httpMessage.getRequestHeader().getURI();
        } else {
            this.message = null;
        }
    }

    @Override
    public int compareTo(Alert alert) {
        if (this.risk < alert.risk) {
            return -1;
        }
        if (this.risk > alert.risk) {
            return 1;
        }
        if (this.confidence < alert.confidence) {
            return -1;
        }
        if (this.confidence > alert.confidence) {
            return 1;
        }
        if (this.pluginId < alert.pluginId) {
            return -1;
        }
        if (this.pluginId > alert.pluginId) {
            return 1;
        }
        int n = this.name.compareToIgnoreCase(alert.name);
        if (n != 0) {
            return n;
        }
        n = this.uri.compareToIgnoreCase(alert.uri);
        if (n != 0) {
            return n;
        }
        n = this.param.compareToIgnoreCase(alert.param);
        if (n != 0) {
            return n;
        }
        n = this.otherInfo.compareToIgnoreCase(alert.otherInfo);
        if (n != 0) {
            return n;
        }
        n = this.compareStrings(this.evidence, alert.evidence);
        if (n != 0) {
            return n;
        }
        return this.compareStrings(this.attack, alert.attack);
    }

    private int compareStrings(String string, String string2) {
        if (string == null) {
            if (string2 == null) {
                return 0;
            }
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Alert alert = (Alert)object;
        if (this.risk != alert.risk) {
            return false;
        }
        if (this.confidence != alert.confidence) {
            return false;
        }
        if (this.pluginId != alert.pluginId) {
            return false;
        }
        if (!this.name.equals(alert.name)) {
            return false;
        }
        if (!this.uri.equalsIgnoreCase(alert.uri)) {
            return false;
        }
        if (!this.param.equalsIgnoreCase(alert.param)) {
            return false;
        }
        if (!this.otherInfo.equalsIgnoreCase(alert.otherInfo)) {
            return false;
        }
        if (this.evidence == null ? alert.evidence != null : !this.evidence.equals(alert.evidence)) {
            return false;
        }
        return !(this.attack == null ? alert.attack != null : !this.attack.equals(alert.attack));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.risk;
        n = 31 * n + this.confidence;
        n = 31 * n + (this.evidence == null ? 0 : this.evidence.hashCode());
        n = 31 * n + this.name.hashCode();
        n = 31 * n + this.otherInfo.hashCode();
        n = 31 * n + this.param.hashCode();
        n = 31 * n + this.pluginId;
        n = 31 * n + this.uri.hashCode();
        n = 31 * n + (this.attack == null ? 0 : this.attack.hashCode());
        return n;
    }

    public Alert newInstance() {
        Alert alert = new Alert(this.pluginId);
        alert.setRiskConfidence(this.risk, this.confidence);
        alert.setName(this.name);
        alert.setDetail(this.description, this.uri, this.param, this.attack, this.otherInfo, this.solution, this.reference, this.historyRef);
        return alert;
    }

    public String toPluginXML(String string) {
        StringBuilder stringBuilder = new StringBuilder(150);
        stringBuilder.append("<alertitem>\r\n");
        stringBuilder.append("  <pluginid>").append(this.pluginId).append("</pluginid>\r\n");
        stringBuilder.append("  <alert>").append(this.replaceEntity(this.name)).append("</alert>\r\n");
        stringBuilder.append("  <name>").append(this.replaceEntity(this.name)).append("</name>\r\n");
        stringBuilder.append("  <riskcode>").append(this.risk).append("</riskcode>\r\n");
        stringBuilder.append("  <confidence>").append(this.confidence).append("</confidence>\r\n");
        stringBuilder.append("  <riskdesc>").append(this.replaceEntity(MSG_RISK[this.risk] + " (" + MSG_CONFIDENCE[this.confidence] + ")")).append("</riskdesc>\r\n");
        stringBuilder.append("  <desc>").append(this.replaceEntity(this.paragraph(this.description))).append("</desc>\r\n");
        stringBuilder.append(string);
        stringBuilder.append("  <solution>").append(this.replaceEntity(this.paragraph(this.solution))).append("</solution>\r\n");
        if (this.otherInfo != null && this.otherInfo.length() > 0) {
            stringBuilder.append("  <otherinfo>").append(this.replaceEntity(this.paragraph(this.otherInfo))).append("</otherinfo>\r\n");
        }
        stringBuilder.append("  <reference>").append(this.replaceEntity(this.paragraph(this.reference))).append("</reference>\r\n");
        if (this.cweId > 0) {
            stringBuilder.append("  <cweid>").append(this.cweId).append("</cweid>\r\n");
        }
        if (this.wascId > 0) {
            stringBuilder.append("  <wascid>").append(this.wascId).append("</wascid>\r\n");
        }
        stringBuilder.append("</alertitem>\r\n");
        return stringBuilder.toString();
    }

    public String replaceEntity(String string) {
        String string2 = null;
        if (string != null) {
            string2 = ReportGenerator.entityEncode(string);
        }
        return string2;
    }

    public String paragraph(String string) {
        return "<p>" + string.replaceAll("\\r\\n", "</p><p>").replaceAll("\\n", "</p><p>") + "</p>";
    }

    @Deprecated
    public String getAlert() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPluginId() {
        return this.pluginId;
    }

    public HttpMessage getMessage() {
        if (this.message != null) {
            return this.message;
        }
        if (this.historyRef != null) {
            try {
                return this.historyRef.getHttpMessage();
            }
            catch (DatabaseException | HttpMalformedHeaderException exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return null;
    }

    public String getOtherInfo() {
        return this.otherInfo;
    }

    public String getParam() {
        return this.param;
    }

    public String getReference() {
        return this.reference;
    }

    @Deprecated
    public int getReliability() {
        return this.confidence;
    }

    public int getConfidence() {
        return this.confidence;
    }

    public int getRisk() {
        return this.risk;
    }

    public URL getIconUrl() {
        if (this.reliability == 0 || this.confidence == 0) {
            return Constant.OK_FLAG_IMAGE_URL;
        }
        switch (this.risk) {
            case 0: {
                return Constant.INFO_FLAG_IMAGE_URL;
            }
            case 1: {
                return Constant.LOW_FLAG_IMAGE_URL;
            }
            case 2: {
                return Constant.MED_FLAG_IMAGE_URL;
            }
            case 3: {
                return Constant.HIGH_FLAG_IMAGE_URL;
            }
        }
        return null;
    }

    public String getSolution() {
        return this.solution;
    }

    public String getUri() {
        return this.uri;
    }

    public int getAlertId() {
        return this.alertId;
    }

    public void setAlertId(int n) {
        this.alertId = n;
    }

    public String getUrlParamXML() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("  <uri>").append(this.replaceEntity(this.uri)).append("</uri>\r\n");
        if (this.param != null && this.param.length() > 0) {
            stringBuilder.append("  <param>").append(this.replaceEntity(this.param)).append("</param>\r\n");
        }
        if (this.attack != null && this.attack.length() > 0) {
            stringBuilder.append("  <attack>").append(this.replaceEntity(this.attack)).append("</attack>\r\n");
        }
        if (this.evidence != null && this.evidence.length() > 0) {
            stringBuilder.append("  <evidence>").append(this.replaceEntity(this.evidence)).append("</evidence>\r\n");
        }
        return stringBuilder.toString();
    }

    public int getSourceHistoryId() {
        return this.sourceHistoryId;
    }

    public void setSourceHistoryId(int n) {
        this.sourceHistoryId = n;
    }

    public HistoryReference getHistoryRef() {
        return this.historyRef;
    }

    public void setHistoryRef(HistoryReference historyReference) {
        this.historyRef = historyReference;
        if (historyReference != null) {
            this.message = null;
            this.method = historyReference.getMethod();
            this.msgUri = historyReference.getURI();
            this.postData = historyReference.getRequestBody();
            this.sourceHistoryId = historyReference.getHistoryId();
        }
    }

    public String getAttack() {
        return this.attack;
    }

    public void setAttack(String string) {
        this.attack = string;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPostData() {
        return this.postData;
    }

    public URI getMsgUri() {
        return this.msgUri;
    }

    public String getEvidence() {
        return this.evidence;
    }

    public void setEvidence(String string) {
        this.evidence = string;
    }

    public int getCweId() {
        return this.cweId;
    }

    public void setCweId(int n) {
        this.cweId = n;
    }

    public int getWascId() {
        return this.wascId;
    }

    public void setWascId(int n) {
        this.wascId = n;
    }
}

