/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLSocket;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.zaproxy.zap.network.HttpRequestBody;
import org.zaproxy.zap.network.HttpResponseBody;

public class HttpInputStream
extends BufferedInputStream {
    private static Logger log = Logger.getLogger(HttpInputStream.class);
    private static final int BUFFER_SIZE = 4096;
    private static final String CRLF = "\r\n";
    private static final String CRLF2 = "\r\n\r\n";
    private static final String LF = "\n";
    private static final String LF2 = "\n\n";
    private byte[] mBuffer = new byte[4096];
    private Socket mSocket = null;

    public HttpInputStream(Socket socket) throws IOException {
        super(socket.getInputStream(), 4096);
        this.setSocket(socket);
    }

    public HttpRequestHeader readRequestHeader(boolean bl) throws HttpMalformedHeaderException, IOException {
        String string = "";
        HttpRequestHeader httpRequestHeader = null;
        string = this.readHeader();
        if (string.length() == 0) {
            log.debug((Object)"Read 0 bytes from upstream. Could not read header!");
            throw new IOException();
        }
        httpRequestHeader = new HttpRequestHeader(string, bl);
        return httpRequestHeader;
    }

    public synchronized String readHeader() throws IOException {
        String string = "";
        int n = -1;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(200);
        do {
            if ((n = super.read()) == -1) {
                bl = true;
                break;
            }
            stringBuilder.append((char)n);
            if ((char)n != '\n' || !HttpInputStream.isHeaderEnd(stringBuilder)) continue;
            bl = true;
            string = stringBuilder.toString();
        } while (!bl);
        return string;
    }

    private static final boolean isHeaderEnd(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        if (n > 2 && LF2.equals(stringBuilder.substring(n - 2))) {
            return true;
        }
        return n > 4 && CRLF2.equals(stringBuilder.substring(n - 4));
    }

    public synchronized HttpRequestBody readRequestBody(HttpHeader httpHeader) {
        int n = httpHeader.getContentLength();
        HttpRequestBody httpRequestBody = n > 0 ? new HttpRequestBody(n) : new HttpRequestBody();
        this.readBody(n, httpRequestBody);
        return httpRequestBody;
    }

    public synchronized HttpResponseBody readResponseBody(HttpHeader httpHeader) {
        int n = httpHeader.getContentLength();
        HttpResponseBody httpResponseBody = n > 0 ? new HttpResponseBody(n) : new HttpResponseBody();
        this.readBody(n, httpResponseBody);
        return httpResponseBody;
    }

    private void readBody(int n, HttpBody httpBody) {
        int n2 = 0;
        int n3 = 0;
        try {
            while (n == -1 || n2 < n) {
                n3 = this.readBody(n, n2, this.mBuffer);
                if (n3 > 0) {
                    n2 += n3;
                } else if (n3 < 0) break;
                httpBody.append(this.mBuffer, n3);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int readBody(int n, int n2, byte[] byArray) throws IOException {
        int n3 = 0;
        int n4 = 0;
        if (n == -1) {
            n3 = super.read(byArray);
        } else {
            n4 = n - n2;
            if (n4 < byArray.length && n4 > 0) {
                n3 = super.read(byArray, 0, n4);
            } else if (n4 > byArray.length) {
                n3 = super.read(byArray);
            }
        }
        return n3;
    }

    public void setSocket(Socket socket) {
        this.mSocket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        int n = 0;
        int n2 = 0;
        n = super.available();
        if (n == 0 && this.mSocket != null && this.mSocket instanceof SSLSocket) {
            try {
                n2 = this.mSocket.getSoTimeout();
                this.mSocket.setSoTimeout(1);
                super.mark(256);
                super.read();
                super.reset();
                n = super.available();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                n = 0;
            }
            finally {
                this.mSocket.setSoTimeout(n2);
            }
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        return super.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return super.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return super.read(byArray, n, n2);
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

