/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class PolicyManager {
    public static final String POLICY_EXTENSION = ".policy";
    private static final String DEFAULT_POLICY_NAME = Constant.messages.getString("ascan.policymgr.default.name");
    public static final String ILLEGAL_POLICY_NAME_CHRS = "/`?*\\<>|\":\t\n\r";
    private List<String> allPolicyNames = null;
    private ExtensionActiveScan extension;
    private static final Logger logger = Logger.getLogger(PolicyManager.class);

    public PolicyManager(ExtensionActiveScan extensionActiveScan) {
        this.extension = extensionActiveScan;
    }

    public void init() {
        this.getAllPolicyNames();
    }

    public synchronized List<String> getAllPolicyNames() {
        if (this.allPolicyNames == null) {
            this.allPolicyNames = new ArrayList<String>();
            String[] stringArray = Constant.getPoliciesDir().list();
            if (stringArray != null) {
                for (String string : stringArray) {
                    if (!string.endsWith(POLICY_EXTENSION)) continue;
                    logger.debug((Object)("Found policy file " + (String)string));
                    this.allPolicyNames.add(string.substring(0, string.lastIndexOf(POLICY_EXTENSION)));
                }
            }
            if (this.allPolicyNames.size() == 0) {
                ScanPolicy scanPolicy = new ScanPolicy();
                scanPolicy.setName(DEFAULT_POLICY_NAME);
                scanPolicy.getPluginFactory().loadAllPlugin((Configuration)this.extension.getScannerParam().getConfig());
                try {
                    this.savePolicy(scanPolicy);
                }
                catch (ConfigurationException configurationException) {
                    logger.debug((Object)("Failed to create default scan policy in " + Constant.getPoliciesDir().getAbsolutePath()), (Throwable)configurationException);
                }
            }
            Collections.sort(this.allPolicyNames);
        }
        return this.allPolicyNames;
    }

    public void savePolicy(ScanPolicy scanPolicy) throws ConfigurationException {
        this.savePolicy(scanPolicy, null);
    }

    public void savePolicy(ScanPolicy scanPolicy, String string) throws ConfigurationException {
        logger.debug((Object)("Save policy " + scanPolicy.getName()));
        File file = new File(Constant.getPoliciesDir(), scanPolicy.getName() + POLICY_EXTENSION);
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration();
        zapXmlConfiguration.setProperty("policy", scanPolicy.getName());
        zapXmlConfiguration.setProperty("scanner.level", scanPolicy.getDefaultThreshold().name());
        zapXmlConfiguration.setProperty("scanner.strength", scanPolicy.getDefaultStrength().name());
        scanPolicy.getPluginFactory().saveTo((Configuration)zapXmlConfiguration);
        zapXmlConfiguration.save(file);
        if (string != null && string.length() > 0) {
            this.allPolicyNames.remove(string);
        }
        if (!this.allPolicyNames.contains(scanPolicy.getName())) {
            this.allPolicyNames.add(scanPolicy.getName());
            Collections.sort(this.allPolicyNames);
        }
    }

    public static boolean policyExists(String string) {
        return new File(Constant.getPoliciesDir(), string + POLICY_EXTENSION).exists();
    }

    public ScanPolicy getPolicy(String string) throws ConfigurationException {
        return this.loadPolicy(new File(Constant.getPoliciesDir(), string + POLICY_EXTENSION));
    }

    public ScanPolicy loadPolicy(String string) throws ConfigurationException {
        return this.loadPolicy(new File(Constant.getPoliciesDir(), string + POLICY_EXTENSION));
    }

    private ScanPolicy loadPolicy(File file) throws ConfigurationException {
        File file2;
        try {
            file2 = file.toPath().toRealPath(new LinkOption[0]).toFile();
        }
        catch (IOException iOException) {
            throw new ConfigurationException("Failed to obtain the real path of the policy file:", (Throwable)iOException);
        }
        ScanPolicy scanPolicy = new ScanPolicy(new ZapXmlConfiguration(file2));
        if (!file2.getName().equals(scanPolicy.getName() + POLICY_EXTENSION)) {
            scanPolicy.setName(file2.getName().substring(0, file2.getName().indexOf(POLICY_EXTENSION)));
        }
        return scanPolicy;
    }

    public void importPolicy(File file) throws ConfigurationException, IOException {
        logger.debug((Object)("Import policy from " + file.getAbsolutePath()));
        ScanPolicy scanPolicy = new ScanPolicy(new ZapXmlConfiguration(file));
        String string = file.getName();
        if (string.endsWith(POLICY_EXTENSION)) {
            string = string.substring(0, string.indexOf(POLICY_EXTENSION));
        }
        String string2 = string;
        File file2 = new File(Constant.getPoliciesDir(), string2 + POLICY_EXTENSION);
        int n = 2;
        while (file2.exists()) {
            string2 = string + n;
            file2 = new File(Constant.getPoliciesDir(), string2 + POLICY_EXTENSION);
            ++n;
        }
        scanPolicy.setName(string2);
        this.savePolicy(scanPolicy);
    }

    public void exportPolicy(ScanPolicy scanPolicy, File file) throws ConfigurationException {
        logger.debug((Object)("Export policy to " + file.getAbsolutePath()));
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration();
        zapXmlConfiguration.setProperty("policy", scanPolicy.getName());
        zapXmlConfiguration.setProperty("scanner.level", scanPolicy.getDefaultThreshold().name());
        zapXmlConfiguration.setProperty("scanner.strength", scanPolicy.getDefaultStrength().name());
        scanPolicy.getPluginFactory().saveTo((Configuration)zapXmlConfiguration);
        zapXmlConfiguration.save(file);
    }

    public ScanPolicy getTemplatePolicy() throws ConfigurationException {
        return new ScanPolicy();
    }

    public void deletePolicy(String string) {
        logger.debug((Object)("Delete policy " + string));
        File file = new File(Constant.getPoliciesDir(), string + POLICY_EXTENSION);
        if (file.exists()) {
            file.delete();
        }
        this.allPolicyNames.remove(string);
    }

    public ScanPolicy getDefaultScanPolicy() {
        try {
            String string = this.extension.getScannerParam().getDefaultPolicy();
            if (PolicyManager.policyExists(string)) {
                logger.debug((Object)("getDefaultScanPolicy: " + string));
                return this.loadPolicy(string);
            }
            string = DEFAULT_POLICY_NAME;
            if (PolicyManager.policyExists(string)) {
                logger.debug((Object)("getDefaultScanPolicy (default name): " + string));
                return this.loadPolicy(string);
            }
            if (this.allPolicyNames.size() > 0) {
                logger.debug((Object)("getDefaultScanPolicy (first one): " + string));
                return this.loadPolicy(this.allPolicyNames.get(0));
            }
        }
        catch (ConfigurationException configurationException) {
            logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
        }
        logger.debug((Object)"getDefaultScanPolicy (new blank)");
        return new ScanPolicy();
    }

    public ScanPolicy getAttackScanPolicy() {
        try {
            String string = this.extension.getScannerParam().getAttackPolicy();
            if (PolicyManager.policyExists(string)) {
                return this.loadPolicy(string);
            }
            string = DEFAULT_POLICY_NAME;
            if (PolicyManager.policyExists(string)) {
                return this.loadPolicy(string);
            }
            if (this.allPolicyNames.size() > 0) {
                return this.loadPolicy(this.allPolicyNames.get(0));
            }
        }
        catch (ConfigurationException configurationException) {
            logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
        }
        return new ScanPolicy();
    }

    public boolean isLegalPolicyName(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (ILLEGAL_POLICY_NAME_CHRS.indexOf(string.charAt(i)) < 0) continue;
            return false;
        }
        return true;
    }
}

