/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.keyboard;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public class KeyboardParam
extends AbstractParam {
    private static final Logger logger = Logger.getLogger(KeyboardParam.class);
    private static final String KEYBOARD_BASE_KEY = "keyboard";
    private static final String ALL_SHORTCUTS_KEY = "keyboard.shortcuts";
    private static final String MENU_ITEM_KEY = "menu";
    private static final String KEYCODE_KEY = "keycode";
    private static final String MODIFIERS_KEY = "modifiers";
    private Map<String, KeyStroke> map = null;

    @Override
    protected void parse() {
        try {
            List list = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_SHORTCUTS_KEY);
            this.map = new HashMap<String, KeyStroke>(list.size());
            for (HierarchicalConfiguration hierarchicalConfiguration : list) {
                String string = hierarchicalConfiguration.getString(MENU_ITEM_KEY, "");
                if (string.length() <= 0) continue;
                this.map.put(string, KeyStroke.getKeyStroke(hierarchicalConfiguration.getInt(KEYCODE_KEY, 0), hierarchicalConfiguration.getInt(MODIFIERS_KEY, 0), false));
            }
        }
        catch (ConversionException conversionException) {
            logger.error((Object)("Error while loading keyboard shortcuts " + conversionException.getMessage()), (Throwable)conversionException);
        }
    }

    public KeyStroke getShortcut(String string) {
        return this.map.get(string);
    }

    public void setShortcut(String string, KeyStroke keyStroke) {
        this.map.put(string, keyStroke);
    }

    protected void setConfigs() {
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_SHORTCUTS_KEY);
        int n = 0;
        for (Map.Entry<String, KeyStroke> entry : this.map.entrySet()) {
            String string = "keyboard.shortcuts(" + n + ").";
            this.getConfig().setProperty(string + MENU_ITEM_KEY, (Object)entry.getKey());
            if (entry.getValue() != null) {
                this.getConfig().setProperty(string + KEYCODE_KEY, (Object)entry.getValue().getKeyCode());
                this.getConfig().setProperty(string + MODIFIERS_KEY, (Object)entry.getValue().getModifiers());
            } else {
                this.getConfig().setProperty(string + KEYCODE_KEY, (Object)0);
                this.getConfig().setProperty(string + MODIFIERS_KEY, (Object)0);
            }
            ++n;
        }
    }
}

