/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class ZapNumberSpinner
extends JSpinner {
    private static final long serialVersionUID = -3475273563365395482L;
    private int minValue;
    private int maxValue;
    private int defaultValue;

    public ZapNumberSpinner() {
        this(0, 0, Integer.MAX_VALUE);
    }

    public ZapNumberSpinner(int n, int n2, int n3) {
        this.minValue = n;
        this.maxValue = n3;
        this.defaultValue = !this.isValidValue(n2) ? n : n2;
        this.setModel(new SpinnerNumberModel(this.defaultValue, n, n3, 1));
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().setFormatterFactory(new DefaultFormatterFactory(new ZapNumberFormatter(n, n3)));
    }

    private boolean isValidValue(int n) {
        return n >= this.minValue && n <= this.maxValue;
    }

    public void changeToDefaultValue() {
        super.setValue(this.defaultValue);
    }

    @Override
    public void setValue(Object object) {
        if (object == null || !(object instanceof Number)) {
            return;
        }
        this.setValue(((Number)object).intValue());
    }

    public void setValue(int n) {
        if (!this.isValidValue(n)) {
            return;
        }
        super.setValue(n);
    }

    @Override
    public Integer getValue() {
        return (Integer)super.getValue();
    }

    public void setEditable(boolean bl) {
        super.setEnabled(bl);
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().setEnabled(true);
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().setEditable(bl);
    }

    private static class ZapNumberFormat
    extends Format {
        private static final long serialVersionUID = 7864449797301371031L;
        private final NumberFormat numberFormat;
        private int minValue;

        public ZapNumberFormat(int n) {
            this.minValue = n;
            this.numberFormat = NumberFormat.getIntegerInstance();
            this.numberFormat.setGroupingUsed(false);
        }

        @Override
        public AttributedCharacterIterator formatToCharacterIterator(Object object) {
            return this.numberFormat.formatToCharacterIterator(object);
        }

        @Override
        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return this.numberFormat.format(object, stringBuffer, fieldPosition);
        }

        @Override
        public Object parseObject(String string, ParsePosition parsePosition) {
            if (string.isEmpty()) {
                parsePosition.setIndex(1);
                return this.minValue;
            }
            Object object = this.numberFormat.parseObject(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                parsePosition.setErrorIndex(parsePosition.getIndex());
                parsePosition.setIndex(0);
            }
            return object;
        }
    }

    private static class ZapNumberFormatter
    extends NumberFormatter {
        private static final long serialVersionUID = 4888079030453662194L;
        private int minValue;
        private int maxValue;

        public ZapNumberFormatter(int n, int n2) {
            this.minValue = n;
            this.maxValue = n2;
            this.setValueClass(Integer.class);
            this.setMinimum(Integer.valueOf(n));
            this.setMaximum(Integer.valueOf(n2));
            this.setAllowsInvalid(false);
            this.setFormat(new ZapNumberFormat(n));
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            Object object;
            block6: {
                object = null;
                try {
                    object = super.stringToValue(string);
                }
                catch (ParseException parseException) {
                    boolean bl = true;
                    if (parseException.getMessage().equals("Value not within min/max range")) {
                        int n = ((Number)this.getFormat().parseObject(string)).intValue();
                        if (n < this.minValue) {
                            object = this.minValue;
                            bl = false;
                        } else if (n > this.maxValue) {
                            object = this.maxValue;
                            bl = false;
                        }
                    }
                    if (!bl) break block6;
                    throw parseException;
                }
            }
            return object;
        }
    }
}

