/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.GenericScanner2;
import org.zaproxy.zap.model.ScanController;
import org.zaproxy.zap.utils.SortedComboBoxModel;
import org.zaproxy.zap.view.ScanStatus;
import org.zaproxy.zap.view.ZapToggleButton;

public abstract class ScanPanel2<GS extends GenericScanner2, SC extends ScanController<GS>>
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    public String prefix;
    private SC controller = null;
    private JPanel panelCommand = null;
    private JToolBar panelToolbar = null;
    private JLabel scannedCountNameLabel = null;
    private JLabel foundCountNameLabel = null;
    private JComboBox<ScanEntry<GS>> progressSelect = null;
    private SortedComboBoxModel<ScanEntry<GS>> progressModel = new SortedComboBoxModel();
    private final ScanEntry<GS> selectScanEntry;
    private JButton stopScanButton = null;
    private ZapToggleButton pauseScanButton = null;
    private JButton newScanButton = null;
    private JButton clearScansButton = null;
    private JButton optionsButton = null;
    private JProgressBar progressBar = null;
    private ScanStatus scanStatus = null;
    private Control.Mode mode = Control.getSingleton().getMode();
    private static Logger log = Logger.getLogger(ScanPanel2.class);

    public ScanPanel2(String string, ImageIcon imageIcon, SC SC, AbstractParam abstractParam) {
        this.prefix = string;
        this.controller = SC;
        this.selectScanEntry = new ScanEntry(Constant.messages.getString(string + ".toolbar.progress.select"));
        this.initialize(imageIcon);
        log.debug((Object)("Constructor " + string));
    }

    private void initialize(ImageIcon imageIcon) {
        this.setLayout(new CardLayout());
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(474, 251);
        }
        this.setName(Constant.messages.getString(this.prefix + ".panel.title"));
        this.setIcon(imageIcon);
        this.add((Component)this.getPanelCommand(), this.prefix + ".panel");
        this.scanStatus = new ScanStatus(imageIcon, Constant.messages.getString(this.prefix + ".panel.title"));
        if (View.isInitialised()) {
            View.getSingleton().getMainFrame().getMainFooterPanel().addFooterToolbarRightLabel(this.scanStatus.getCountLabel());
        }
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.panelCommand.setName(this.prefix + ".panel");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 18;
            this.panelCommand.add((Component)this.getPanelToolbar(), gridBagConstraints);
            this.panelCommand.add(this.getWorkPanel(), gridBagConstraints2);
        }
        return this.panelCommand;
    }

    protected GridBagConstraints getGBC(int n, int n2) {
        return this.getGBC(n, n2, 0.0, new Insets(0, 2, 0, 0));
    }

    protected GridBagConstraints getGBC(int n, int n2, double d, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = d;
        if (d > 0.0) {
            gridBagConstraints.fill = 2;
        }
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 17;
        return gridBagConstraints;
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName(this.prefix + ".toolbar");
            int n = 0;
            n = this.addToolBarElements(this.panelToolbar, Location.start, n);
            this.newScanButton = this.getNewScanButton();
            if (this.newScanButton != null) {
                this.panelToolbar.add((Component)this.newScanButton, this.getGBC(n++, 0));
                this.newScanButton.setEnabled(!Control.Mode.safe.equals((Object)this.mode));
                this.panelToolbar.addSeparator();
            }
            int n2 = ++n;
            this.panelToolbar.add((Component)new JLabel(Constant.messages.getString(this.prefix + ".toolbar.progress.label")), this.getGBC(n2, 0));
            int n3 = ++n;
            ++n;
            this.panelToolbar.add(this.getProgressSelect(), this.getGBC(n3, 0));
            n = this.addToolBarElements(this.panelToolbar, Location.beforeButtons, n);
            this.panelToolbar.add((Component)this.getPauseScanButton(), this.getGBC(n++, 0));
            this.panelToolbar.add((Component)this.getStopScanButton(), this.getGBC(n++, 0));
            n = this.addToolBarElements(this.panelToolbar, Location.beforeProgressBar, n);
            this.panelToolbar.add((Component)this.getProgressBar(), this.getGBC(n++, 0, 1.0, new Insets(0, 5, 0, 5)));
            this.panelToolbar.add((Component)this.getClearScansButton(), this.getGBC(n++, 0));
            this.panelToolbar.add((Component)this.getActiveScansNameLabel(), this.getGBC(n++, 0));
            this.panelToolbar.add((Component)this.getActiveScansValueLabel(), this.getGBC(n++, 0));
            n = this.addToolBarElements(this.panelToolbar, Location.afterProgressBar, n);
            this.panelToolbar.add((Component)new JLabel(), this.getGBC(n++, 0, 1.0, new Insets(0, 0, 0, 0)));
            this.panelToolbar.add((Component)this.getOptionsButton(), this.getGBC(n++, 0));
        }
        return this.panelToolbar;
    }

    protected int addToolBarElements(JToolBar jToolBar, Location location, int n) {
        return n;
    }

    private JLabel getActiveScansNameLabel() {
        if (this.scannedCountNameLabel == null) {
            this.scannedCountNameLabel = new JLabel();
            this.scannedCountNameLabel.setText(Constant.messages.getString(this.prefix + ".toolbar.ascans.label"));
        }
        return this.scannedCountNameLabel;
    }

    private JLabel getActiveScansValueLabel() {
        if (this.foundCountNameLabel == null) {
            this.foundCountNameLabel = new JLabel();
            this.foundCountNameLabel.setText(String.valueOf(this.controller.getActiveScans().size()));
        }
        return this.foundCountNameLabel;
    }

    private void setActiveScanLabelsEventHandler() {
        List list = this.controller.getActiveScans();
        this.getActiveScansValueLabel().setText(String.valueOf(list.size()));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        for (GenericScanner2 genericScanner2 : list) {
            stringBuilder.append(genericScanner2.getDisplayName());
            stringBuilder.append("<br>");
        }
        stringBuilder.append("</html>");
        String string = stringBuilder.toString();
        this.getActiveScansNameLabel().setToolTipText(string);
        this.getActiveScansValueLabel().setToolTipText(string);
        this.scanStatus.setScanCount(list.size());
        this.getClearScansButton().setEnabled(this.controller.getAllScans().size() - list.size() > 0);
    }

    protected JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setSize(new Dimension(80, 20));
            this.progressBar.setStringPainted(true);
            this.progressBar.setEnabled(false);
        }
        return this.progressBar;
    }

    protected JButton getStopScanButton() {
        if (this.stopScanButton == null) {
            this.stopScanButton = new JButton();
            this.stopScanButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.stop"));
            this.stopScanButton.setIcon(new ImageIcon(ScanPanel2.class.getResource("/resource/icon/16/142.png")));
            this.stopScanButton.setEnabled(false);
            this.stopScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object GS = ScanPanel2.this.getSelectedScanner();
                    if (GS != null) {
                        ScanPanel2.this.controller.stopScan(GS.getScanId());
                    }
                }
            });
        }
        return this.stopScanButton;
    }

    protected JToggleButton getPauseScanButton() {
        if (this.pauseScanButton == null) {
            this.pauseScanButton = new ZapToggleButton();
            this.pauseScanButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.pause"));
            this.pauseScanButton.setSelectedToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.unpause"));
            this.pauseScanButton.setIcon(new ImageIcon(ScanPanel2.class.getResource("/resource/icon/16/141.png")));
            this.pauseScanButton.setRolloverIcon(new ImageIcon(ScanPanel2.class.getResource("/resource/icon/16/141.png")));
            this.pauseScanButton.setSelectedIcon(new ImageIcon(ScanPanel2.class.getResource("/resource/icon/16/131.png")));
            this.pauseScanButton.setRolloverSelectedIcon(new ImageIcon(ScanPanel2.class.getResource("/resource/icon/16/131.png")));
            this.pauseScanButton.setEnabled(false);
            this.pauseScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object GS = ScanPanel2.this.getSelectedScanner();
                    if (GS != null) {
                        if (ScanPanel2.this.pauseScanButton.isSelected()) {
                            ScanPanel2.this.controller.pauseScan(GS.getScanId());
                        } else {
                            ScanPanel2.this.controller.resumeScan(GS.getScanId());
                        }
                    }
                }
            });
        }
        return this.pauseScanButton;
    }

    private JButton getOptionsButton() {
        if (this.optionsButton == null) {
            this.optionsButton = new JButton();
            this.optionsButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.options"));
            this.optionsButton.setIcon(new ImageIcon(ScanPanel2.class.getResource("/resource/icon/16/041.png")));
            this.optionsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Control.getSingleton().getMenuToolsControl().options(Constant.messages.getString(ScanPanel2.this.prefix + ".options.title"));
                }
            });
        }
        return this.optionsButton;
    }

    private JButton getClearScansButton() {
        if (this.clearScansButton == null) {
            this.clearScansButton = new JButton();
            this.clearScansButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.clear"));
            this.clearScansButton.setIcon(new ImageIcon(ScanPanel2.class.getResource("/resource/icon/fugue/broom.png")));
            this.clearScansButton.setEnabled(false);
            this.clearScansButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScanPanel2.this.clearFinishedScans();
                }
            });
        }
        return this.clearScansButton;
    }

    public void clearFinishedScans() {
        int n = this.controller.removeFinishedScans();
        if (n > 0) {
            this.progressModel.removeAllElements();
            this.progressModel.addElement(this.selectScanEntry);
            for (GenericScanner2 genericScanner2 : this.controller.getAllScans()) {
                this.progressModel.addElement(new ScanEntry<GenericScanner2>(genericScanner2));
            }
            this.updateScannerUI();
        }
        this.clearScansButton.setEnabled(false);
    }

    public GS getSelectedScanner() {
        Object object = this.progressModel.getSelectedItem();
        if (object == null) {
            return null;
        }
        Object GS = ((ScanEntry)object).getScan();
        return GS;
    }

    protected JComboBox<ScanEntry<GS>> getProgressSelect() {
        if (this.progressSelect == null) {
            this.progressSelect = new JComboBox<ScanEntry<GS>>(this.progressModel);
            this.progressSelect.addItem(this.selectScanEntry);
            this.progressSelect.setSelectedIndex(0);
            this.progressSelect.setEnabled(false);
            this.progressSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScanPanel2.this.scannerSelected(ScanPanel2.this.getSelectedScanner());
                }
            });
        }
        return this.progressSelect;
    }

    public void updateScannerUI() {
        this.scannerSelected(this.getSelectedScanner());
    }

    private void scannerSelected(GS GS) {
        this.updateProgressAndButtonsState(GS);
        this.switchView(GS);
    }

    private void updateProgressAndButtonsState(GS GS) {
        if (GS == null || Control.Mode.safe.equals((Object)Control.getSingleton().getMode())) {
            this.getStopScanButton().setEnabled(false);
            this.getPauseScanButton().setEnabled(false);
            this.getPauseScanButton().setSelected(false);
            this.getProgressBar().setEnabled(false);
        } else if (GS.isStopped()) {
            this.getStopScanButton().setEnabled(false);
            this.getPauseScanButton().setEnabled(false);
            this.getPauseScanButton().setSelected(false);
            this.getProgressBar().setEnabled(false);
        } else {
            this.getStopScanButton().setEnabled(true);
            this.getPauseScanButton().setEnabled(true);
            this.getPauseScanButton().setSelected(GS.isPaused());
            this.getProgressBar().setEnabled(true);
        }
        if (GS != null) {
            this.getProgressBar().setValue(GS.getProgress());
            this.getProgressBar().setMaximum(GS.getMaximum());
        } else {
            this.getProgressBar().setValue(0);
        }
    }

    public void scanFinshed(final int n, final String string) {
        if (EventQueue.isDispatchThread()) {
            this.scanFinshedEventHandler(n, string);
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScanPanel2.this.scanFinshedEventHandler(n, string);
                    }
                });
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void scanFinshedEventHandler(int n, String string) {
        log.debug((Object)("scanFinished " + this.prefix + " on " + string));
        if (this.getSelectedScanner() != null && this.getSelectedScanner().getScanId() == n) {
            this.updateProgressAndButtonsState(this.getSelectedScanner());
        }
        this.setActiveScanLabelsEventHandler();
    }

    public void scanProgress(final int n, final String string, final int n2, final int n3) {
        if (EventQueue.isDispatchThread()) {
            this.scanProgressEventHandler(n, string, n2, n3);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScanPanel2.this.scanProgressEventHandler(n, string, n2, n3);
                }
            });
        }
    }

    private void scanProgressEventHandler(int n, String string, int n2, int n3) {
        if (this.getSelectedScanner() != null && n == this.getSelectedScanner().getScanId()) {
            this.updateProgressAndButtonsState(this.getSelectedScanner());
        }
        this.setActiveScanLabelsEventHandler();
    }

    public void scannerStarted(GS GS) {
        ScanEntry<GS> scanEntry = new ScanEntry<GS>(GS);
        this.progressModel.addElement(scanEntry);
        this.getProgressSelect().setEnabled(true);
        this.getProgressSelect().setSelectedItem(scanEntry);
        this.trimProgressList();
        this.scannerSelected(GS);
    }

    public void trimProgressList() {
        if (this.progressModel.getSize() > this.getNumberOfScansToShow() + 1) {
            for (int i = 1; i < this.progressModel.getSize(); ++i) {
                Object GS = ((ScanEntry)this.progressModel.getElementAt(i)).getScan();
                if (GS == null || !GS.isStopped()) continue;
                this.controller.removeScan(GS.getScanId());
                this.progressModel.removeElementAt(i);
                if (this.progressModel.getSize() <= this.getNumberOfScansToShow() + 1) break;
                --i;
            }
        }
    }

    public void reset() {
        log.debug((Object)("reset " + this.prefix));
        this.progressModel.removeAllElements();
        this.progressSelect.addItem(this.selectScanEntry);
        this.progressSelect.setSelectedIndex(0);
        this.clearScansButton.setEnabled(false);
    }

    public void sessionScopeChanged(Session session) {
    }

    public void sessionModeChanged(Control.Mode mode) {
        if (this.newScanButton != null) {
            this.newScanButton.setEnabled(!Control.Mode.safe.equals((Object)mode));
        }
        this.updateScannerUI();
    }

    protected void unload() {
        if (View.isInitialised()) {
            View.getSingleton().getMainFrame().getMainFooterPanel().removeFooterToolbarRightLabel(this.scanStatus.getCountLabel());
        }
    }

    protected SC getController() {
        return this.controller;
    }

    protected abstract Component getWorkPanel();

    protected abstract void switchView(GS var1);

    protected abstract JButton getNewScanButton();

    protected abstract int getNumberOfScansToShow();

    private static class ScanEntry<GS extends GenericScanner2>
    implements Comparable<ScanEntry<GS>> {
        private final GS scan;
        private final String label;

        public ScanEntry(String string) {
            this.scan = null;
            this.label = string;
        }

        public ScanEntry(GS GS) {
            this.scan = GS;
            this.label = GS.getScanId() + ": " + GS.getDisplayName();
        }

        public GS getScan() {
            return this.scan;
        }

        public int hashCode() {
            return 31 + (this.scan == null ? 0 : this.scan.getScanId());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ScanEntry scanEntry = (ScanEntry)object;
            if (this.scan == null) {
                return scanEntry.scan == null;
            }
            if (scanEntry.scan == null) {
                return false;
            }
            return this.scan.getScanId() == scanEntry.scan.getScanId();
        }

        @Override
        public int compareTo(ScanEntry<GS> scanEntry) {
            if (scanEntry == null || scanEntry.scan == null) {
                return 1;
            }
            if (this.scan == null) {
                return -1;
            }
            return this.scan.getScanId() - scanEntry.scan.getScanId();
        }

        public String toString() {
            return this.label;
        }
    }

    protected static enum Location {
        start,
        beforeSites,
        beforeButtons,
        beforeProgressBar,
        afterProgressBar;

    }
}

