/*
 * Decompiled with CFR 0.152.
 */
package jspecview.dialog;

import javajs.util.DF;
import jspecview.common.Annotation;
import jspecview.common.IntegralData;
import jspecview.common.Measurement;
import jspecview.dialog.JSVDialog;

public class IntegrationDialog
extends JSVDialog {
    private static int[] posXY = new int[]{Integer.MIN_VALUE, 0};

    public IntegrationDialog() {
        this.type = Annotation.AType.Integration;
    }

    @Override
    public int[] getPosXY() {
        return posXY;
    }

    @Override
    public void addUniqueControls() {
        this.txt1 = this.dialog.addTextField("txtBaselineOffset", "Baseline Offset", null, "%", "" + this.vwr.parameters.integralOffset, true);
        this.txt2 = this.dialog.addTextField("txtScale", "Scale", null, "%", "" + this.vwr.parameters.integralRange, true);
        this.dialog.addButton("btnApply", "Apply");
        this.addApplyBtn = false;
        this.dialog.addButton("btnAuto", "Auto");
        this.dialog.addButton("btnDelete", "Delete");
        this.dialog.addButton("btnNormalize", "Normalize");
    }

    @Override
    public void applyFromFields() {
        this.apply(new Object[]{this.dialog.getText(this.txt1), this.dialog.getText(this.txt2)});
    }

    @Override
    public boolean callback(String string, String string2) {
        block10: {
            try {
                if (string.equals("SHOWSELECTION")) {
                    for (int i = 0; i < this.xyData.size(); ++i) {
                        if (!DF.formatDecimalDbl(((Measurement)this.xyData.get(i)).getXVal(), 2).equals(string2)) continue;
                        this.iSelected = i;
                        this.jsvp.getPanelData().setXPointers(this.spec, ((Measurement)this.xyData.get(i)).getXVal(), this.spec, ((Measurement)this.xyData.get(i)).getXVal2());
                        this.jsvp.doRepaint(true);
                        break;
                    }
                    return true;
                }
                if (!string.equals("windowClosing") && !string.equals("FOCUS")) {
                    if (string.equals("btnAuto") || this.xyData == null || this.xyData.size() == 0) {
                        this.vwr.runScript("integrate auto");
                        this.eventApply();
                        return true;
                    }
                    this.setFocus(true);
                }
                if (string.equals("btnDelete")) {
                    this.deleteIntegral();
                    break block10;
                }
                if (string.equals("btnNormalize")) {
                    if (!this.checkSelectedIntegral()) {
                        return true;
                    }
                    String string3 = this.manager.getDialogInput(this.dialog, "Enter a normalization factor", "Normalize", 3, null, null, "" + this.lastNorm);
                    double d = Double.parseDouble(string3);
                    if (d > 0.0) {
                        this.lastNorm = d;
                        ((IntegralData)this.xyData).setSelectedIntegral((Measurement)this.xyData.get(this.iSelected), this.lastNorm);
                    }
                    this.eventApply();
                    break block10;
                }
                return this.callbackAD(string, string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean checkSelectedIntegral() {
        if (this.iSelected < 0) {
            this.showMessage("Select a line on the table first, then click this button.", "Integration", 1);
            return false;
        }
        return true;
    }

    private void deleteIntegral() {
        if (!this.checkSelectedIntegral()) {
            return;
        }
        this.xyData.removeItemAt(this.iSelected);
        this.iSelected = -1;
        this.iRowColSelected = -1;
        this.applyFromFields();
    }
}

