/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.profile.query.ProfileWeight;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.elasticsearch.search.profile.query.QueryTimingType;

final class ProfileScorer
extends Scorer {
    private final Scorer scorer;
    private ProfileWeight profileWeight;
    private final QueryProfileBreakdown profile;

    ProfileScorer(ProfileWeight w, Scorer scorer, QueryProfileBreakdown profile) throws IOException {
        super((Weight)w);
        this.scorer = scorer;
        this.profileWeight = w;
        this.profile = profile;
    }

    public int docID() {
        return this.scorer.docID();
    }

    public float score() throws IOException {
        this.profile.startTime(QueryTimingType.SCORE);
        try {
            float f = this.scorer.score();
            return f;
        }
        finally {
            this.profile.stopAndRecordTime();
        }
    }

    public int freq() throws IOException {
        return this.scorer.freq();
    }

    public Weight getWeight() {
        return this.profileWeight;
    }

    public Collection<Scorer.ChildScorer> getChildren() {
        return this.scorer.getChildren();
    }

    public DocIdSetIterator iterator() {
        final DocIdSetIterator in = this.scorer.iterator();
        return new DocIdSetIterator(){

            public int advance(int target) throws IOException {
                ProfileScorer.this.profile.startTime(QueryTimingType.ADVANCE);
                try {
                    int n = in.advance(target);
                    return n;
                }
                finally {
                    ProfileScorer.this.profile.stopAndRecordTime();
                }
            }

            public int nextDoc() throws IOException {
                ProfileScorer.this.profile.startTime(QueryTimingType.NEXT_DOC);
                try {
                    int n = in.nextDoc();
                    return n;
                }
                finally {
                    ProfileScorer.this.profile.stopAndRecordTime();
                }
            }

            public int docID() {
                return in.docID();
            }

            public long cost() {
                return in.cost();
            }
        };
    }

    public TwoPhaseIterator twoPhaseIterator() {
        final TwoPhaseIterator in = this.scorer.twoPhaseIterator();
        if (in == null) {
            return null;
        }
        final DocIdSetIterator inApproximation = in.approximation();
        DocIdSetIterator approximation = new DocIdSetIterator(){

            public int advance(int target) throws IOException {
                ProfileScorer.this.profile.startTime(QueryTimingType.ADVANCE);
                try {
                    int n = inApproximation.advance(target);
                    return n;
                }
                finally {
                    ProfileScorer.this.profile.stopAndRecordTime();
                }
            }

            public int nextDoc() throws IOException {
                ProfileScorer.this.profile.startTime(QueryTimingType.NEXT_DOC);
                try {
                    int n = inApproximation.nextDoc();
                    return n;
                }
                finally {
                    ProfileScorer.this.profile.stopAndRecordTime();
                }
            }

            public int docID() {
                return inApproximation.docID();
            }

            public long cost() {
                return inApproximation.cost();
            }
        };
        return new TwoPhaseIterator(approximation){

            public boolean matches() throws IOException {
                ProfileScorer.this.profile.startTime(QueryTimingType.MATCH);
                try {
                    boolean bl = in.matches();
                    return bl;
                }
                finally {
                    ProfileScorer.this.profile.stopAndRecordTime();
                }
            }

            public float matchCost() {
                return in.matchCost();
            }
        };
    }
}

