#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: safe
version: 0.3.11
id: safe-0.3.11-Ck0Z7kfzoQA1bcHU9bHvtW
key: safe-0.3.11-Ck0Z7kfzoQA1bcHU9bHvtW
license: BSD3
copyright: Neil Mitchell 2007-2017
maintainer: Neil Mitchell <ndmitchell@gmail.com>
homepage: https://github.com/ndmitchell/safe#readme
synopsis: Library of safe (exception free) functions
description:
    A library wrapping @Prelude@/@Data.List@ functions that can throw exceptions, such as @head@ and @!!@.
    Each unsafe function has up to four variants, e.g. with @tail@:
    .
    * @tail :: [a] -> [a]@, raises an error on @tail []@.
    .
    * @tailMay :: [a] -> /Maybe/ [a]@, turns errors into @Nothing@.
    .
    * @tailDef :: /[a]/ -> [a] -> [a]@, takes a default to return on errors.
    .
    * @tailNote :: /String/ -> [a] -> [a]@, takes an extra argument which supplements the error message.
    .
    * @tailSafe :: [a] -> [a]@, returns some sensible default if possible, @[]@ in the case of @tail@.
    .
    This package is divided into three modules:
    .
    * "Safe" contains safe variants of @Prelude@ and @Data.List@ functions.
    .
    * "Safe.Foldable" contains safe variants of @Foldable@ functions.
    .
    * "Safe.Exact" creates crashing versions of functions like @zip@ (errors if the lists are not equal) and @take@ (errors if there are not enough elements), then wraps them to provide safe variants.
category: Unclassified
author: Neil Mitchell <ndmitchell@gmail.com>
exposed: True
exposed-modules:
    Safe Safe.Exact Safe.Foldable
hidden-modules: Safe.Util
abi: 192f69cb38d47e52d18b6eb120af31a7
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/safe-0.3.11
library-dirs: /usr/lib/ghc-8.0.1/site-local/safe-0.3.11
data-dir: /usr/share/arm-linux-ghc-8.0.1/safe-0.3.11
hs-libraries: HSsafe-0.3.11-Ck0Z7kfzoQA1bcHU9bHvtW
depends:
    base-4.9.0.0
haddock-interfaces: /usr/share/doc/haskell-safe/html/safe.haddock
haddock-html: /usr/share/doc/haskell-safe/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
