/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import jnr.ffi.Pointer;
import jnr.ffi.provider.MemoryManager;
import org.jcodings.Encoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;

public class NativeRope
extends Rope {
    private Pointer pointer;

    public NativeRope(MemoryManager memoryManager, byte[] bytes, Encoding encoding, int characterLength) {
        super(encoding, CodeRange.CR_UNKNOWN, false, bytes.length, characterLength, 1, null);
        this.pointer = memoryManager.allocateDirect(bytes.length, false);
        this.pointer.put(0L, bytes, 0, bytes.length);
    }

    @Override
    protected byte[] getBytesSlow() {
        byte[] bytes = new byte[this.byteLength()];
        this.pointer.get(0L, bytes, 0, bytes.length);
        return bytes;
    }

    @Override
    public byte getByteSlow(int index) {
        return this.get(index);
    }

    @Override
    public byte get(int index) {
        return this.pointer.getByte(index);
    }

    public String toString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Rope withEncoding(Encoding newEncoding, CodeRange newCodeRange) {
        throw new UnsupportedOperationException();
    }

    public Pointer getNativePointer() {
        return this.pointer;
    }
}

