/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.scope.StaticScope;

public class SClassParseNode
extends ParseNode {
    private final ParseNode receiverNode;
    private final StaticScope scope;
    private final ParseNode bodyNode;

    public SClassParseNode(SourceIndexLength position, ParseNode recvNode, StaticScope scope, ParseNode bodyNode) {
        super(position, recvNode.containsVariableAssignment() || bodyNode.containsVariableAssignment());
        assert (scope != null) : "scope is not null";
        assert (recvNode != null) : "receiverNode is not null";
        this.receiverNode = recvNode;
        this.scope = scope;
        this.bodyNode = bodyNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SCLASSNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitSClassNode(this);
    }

    public ParseNode getBodyNode() {
        return this.bodyNode;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public ParseNode getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.receiverNode, this.bodyNode);
    }
}

