/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CollectionChangeSupport;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomePrint;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Polyline;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.Wall;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Home
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final long CURRENT_VERSION = 5300L;
    private static final boolean KEEP_BACKWARD_COMPATIBLITY = true;
    private static final Comparator<Level> LEVEL_ELEVATION_COMPARATOR = new Comparator<Level>(){

        @Override
        public int compare(Level level, Level level2) {
            int n = Float.compare(level.getElevation(), level2.getElevation());
            if (n != 0) {
                return n;
            }
            return level.getElevationIndex() - level2.getElevationIndex();
        }
    };
    private List<HomePieceOfFurniture> furniture;
    private transient CollectionChangeSupport<HomePieceOfFurniture> furnitureChangeSupport;
    private transient List<Selectable> selectedItems;
    private transient List<SelectionListener> selectionListeners;
    private transient boolean allLevelsSelection;
    private List<Level> levels;
    private Level selectedLevel;
    private transient CollectionChangeSupport<Level> levelsChangeSupport;
    private List<Wall> walls;
    private transient CollectionChangeSupport<Wall> wallsChangeSupport;
    private List<Room> rooms;
    private transient CollectionChangeSupport<Room> roomsChangeSupport;
    private List<Polyline> polylines;
    private transient CollectionChangeSupport<Polyline> polylinesChangeSupport;
    private List<DimensionLine> dimensionLines;
    private transient CollectionChangeSupport<DimensionLine> dimensionLinesChangeSupport;
    private List<Label> labels;
    private transient CollectionChangeSupport<Label> labelsChangeSupport;
    private Camera camera;
    private String name;
    private final float wallHeight;
    private transient boolean modified;
    private transient boolean recovered;
    private transient boolean repaired;
    private BackgroundImage backgroundImage;
    private ObserverCamera observerCamera;
    private Camera topCamera;
    private List<Camera> storedCameras;
    private HomeEnvironment environment;
    private HomePrint print;
    private String furnitureSortedPropertyName;
    private List<String> furnitureVisiblePropertyNames;
    private boolean furnitureDescendingSorted;
    private Map<String, Object> visualProperties;
    private Map<String, String> properties;
    private transient PropertyChangeSupport propertyChangeSupport;
    private long version;
    private boolean basePlanLocked;
    private Compass compass;
    private int skyColor;
    private int groundColor;
    private HomeTexture groundTexture;
    private int lightColor;
    private float wallsAlpha;
    private HomePieceOfFurniture.SortableProperty furnitureSortedProperty;
    private List<HomePieceOfFurniture.SortableProperty> furnitureVisibleProperties;
    private List<HomePieceOfFurniture> furnitureWithDoorsAndWindows;
    private List<HomePieceOfFurniture> furnitureWithGroups;

    public Home() {
        this(250.0f);
    }

    public Home(float f) {
        this(new ArrayList<HomePieceOfFurniture>(), f);
    }

    public Home(List<HomePieceOfFurniture> list) {
        this(list, 250.0f);
    }

    private Home(List<HomePieceOfFurniture> list, float f) {
        this.furniture = new ArrayList<HomePieceOfFurniture>(list);
        this.walls = new ArrayList<Wall>();
        this.wallHeight = f;
        this.furnitureVisibleProperties = Arrays.asList(HomePieceOfFurniture.SortableProperty.NAME, HomePieceOfFurniture.SortableProperty.WIDTH, HomePieceOfFurniture.SortableProperty.DEPTH, HomePieceOfFurniture.SortableProperty.HEIGHT, HomePieceOfFurniture.SortableProperty.VISIBLE);
        this.init(true);
        this.addModelListeners();
    }

    protected Home(Home home) {
        this.wallHeight = home.getWallHeight();
        Home.copyHomeData(home, this);
        Home.initListenersSupport(this);
        this.addModelListeners();
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init(false);
        objectInputStream.defaultReadObject();
        if (this.furnitureSortedPropertyName != null) {
            try {
                this.furnitureSortedProperty = HomePieceOfFurniture.SortableProperty.valueOf(this.furnitureSortedPropertyName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.furnitureSortedPropertyName = null;
        }
        if (this.furnitureVisiblePropertyNames != null) {
            this.furnitureVisibleProperties = new ArrayList<HomePieceOfFurniture.SortableProperty>();
            for (String object : this.furnitureVisiblePropertyNames) {
                try {
                    this.furnitureVisibleProperties.add(HomePieceOfFurniture.SortableProperty.valueOf(object));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            this.furnitureVisiblePropertyNames = null;
        }
        for (Wall wall : this.walls) {
            if (wall.getHeight() != null) continue;
            wall.setHeight(Float.valueOf(this.wallHeight));
        }
        if (this.furnitureWithDoorsAndWindows != null) {
            this.furniture = this.furnitureWithDoorsAndWindows;
            this.furnitureWithDoorsAndWindows = null;
        }
        if (this.furnitureWithGroups != null) {
            this.furniture = this.furnitureWithGroups;
            this.furnitureWithGroups = null;
        }
        this.environment.setGroundColor(this.groundColor);
        this.environment.setGroundTexture(this.groundTexture);
        this.environment.setSkyColor(this.skyColor);
        this.environment.setLightColor(this.lightColor);
        this.environment.setWallsAlpha(this.wallsAlpha);
        if (this.version <= 3400L) {
            int n = this.environment.getGroundColor();
            this.environment.setGroundColor((n >> 16 & 0xFF) * 3 / 4 << 16 | (n >> 8 & 0xFF) * 3 / 4 << 8 | (n & 0xFF) * 3 / 4);
        }
        if (this.levels.size() > 0) {
            void var3_10;
            Level level = this.levels.get(0);
            if (level.getElevationIndex() == -1) {
                level.setElevationIndex(0);
            }
            boolean bl = true;
            while (var3_10 < this.levels.size()) {
                Level level2 = this.levels.get((int)var3_10);
                if (level2.getElevationIndex() == -1) {
                    if (level.getElevation() == level2.getElevation()) {
                        level2.setElevationIndex(level.getElevationIndex() + 1);
                    } else {
                        level2.setElevationIndex(0);
                    }
                }
                level = level2;
                ++var3_10;
            }
        }
        this.moveVisualProperty("com.eteks.sweethome3d.swing.PhotoPanel.PhotoDialogX");
        this.moveVisualProperty("com.eteks.sweethome3d.swing.PhotoPanel.PhotoDialogY");
        this.moveVisualProperty("com.eteks.sweethome3d.swing.PhotosPanel.PhotoDialogX");
        this.moveVisualProperty("com.eteks.sweethome3d.swing.PhotosPanel.PhotoDialogY");
        this.moveVisualProperty("com.eteks.sweethome3d.swing.VideoPanel.VideoDialogX");
        this.moveVisualProperty("com.eteks.sweethome3d.swing.VideoPanel.VideoDialogY");
        this.moveVisualProperty("com.eteks.sweethome3d.swing.HomeComponent3D.detachedViewX");
        this.moveVisualProperty("com.eteks.sweethome3d.swing.HomeComponent3D.detachedViewY");
        this.moveVisualProperty("com.eteks.sweethome3d.swing.HomeComponent3D.detachedViewWidth");
        this.moveVisualProperty("com.eteks.sweethome3d.swing.HomeComponent3D.detachedViewHeight");
        this.moveVisualProperty("com.eteks.sweethome3d.swing.HomeComponent3D.detachedView");
        this.moveVisualProperty("com.eteks.sweethome3d.swing.HomeComponent3D.detachedViewDividerLocation");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.MainPaneDividerLocation");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.CatalogPaneDividerLocation");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.PlanPaneDividerLocation");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.PlanViewportX");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.PlanViewportY");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.FurnitureViewportY");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.PlanScale");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.ExpandedGroups");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.FrameX");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.FrameY");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.FrameWidth");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.FrameHeight");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.FrameMaximized");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.ScreenWidth");
        this.moveVisualProperty("com.eteks.sweethome3d.SweetHome3D.ScreenHeight");
        this.addModelListeners();
    }

    private void moveVisualProperty(String string) {
        if (this.visualProperties.containsKey(string)) {
            Object object = this.visualProperties.get(string);
            this.properties.put(string, object != null ? String.valueOf(object) : null);
            this.visualProperties.remove(string);
        }
    }

    private void init(boolean bl) {
        this.selectedItems = new ArrayList<Selectable>();
        Home.initListenersSupport(this);
        if (this.furnitureVisibleProperties == null) {
            this.furnitureVisibleProperties = Arrays.asList(HomePieceOfFurniture.SortableProperty.NAME, HomePieceOfFurniture.SortableProperty.WIDTH, HomePieceOfFurniture.SortableProperty.DEPTH, HomePieceOfFurniture.SortableProperty.HEIGHT, HomePieceOfFurniture.SortableProperty.COLOR, HomePieceOfFurniture.SortableProperty.MOVABLE, HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW, HomePieceOfFurniture.SortableProperty.VISIBLE);
        }
        this.topCamera = new Camera(50.0f, 1050.0f, 1010.0f, (float)Math.PI, 0.7853982f, 1.0995575f);
        this.observerCamera = new ObserverCamera(50.0f, 50.0f, 170.0f, 5.4977875f, 0.19634955f, 1.0995575f);
        this.storedCameras = Collections.emptyList();
        this.environment = new HomeEnvironment();
        this.rooms = new ArrayList<Room>();
        this.polylines = new ArrayList<Polyline>();
        this.dimensionLines = new ArrayList<DimensionLine>();
        this.labels = new ArrayList<Label>();
        this.compass = new Compass(-100.0f, 50.0f, 100.0f);
        this.levels = new ArrayList<Level>();
        this.compass.setVisible(bl);
        this.visualProperties = new HashMap<String, Object>();
        this.properties = new HashMap<String, String>();
        this.version = 5300L;
    }

    private static void initListenersSupport(Home home) {
        home.furnitureChangeSupport = new CollectionChangeSupport(home);
        home.selectionListeners = new ArrayList<SelectionListener>();
        home.levelsChangeSupport = new CollectionChangeSupport(home);
        home.wallsChangeSupport = new CollectionChangeSupport(home);
        home.roomsChangeSupport = new CollectionChangeSupport(home);
        home.polylinesChangeSupport = new CollectionChangeSupport(home);
        home.dimensionLinesChangeSupport = new CollectionChangeSupport(home);
        home.labelsChangeSupport = new CollectionChangeSupport(home);
        home.propertyChangeSupport = new PropertyChangeSupport(home);
    }

    private void addModelListeners() {
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Level.Property.ELEVATION.name().equals(propertyChangeEvent.getPropertyName()) || Level.Property.ELEVATION_INDEX.name().equals(propertyChangeEvent.getPropertyName())) {
                    Home.this.levels = new ArrayList(Home.this.levels);
                    Collections.sort(Home.this.levels, LEVEL_ELEVATION_COMPARATOR);
                }
            }
        };
        for (Level level : this.levels) {
            level.addPropertyChangeListener(propertyChangeListener);
        }
        this.addLevelsListener(new CollectionListener<Level>(){

            @Override
            public void collectionChanged(CollectionEvent<Level> collectionEvent) {
                switch (collectionEvent.getType()) {
                    case ADD: {
                        collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener);
                        break;
                    }
                    case DELETE: {
                        collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.version = 5300L;
        HomePieceOfFurniture.SortableProperty sortableProperty = this.furnitureSortedProperty;
        List<HomePieceOfFurniture.SortableProperty> list = this.furnitureVisibleProperties;
        List<HomePieceOfFurniture> list2 = this.furniture;
        try {
            if (this.furnitureSortedProperty != null) {
                this.furnitureSortedPropertyName = this.furnitureSortedProperty.name();
                if (!this.isFurnitureSortedPropertyBackwardCompatible(this.furnitureSortedProperty)) {
                    this.furnitureSortedProperty = null;
                }
            }
            this.furnitureVisiblePropertyNames = new ArrayList<String>();
            this.furnitureVisibleProperties = new ArrayList<HomePieceOfFurniture.SortableProperty>();
            for (HomePieceOfFurniture.SortableProperty object : list) {
                this.furnitureVisiblePropertyNames.add(object.name());
                if (!this.isFurnitureSortedPropertyBackwardCompatible(object)) continue;
                this.furnitureVisibleProperties.add(object);
            }
            this.furnitureWithGroups = this.furniture;
            this.furnitureWithDoorsAndWindows = new ArrayList<HomePieceOfFurniture>(this.furniture.size());
            this.furniture = new ArrayList<HomePieceOfFurniture>(this.furniture.size());
            for (HomePieceOfFurniture homePieceOfFurniture : this.furnitureWithGroups) {
                if (homePieceOfFurniture.getClass() == HomePieceOfFurniture.class) {
                    this.furnitureWithDoorsAndWindows.add(homePieceOfFurniture);
                    this.furniture.add(homePieceOfFurniture);
                    continue;
                }
                if (homePieceOfFurniture.getClass() == HomeFurnitureGroup.class) {
                    for (HomePieceOfFurniture homePieceOfFurniture2 : this.getGroupFurniture((HomeFurnitureGroup)homePieceOfFurniture)) {
                        this.furnitureWithDoorsAndWindows.add(homePieceOfFurniture2);
                        if (homePieceOfFurniture2.getClass() == HomePieceOfFurniture.class) {
                            this.furniture.add(homePieceOfFurniture2);
                            continue;
                        }
                        this.furniture.add(new HomePieceOfFurniture(homePieceOfFurniture2));
                    }
                    continue;
                }
                this.furnitureWithDoorsAndWindows.add(homePieceOfFurniture);
                this.furniture.add(new HomePieceOfFurniture(homePieceOfFurniture));
            }
            this.groundColor = this.environment.getGroundColor();
            this.groundTexture = this.environment.getGroundTexture();
            this.skyColor = this.environment.getSkyColor();
            this.lightColor = this.environment.getLightColor();
            this.wallsAlpha = this.environment.getWallsAlpha();
            objectOutputStream.defaultWriteObject();
        }
        finally {
            this.furniture = list2;
            this.furnitureWithDoorsAndWindows = null;
            this.furnitureWithGroups = null;
            this.furnitureSortedProperty = sortableProperty;
            this.furnitureVisibleProperties = list;
            this.furnitureSortedPropertyName = null;
            this.furnitureVisiblePropertyNames = null;
        }
    }

    private boolean isFurnitureSortedPropertyBackwardCompatible(HomePieceOfFurniture.SortableProperty sortableProperty) {
        switch (sortableProperty) {
            case NAME: 
            case WIDTH: 
            case DEPTH: 
            case HEIGHT: 
            case MOVABLE: 
            case DOOR_OR_WINDOW: 
            case COLOR: 
            case VISIBLE: 
            case X: 
            case Y: 
            case ELEVATION: 
            case ANGLE: {
                return true;
            }
        }
        return false;
    }

    private List<HomePieceOfFurniture> getGroupFurniture(HomeFurnitureGroup homeFurnitureGroup) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (HomePieceOfFurniture homePieceOfFurniture : homeFurnitureGroup.getFurniture()) {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                arrayList.addAll(this.getGroupFurniture((HomeFurnitureGroup)homePieceOfFurniture));
                continue;
            }
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    public void addLevelsListener(CollectionListener<Level> collectionListener) {
        this.levelsChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeLevelsListener(CollectionListener<Level> collectionListener) {
        this.levelsChangeSupport.removeCollectionListener(collectionListener);
    }

    public List<Level> getLevels() {
        return Collections.unmodifiableList(this.levels);
    }

    public void addLevel(Level level) {
        int n;
        if (level.getElevationIndex() < 0) {
            n = 0;
            for (Level level2 : this.levels) {
                if (level2.getElevation() == level.getElevation()) {
                    n = level2.getElevationIndex() + 1;
                    continue;
                }
                if (!(level2.getElevation() > level.getElevation())) continue;
                break;
            }
            level.setElevationIndex(n);
        }
        this.levels = new ArrayList<Level>(this.levels);
        n = Collections.binarySearch(this.levels, level, LEVEL_ELEVATION_COMPARATOR);
        int n2 = n >= 0 ? n : -(n + 1);
        this.levels.add(n2, level);
        this.levelsChangeSupport.fireCollectionChanged(level, n2, CollectionEvent.Type.ADD);
    }

    public void deleteLevel(Level level) {
        int n = this.levels.indexOf(level);
        if (n != -1) {
            for (HomePieceOfFurniture homeObject : this.furniture) {
                if (homeObject.getLevel() != level) continue;
                this.deletePieceOfFurniture(homeObject);
            }
            for (Room room : this.rooms) {
                if (room.getLevel() != level) continue;
                this.deleteRoom(room);
            }
            for (Wall wall : this.walls) {
                if (wall.getLevel() != level) continue;
                this.deleteWall(wall);
            }
            for (Polyline polyline : this.polylines) {
                if (polyline.getLevel() != level) continue;
                this.deletePolyline(polyline);
            }
            for (DimensionLine dimensionLine : this.dimensionLines) {
                if (dimensionLine.getLevel() != level) continue;
                this.deleteDimensionLine(dimensionLine);
            }
            for (Label label : this.labels) {
                if (label.getLevel() != level) continue;
                this.deleteLabel(label);
            }
            if (this.selectedLevel == level) {
                if (this.levels.size() == 1) {
                    this.setSelectedLevel(null);
                    this.setAllLevelsSelection(false);
                } else {
                    this.setSelectedLevel(this.levels.get(n >= 1 ? n - 1 : n + 1));
                }
            }
            this.levels = new ArrayList<Level>(this.levels);
            this.levels.remove(n);
            this.levelsChangeSupport.fireCollectionChanged(level, n, CollectionEvent.Type.DELETE);
        }
    }

    public Level getSelectedLevel() {
        return this.selectedLevel;
    }

    public void setSelectedLevel(Level level) {
        if (level != this.selectedLevel) {
            Level level2 = this.selectedLevel;
            this.selectedLevel = level;
            this.propertyChangeSupport.firePropertyChange(Property.SELECTED_LEVEL.name(), level2, level);
        }
    }

    public boolean isAllLevelsSelection() {
        return this.allLevelsSelection;
    }

    public void setAllLevelsSelection(boolean bl) {
        if (bl != this.allLevelsSelection) {
            this.allLevelsSelection = bl;
            this.propertyChangeSupport.firePropertyChange(Property.ALL_LEVELS_SELECTION.name(), !bl, bl);
        }
    }

    public void addFurnitureListener(CollectionListener<HomePieceOfFurniture> collectionListener) {
        this.furnitureChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeFurnitureListener(CollectionListener<HomePieceOfFurniture> collectionListener) {
        this.furnitureChangeSupport.removeCollectionListener(collectionListener);
    }

    public List<HomePieceOfFurniture> getFurniture() {
        return Collections.unmodifiableList(this.furniture);
    }

    public void addPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
        this.addPieceOfFurniture(homePieceOfFurniture, this.furniture.size());
    }

    public void addPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture, int n) {
        this.furniture = new ArrayList<HomePieceOfFurniture>(this.furniture);
        homePieceOfFurniture.setLevel(this.selectedLevel);
        this.furniture.add(n, homePieceOfFurniture);
        this.furnitureChangeSupport.fireCollectionChanged(homePieceOfFurniture, n, CollectionEvent.Type.ADD);
    }

    public void addPieceOfFurnitureToGroup(HomePieceOfFurniture homePieceOfFurniture, HomeFurnitureGroup homeFurnitureGroup, int n) {
        homePieceOfFurniture.setLevel(this.selectedLevel);
        homeFurnitureGroup.addPieceOfFurniture(homePieceOfFurniture, n);
        this.furnitureChangeSupport.fireCollectionChanged(homePieceOfFurniture, CollectionEvent.Type.ADD);
    }

    public void deletePieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
        HomeFurnitureGroup homeFurnitureGroup;
        this.deselectItem(homePieceOfFurniture);
        int n = this.furniture.indexOf(homePieceOfFurniture);
        HomeFurnitureGroup homeFurnitureGroup2 = homeFurnitureGroup = n == -1 ? this.getPieceOfFurnitureGroup(homePieceOfFurniture, null, this.furniture) : null;
        if (n != -1 || homeFurnitureGroup != null) {
            homePieceOfFurniture.setLevel(null);
            this.furniture = new ArrayList<HomePieceOfFurniture>(this.furniture);
            if (homeFurnitureGroup != null) {
                homeFurnitureGroup.deletePieceOfFurniture(homePieceOfFurniture);
                this.furnitureChangeSupport.fireCollectionChanged(homePieceOfFurniture, CollectionEvent.Type.DELETE);
            } else {
                this.furniture.remove(n);
                this.furnitureChangeSupport.fireCollectionChanged(homePieceOfFurniture, n, CollectionEvent.Type.DELETE);
            }
        }
    }

    private HomeFurnitureGroup getPieceOfFurnitureGroup(HomePieceOfFurniture homePieceOfFurniture, HomeFurnitureGroup homeFurnitureGroup, List<HomePieceOfFurniture> list) {
        for (HomePieceOfFurniture homePieceOfFurniture2 : list) {
            HomeFurnitureGroup homeFurnitureGroup2;
            if (homePieceOfFurniture2.equals(homePieceOfFurniture)) {
                return homeFurnitureGroup;
            }
            if (!(homePieceOfFurniture2 instanceof HomeFurnitureGroup) || (homeFurnitureGroup2 = this.getPieceOfFurnitureGroup(homePieceOfFurniture, (HomeFurnitureGroup)homePieceOfFurniture2, ((HomeFurnitureGroup)homePieceOfFurniture2).getFurniture())) == null) continue;
            return homeFurnitureGroup2;
        }
        return null;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    public List<Selectable> getSelectedItems() {
        return Collections.unmodifiableList(this.selectedItems);
    }

    public void setSelectedItems(List<? extends Selectable> list) {
        this.selectedItems = new ArrayList<Selectable>(list);
        if (!this.selectionListeners.isEmpty()) {
            SelectionListener[] selectionListenerArray;
            SelectionEvent selectionEvent = new SelectionEvent(this, this.getSelectedItems());
            for (SelectionListener selectionListener : selectionListenerArray = this.selectionListeners.toArray(new SelectionListener[this.selectionListeners.size()])) {
                selectionListener.selectionChanged(selectionEvent);
            }
        }
    }

    public void deselectItem(Selectable selectable) {
        int n = this.selectedItems.indexOf(selectable);
        if (n != -1) {
            ArrayList<Selectable> arrayList = new ArrayList<Selectable>(this.getSelectedItems());
            arrayList.remove(n);
            this.setSelectedItems(arrayList);
        }
    }

    public void addRoomsListener(CollectionListener<Room> collectionListener) {
        this.roomsChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeRoomsListener(CollectionListener<Room> collectionListener) {
        this.roomsChangeSupport.removeCollectionListener(collectionListener);
    }

    public List<Room> getRooms() {
        return Collections.unmodifiableList(this.rooms);
    }

    public void addRoom(Room room) {
        this.addRoom(room, this.rooms.size());
    }

    public void addRoom(Room room, int n) {
        this.rooms = new ArrayList<Room>(this.rooms);
        this.rooms.add(n, room);
        room.setLevel(this.selectedLevel);
        this.roomsChangeSupport.fireCollectionChanged(room, n, CollectionEvent.Type.ADD);
    }

    public void deleteRoom(Room room) {
        this.deselectItem(room);
        int n = this.rooms.indexOf(room);
        if (n != -1) {
            room.setLevel(null);
            this.rooms = new ArrayList<Room>(this.rooms);
            this.rooms.remove(n);
            this.roomsChangeSupport.fireCollectionChanged(room, n, CollectionEvent.Type.DELETE);
        }
    }

    public void addWallsListener(CollectionListener<Wall> collectionListener) {
        this.wallsChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeWallsListener(CollectionListener<Wall> collectionListener) {
        this.wallsChangeSupport.removeCollectionListener(collectionListener);
    }

    public Collection<Wall> getWalls() {
        return Collections.unmodifiableCollection(this.walls);
    }

    public void addWall(Wall wall) {
        this.walls = new ArrayList<Wall>(this.walls);
        this.walls.add(wall);
        wall.setLevel(this.selectedLevel);
        this.wallsChangeSupport.fireCollectionChanged(wall, CollectionEvent.Type.ADD);
    }

    public void deleteWall(Wall wall) {
        this.deselectItem(wall);
        for (Wall wall2 : this.getWalls()) {
            if (wall.equals(wall2.getWallAtStart())) {
                wall2.setWallAtStart(null);
                continue;
            }
            if (!wall.equals(wall2.getWallAtEnd())) continue;
            wall2.setWallAtEnd(null);
        }
        int n = this.walls.indexOf(wall);
        if (n != -1) {
            wall.setLevel(null);
            this.walls = new ArrayList<Wall>(this.walls);
            this.walls.remove(n);
            this.wallsChangeSupport.fireCollectionChanged(wall, CollectionEvent.Type.DELETE);
        }
    }

    public void addPolylinesListener(CollectionListener<Polyline> collectionListener) {
        this.polylinesChangeSupport.addCollectionListener(collectionListener);
    }

    public void removePolylinesListener(CollectionListener<Polyline> collectionListener) {
        this.polylinesChangeSupport.removeCollectionListener(collectionListener);
    }

    public List<Polyline> getPolylines() {
        return Collections.unmodifiableList(this.polylines);
    }

    public void addPolyline(Polyline polyline) {
        this.addPolyline(polyline, this.polylines.size());
    }

    public void addPolyline(Polyline polyline, int n) {
        this.polylines = new ArrayList<Polyline>(this.polylines);
        this.polylines.add(n, polyline);
        polyline.setLevel(this.selectedLevel);
        this.polylinesChangeSupport.fireCollectionChanged(polyline, CollectionEvent.Type.ADD);
    }

    public void deletePolyline(Polyline polyline) {
        this.deselectItem(polyline);
        int n = this.polylines.indexOf(polyline);
        if (n != -1) {
            polyline.setLevel(null);
            this.polylines = new ArrayList<Polyline>(this.polylines);
            this.polylines.remove(n);
            this.polylinesChangeSupport.fireCollectionChanged(polyline, CollectionEvent.Type.DELETE);
        }
    }

    public void addDimensionLinesListener(CollectionListener<DimensionLine> collectionListener) {
        this.dimensionLinesChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeDimensionLinesListener(CollectionListener<DimensionLine> collectionListener) {
        this.dimensionLinesChangeSupport.removeCollectionListener(collectionListener);
    }

    public Collection<DimensionLine> getDimensionLines() {
        return Collections.unmodifiableCollection(this.dimensionLines);
    }

    public void addDimensionLine(DimensionLine dimensionLine) {
        this.dimensionLines = new ArrayList<DimensionLine>(this.dimensionLines);
        this.dimensionLines.add(dimensionLine);
        dimensionLine.setLevel(this.selectedLevel);
        this.dimensionLinesChangeSupport.fireCollectionChanged(dimensionLine, CollectionEvent.Type.ADD);
    }

    public void deleteDimensionLine(DimensionLine dimensionLine) {
        this.deselectItem(dimensionLine);
        int n = this.dimensionLines.indexOf(dimensionLine);
        if (n != -1) {
            dimensionLine.setLevel(null);
            this.dimensionLines = new ArrayList<DimensionLine>(this.dimensionLines);
            this.dimensionLines.remove(n);
            this.dimensionLinesChangeSupport.fireCollectionChanged(dimensionLine, CollectionEvent.Type.DELETE);
        }
    }

    public void addLabelsListener(CollectionListener<Label> collectionListener) {
        this.labelsChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeLabelsListener(CollectionListener<Label> collectionListener) {
        this.labelsChangeSupport.removeCollectionListener(collectionListener);
    }

    public Collection<Label> getLabels() {
        return Collections.unmodifiableCollection(this.labels);
    }

    public void addLabel(Label label) {
        this.labels = new ArrayList<Label>(this.labels);
        this.labels.add(label);
        label.setLevel(this.selectedLevel);
        this.labelsChangeSupport.fireCollectionChanged(label, CollectionEvent.Type.ADD);
    }

    public void deleteLabel(Label label) {
        this.deselectItem(label);
        int n = this.labels.indexOf(label);
        if (n != -1) {
            label.setLevel(null);
            this.labels = new ArrayList<Label>(this.labels);
            this.labels.remove(n);
            this.labelsChangeSupport.fireCollectionChanged(label, CollectionEvent.Type.DELETE);
        }
    }

    public List<Selectable> getSelectableViewableItems() {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>();
        this.addViewableItems(this.walls, arrayList);
        this.addViewableItems(this.rooms, arrayList);
        this.addViewableItems(this.dimensionLines, arrayList);
        this.addViewableItems(this.polylines, arrayList);
        this.addViewableItems(this.labels, arrayList);
        for (HomePieceOfFurniture homePieceOfFurniture : this.getFurniture()) {
            if (!homePieceOfFurniture.isVisible() || homePieceOfFurniture.getLevel() != null && !homePieceOfFurniture.getLevel().isViewable()) continue;
            arrayList.add(homePieceOfFurniture);
        }
        if (this.getCompass().isVisible()) {
            arrayList.add(this.getCompass());
        }
        return arrayList;
    }

    private <T extends Selectable> void addViewableItems(Collection<T> collection, List<Selectable> list) {
        for (Selectable selectable : collection) {
            Elevatable elevatable;
            if (!(selectable instanceof Elevatable) || (elevatable = (Elevatable)((Object)selectable)).getLevel() != null && !elevatable.getLevel().isViewable()) continue;
            list.add(selectable);
        }
    }

    public boolean isEmpty() {
        return this.furniture.isEmpty() && this.walls.isEmpty() && this.rooms.isEmpty() && this.dimensionLines.isEmpty() && this.polylines.isEmpty() && this.labels.isEmpty();
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public float getWallHeight() {
        return this.wallHeight;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (!(string == this.name || string != null && string.equals(this.name))) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        if (bl != this.modified) {
            this.modified = bl;
            this.propertyChangeSupport.firePropertyChange(Property.MODIFIED.name(), !bl, bl);
        }
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public void setRecovered(boolean bl) {
        if (bl != this.recovered) {
            this.recovered = bl;
            this.propertyChangeSupport.firePropertyChange(Property.RECOVERED.name(), !bl, bl);
        }
    }

    public boolean isRepaired() {
        return this.repaired;
    }

    public void setRepaired(boolean bl) {
        if (bl != this.repaired) {
            this.repaired = bl;
            this.propertyChangeSupport.firePropertyChange(Property.REPAIRED.name(), !bl, bl);
        }
    }

    public HomePieceOfFurniture.SortableProperty getFurnitureSortedProperty() {
        return this.furnitureSortedProperty;
    }

    public void setFurnitureSortedProperty(HomePieceOfFurniture.SortableProperty sortableProperty) {
        if (!(sortableProperty == this.furnitureSortedProperty || sortableProperty != null && sortableProperty.equals((Object)this.furnitureSortedProperty))) {
            HomePieceOfFurniture.SortableProperty sortableProperty2 = this.furnitureSortedProperty;
            this.furnitureSortedProperty = sortableProperty;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_SORTED_PROPERTY.name(), (Object)sortableProperty2, (Object)sortableProperty);
        }
    }

    public boolean isFurnitureDescendingSorted() {
        return this.furnitureDescendingSorted;
    }

    public void setFurnitureDescendingSorted(boolean bl) {
        if (bl != this.furnitureDescendingSorted) {
            this.furnitureDescendingSorted = bl;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_DESCENDING_SORTED.name(), !bl, bl);
        }
    }

    public List<HomePieceOfFurniture.SortableProperty> getFurnitureVisibleProperties() {
        if (this.furnitureVisibleProperties == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.furnitureVisibleProperties);
    }

    public void setFurnitureVisibleProperties(List<HomePieceOfFurniture.SortableProperty> list) {
        if (!(list == this.furnitureVisibleProperties || list != null && list.equals(this.furnitureVisibleProperties))) {
            List<HomePieceOfFurniture.SortableProperty> list2 = this.furnitureVisibleProperties;
            this.furnitureVisibleProperties = new ArrayList<HomePieceOfFurniture.SortableProperty>(list);
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_VISIBLE_PROPERTIES.name(), Collections.unmodifiableList(list2), Collections.unmodifiableList(list));
        }
    }

    public BackgroundImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(BackgroundImage backgroundImage) {
        if (backgroundImage != this.backgroundImage) {
            BackgroundImage backgroundImage2 = this.backgroundImage;
            this.backgroundImage = backgroundImage;
            this.propertyChangeSupport.firePropertyChange(Property.BACKGROUND_IMAGE.name(), backgroundImage2, backgroundImage);
        }
    }

    public Camera getTopCamera() {
        return this.topCamera;
    }

    public ObserverCamera getObserverCamera() {
        return this.observerCamera;
    }

    public void setCamera(Camera camera) {
        if (camera != this.camera) {
            Camera camera2 = this.camera;
            this.camera = camera;
            this.propertyChangeSupport.firePropertyChange(Property.CAMERA.name(), camera2, camera);
        }
    }

    public Camera getCamera() {
        if (this.camera == null) {
            this.camera = this.getTopCamera();
        }
        return this.camera;
    }

    public void setStoredCameras(List<Camera> list) {
        if (!this.storedCameras.equals(list)) {
            List<Camera> list2 = this.storedCameras;
            this.storedCameras = list == null ? Collections.emptyList() : new ArrayList<Camera>(list);
            this.propertyChangeSupport.firePropertyChange(Property.STORED_CAMERAS.name(), Collections.unmodifiableList(list2), Collections.unmodifiableList(list));
        }
    }

    public List<Camera> getStoredCameras() {
        return Collections.unmodifiableList(this.storedCameras);
    }

    public HomeEnvironment getEnvironment() {
        return this.environment;
    }

    public Compass getCompass() {
        return this.compass;
    }

    public HomePrint getPrint() {
        return this.print;
    }

    public void setPrint(HomePrint homePrint) {
        if (homePrint != this.print) {
            HomePrint homePrint2 = this.print;
            this.print = homePrint;
            this.propertyChangeSupport.firePropertyChange(Property.PRINT.name(), homePrint2, homePrint);
        }
        this.print = homePrint;
    }

    public Object getVisualProperty(String string) {
        return this.visualProperties.get(string);
    }

    public void setVisualProperty(String string, Object object) {
        this.visualProperties.put(string, object);
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public Number getNumericProperty(String string) {
        String string2 = this.properties.get(string);
        if (string2 != null) {
            try {
                return new Long(string2);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return new Double(string2);
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            if (this.properties.containsKey(string)) {
                this.properties.remove(string);
            }
        } else {
            this.properties.put(string, string2);
        }
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public boolean isBasePlanLocked() {
        return this.basePlanLocked;
    }

    public void setBasePlanLocked(boolean bl) {
        if (bl != this.basePlanLocked) {
            this.basePlanLocked = bl;
            this.propertyChangeSupport.firePropertyChange(Property.BASE_PLAN_LOCKED.name(), !bl, bl);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public Home clone() {
        try {
            Home home = (Home)super.clone();
            Home.copyHomeData(this, home);
            Home.initListenersSupport(home);
            home.addModelListeners();
            return home;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Super class isn't cloneable");
        }
    }

    private static void copyHomeData(Home home, Home home2) {
        int n;
        home2.allLevelsSelection = home.allLevelsSelection;
        home2.name = home.name;
        home2.modified = home.modified;
        home2.recovered = home.recovered;
        home2.repaired = home.repaired;
        home2.backgroundImage = home.backgroundImage;
        home2.print = home.print;
        home2.furnitureDescendingSorted = home.furnitureDescendingSorted;
        home2.version = home.version;
        home2.basePlanLocked = home.basePlanLocked;
        home2.skyColor = home.skyColor;
        home2.groundColor = home.groundColor;
        home2.lightColor = home.lightColor;
        home2.wallsAlpha = home.wallsAlpha;
        home2.furnitureSortedProperty = home.furnitureSortedProperty;
        home2.selectedItems = new ArrayList<Selectable>(home.selectedItems.size());
        home2.furniture = Home.cloneSelectableItems(home.furniture, home.selectedItems, home2.selectedItems);
        for (n = 0; n < home.furniture.size(); ++n) {
            HomePieceOfFurniture homeObject2 = home.furniture.get(n);
            if (!(homeObject2 instanceof HomeDoorOrWindow) || !((HomeDoorOrWindow)homeObject2).isBoundToWall()) continue;
            ((HomeDoorOrWindow)home2.furniture.get(n)).setBoundToWall(true);
        }
        home2.rooms = Home.cloneSelectableItems(home.rooms, home.selectedItems, home2.selectedItems);
        home2.dimensionLines = Home.cloneSelectableItems(home.dimensionLines, home.selectedItems, home2.selectedItems);
        home2.polylines = Home.cloneSelectableItems(home.polylines, home.selectedItems, home2.selectedItems);
        home2.labels = Home.cloneSelectableItems(home.labels, home.selectedItems, home2.selectedItems);
        home2.walls = Wall.clone(home.walls);
        for (n = 0; n < home.walls.size(); ++n) {
            Wall wall = home.walls.get(n);
            if (!home.selectedItems.contains(wall)) continue;
            home2.selectedItems.add(home2.walls.get(n));
        }
        home2.levels = new ArrayList<Level>();
        if (home.levels.size() > 0) {
            for (Level level : home.levels) {
                home2.levels.add(level.clone());
            }
            for (n = 0; n < home.furniture.size(); ++n) {
                Level level = home.furniture.get(n).getLevel();
                if (level == null) continue;
                home2.furniture.get(n).setLevel(home2.levels.get(home.levels.indexOf(level)));
            }
            for (n = 0; n < home.rooms.size(); ++n) {
                Level level = home.rooms.get(n).getLevel();
                if (level == null) continue;
                home2.rooms.get(n).setLevel(home2.levels.get(home.levels.indexOf(level)));
            }
            for (n = 0; n < home.dimensionLines.size(); ++n) {
                Level level = home.dimensionLines.get(n).getLevel();
                if (level == null) continue;
                home2.dimensionLines.get(n).setLevel(home2.levels.get(home.levels.indexOf(level)));
            }
            for (n = 0; n < home.polylines.size(); ++n) {
                Level level = home.polylines.get(n).getLevel();
                if (level == null) continue;
                home2.polylines.get(n).setLevel(home2.levels.get(home.levels.indexOf(level)));
            }
            for (n = 0; n < home.labels.size(); ++n) {
                Level level = home.labels.get(n).getLevel();
                if (level == null) continue;
                home2.labels.get(n).setLevel(home2.levels.get(home.levels.indexOf(level)));
            }
            for (n = 0; n < home.walls.size(); ++n) {
                Level level = home.walls.get(n).getLevel();
                if (level == null) continue;
                home2.walls.get(n).setLevel(home2.levels.get(home.levels.indexOf(level)));
            }
            if (home.selectedLevel != null) {
                home2.selectedLevel = home2.levels.get(home.levels.indexOf(home.selectedLevel));
            }
        }
        home2.observerCamera = home.observerCamera.clone();
        home2.topCamera = home.topCamera.clone();
        if (home.camera == home.observerCamera) {
            home2.camera = home2.observerCamera;
            if (home.selectedItems.contains(home.observerCamera)) {
                home2.selectedItems.add(home2.observerCamera);
            }
        } else {
            home2.camera = home2.topCamera;
        }
        home2.storedCameras = new ArrayList<Camera>(home.storedCameras.size());
        for (Camera camera : home.storedCameras) {
            home2.storedCameras.add(camera.clone());
        }
        home2.environment = home.environment.clone();
        home2.compass = home.compass.clone();
        home2.furnitureVisibleProperties = new ArrayList<HomePieceOfFurniture.SortableProperty>(home.furnitureVisibleProperties);
        home2.visualProperties = new HashMap<String, Object>(home.visualProperties);
        home2.properties = new HashMap<String, String>(home.properties);
    }

    private static <T extends Selectable> List<T> cloneSelectableItems(List<T> list, List<Selectable> list2, List<Selectable> list3) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>(list.size());
        for (Selectable selectable : list) {
            Selectable selectable2 = selectable.clone();
            arrayList.add(selectable2);
            if (list2.contains(selectable)) {
                list3.add(selectable2);
                continue;
            }
            if (!(selectable instanceof HomeFurnitureGroup)) continue;
            List<HomePieceOfFurniture> list4 = ((HomeFurnitureGroup)selectable).getAllFurniture();
            List<HomePieceOfFurniture> list5 = null;
            int n = list4.size();
            for (int i = 0; i < n; ++i) {
                HomePieceOfFurniture homePieceOfFurniture = list4.get(i);
                if (!list2.contains(homePieceOfFurniture)) continue;
                if (list5 == null) {
                    list5 = ((HomeFurnitureGroup)selectable2).getAllFurniture();
                }
                list3.add(list5.get(i));
            }
        }
        return arrayList;
    }

    public static List<Selectable> duplicate(List<? extends Selectable> list) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>();
        for (Selectable selectable : list) {
            if (selectable instanceof Wall || selectable instanceof Camera || selectable instanceof Compass) continue;
            arrayList.add(selectable.clone());
        }
        arrayList.addAll(Wall.clone(Home.getWallsSubList(list)));
        return arrayList;
    }

    public static List<HomePieceOfFurniture> getFurnitureSubList(List<? extends Selectable> list) {
        return Home.getSubList(list, HomePieceOfFurniture.class);
    }

    public static List<Wall> getWallsSubList(List<? extends Selectable> list) {
        return Home.getSubList(list, Wall.class);
    }

    public static List<Room> getRoomsSubList(List<? extends Selectable> list) {
        return Home.getSubList(list, Room.class);
    }

    public static List<Polyline> getPolylinesSubList(List<? extends Selectable> list) {
        return Home.getSubList(list, Polyline.class);
    }

    public static List<DimensionLine> getDimensionLinesSubList(List<? extends Selectable> list) {
        return Home.getSubList(list, DimensionLine.class);
    }

    public static List<Label> getLabelsSubList(List<? extends Selectable> list) {
        return Home.getSubList(list, Label.class);
    }

    public static <T> List<T> getSubList(List<? extends Selectable> list, Class<T> clazz) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>();
        for (Selectable selectable : list) {
            if (!clazz.isInstance(selectable)) continue;
            arrayList.add(selectable);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        NAME,
        MODIFIED,
        FURNITURE_SORTED_PROPERTY,
        FURNITURE_DESCENDING_SORTED,
        FURNITURE_VISIBLE_PROPERTIES,
        BACKGROUND_IMAGE,
        CAMERA,
        PRINT,
        BASE_PLAN_LOCKED,
        STORED_CAMERAS,
        RECOVERED,
        REPAIRED,
        SELECTED_LEVEL,
        ALL_LEVELS_SELECTION;

    }
}

