/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.freehep.swing.graphics.AbstractRegionSelectionPanel;
import org.freehep.swing.images.FreeHepImage;

public class YSliceSelectionPanel
extends AbstractRegionSelectionPanel {
    public int getNumberOfControlPoints() {
        return 6;
    }

    /*
     * WARNING - void declaration
     */
    public Cursor getControlPointCursor(int index) {
        void var2_2;
        switch (index) {
            case 0: 
            case 3: 
            case 4: {
                int k = 5;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                int k = 4;
                break;
            }
            default: {
                return FreeHepImage.getCursor("YSliceCursor");
            }
        }
        int dy = this.yCtrlPts[index] - this.yCtrlPts[var2_2];
        if (dy == 0) {
            return FreeHepImage.getCursor("YSliceCursor");
        }
        return YSliceSelectionPanel.compassCursor("Resize", 1, dy, 4, false);
    }

    public void initializeControlPoints(int x, int y) {
        this.activeCtrlPt = 5;
        Arrays.fill(this.yCtrlPts, y);
        int xmax = this.getWidth();
        int xmid = xmax / 2;
        this.xCtrlPts[0] = 0;
        this.xCtrlPts[1] = 0;
        this.xCtrlPts[2] = xmax;
        this.xCtrlPts[3] = xmax;
        this.xCtrlPts[4] = xmid;
        this.xCtrlPts[5] = xmid;
    }

    public void updateActiveControlPoint(int x, int y) {
        y = this.forceYCoordinateWithinBounds(y);
        if (this.activeCtrlPt == 0 || this.activeCtrlPt == 3 || this.activeCtrlPt == 4) {
            this.yCtrlPts[0] = y;
            this.yCtrlPts[3] = y;
            this.yCtrlPts[4] = y;
        } else if (this.activeCtrlPt == 1 || this.activeCtrlPt == 2 || this.activeCtrlPt == 5) {
            this.yCtrlPts[1] = y;
            this.yCtrlPts[2] = y;
            this.yCtrlPts[5] = y;
        }
        this.repaintPanel();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(thickStroke);
            g.setColor(Color.black);
            g.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g.drawLine(this.xCtrlPts[4], this.yCtrlPts[4], this.xCtrlPts[5], this.yCtrlPts[5]);
            }
            g2d.setStroke(thinStroke);
            g.setColor(Color.white);
            g.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g.drawLine(this.xCtrlPts[4], this.yCtrlPts[4], this.xCtrlPts[5], this.yCtrlPts[5]);
            }
            if (this.activeCtrlPt >= 0) {
                g.setColor(Color.black);
                g.fillRect(this.xCtrlPts[this.activeCtrlPt] - ctrlPtSize - 1, this.yCtrlPts[this.activeCtrlPt] - ctrlPtSize - 1, 2 * ctrlPtSize + 3, 2 * ctrlPtSize + 3);
                g.setColor(Color.white);
                g.fillRect(this.xCtrlPts[this.activeCtrlPt] - ctrlPtSize, this.yCtrlPts[this.activeCtrlPt] - ctrlPtSize, 2 * ctrlPtSize + 1, 2 * ctrlPtSize + 1);
            }
        }
    }

    public AffineTransform makeAffineTransform() {
        int first = 1;
        int second = 2;
        int third = 3;
        if (this.yCtrlPts[0] < this.yCtrlPts[1]) {
            first = 0;
            second = 3;
            third = 2;
        }
        return this.makeTransform(this.xCtrlPts[first], this.yCtrlPts[first], this.xCtrlPts[second], this.yCtrlPts[second], this.xCtrlPts[third], this.yCtrlPts[third]);
    }

    public boolean isValidSelection() {
        return this.visible && this.yCtrlPts[4] != this.yCtrlPts[5] && this.xCtrlPts[0] != this.xCtrlPts[3];
    }
}

