/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.search.MultiValueMode;

class FieldDataValueSource
extends ValueSource {
    final IndexFieldData<?> fieldData;
    final MultiValueMode multiValueMode;

    protected FieldDataValueSource(IndexFieldData<?> fieldData, MultiValueMode multiValueMode) {
        this.fieldData = Objects.requireNonNull(fieldData);
        this.multiValueMode = Objects.requireNonNull(multiValueMode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FieldDataValueSource that = (FieldDataValueSource)((Object)o);
        if (!this.fieldData.equals(that.fieldData)) {
            return false;
        }
        return this.multiValueMode == that.multiValueMode;
    }

    public int hashCode() {
        int result = this.fieldData.hashCode();
        result = 31 * result + this.multiValueMode.hashCode();
        return result;
    }

    public FunctionValues getValues(Map context, LeafReaderContext leaf) throws IOException {
        AtomicNumericFieldData leafData = (AtomicNumericFieldData)this.fieldData.load(leaf);
        final NumericDoubleValues docValues = this.multiValueMode.select(leafData.getDoubleValues(), 0.0);
        return new DoubleDocValues(this){

            public double doubleVal(int doc) {
                return docValues.get(doc);
            }
        };
    }

    public String description() {
        return "field(" + this.fieldData.getFieldName() + ")";
    }
}

