/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;

public final class ScriptProcessor
extends AbstractProcessor {
    public static final String TYPE = "script";
    private final Script script;
    private final ScriptService scriptService;

    ScriptProcessor(String tag, Script script, ScriptService scriptService) {
        super(tag);
        this.script = script;
        this.scriptService = scriptService;
    }

    public void execute(IngestDocument document) {
        ExecutableScript executableScript = this.scriptService.executable(this.script, (ScriptContext)ScriptContext.Standard.INGEST);
        executableScript.setNextVar("ctx", (Object)document.getSourceAndMetadata());
        executableScript.run();
    }

    public String getType() {
        return TYPE;
    }

    Script getScript() {
        return this.script;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public ScriptProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String scriptPropertyUsed;
            Script script;
            boolean moreThanOneConfigured;
            boolean containsNoScript;
            String lang = ConfigurationUtils.readOptionalStringProperty((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"lang");
            String inline = ConfigurationUtils.readOptionalStringProperty((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"inline");
            String file = ConfigurationUtils.readOptionalStringProperty((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"file");
            String id = ConfigurationUtils.readOptionalStringProperty((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"id");
            Map params = ConfigurationUtils.readOptionalMap((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"params");
            boolean bl = containsNoScript = !Strings.hasLength((String)file) && !Strings.hasLength((String)id) && !Strings.hasLength((String)inline);
            if (containsNoScript) {
                throw ConfigurationUtils.newConfigurationException((String)ScriptProcessor.TYPE, (String)processorTag, null, (String)"Need [file], [id], or [inline] parameter to refer to scripts");
            }
            boolean bl2 = moreThanOneConfigured = Strings.hasLength((String)file) && Strings.hasLength((String)id) || Strings.hasLength((String)file) && Strings.hasLength((String)inline) || Strings.hasLength((String)id) && Strings.hasLength((String)inline);
            if (moreThanOneConfigured) {
                throw ConfigurationUtils.newConfigurationException((String)ScriptProcessor.TYPE, (String)processorTag, null, (String)"Only one of [file], [id], or [inline] may be configured");
            }
            if (lang == null) {
                lang = "painless";
            }
            if (params == null) {
                params = Collections.emptyMap();
            }
            if (Strings.hasLength((String)file)) {
                script = new Script(ScriptType.FILE, lang, file, params);
                scriptPropertyUsed = "file";
            } else if (Strings.hasLength((String)inline)) {
                script = new Script(ScriptType.INLINE, lang, inline, params);
                scriptPropertyUsed = "inline";
            } else if (Strings.hasLength((String)id)) {
                script = new Script(ScriptType.STORED, lang, id, params);
                scriptPropertyUsed = "id";
            } else {
                throw ConfigurationUtils.newConfigurationException((String)ScriptProcessor.TYPE, (String)processorTag, null, (String)"Could not initialize script");
            }
            try {
                this.scriptService.compile(script, (ScriptContext)ScriptContext.Standard.INGEST, script.getOptions());
            }
            catch (ScriptException e) {
                throw ConfigurationUtils.newConfigurationException((String)ScriptProcessor.TYPE, (String)processorTag, (String)scriptPropertyUsed, (Exception)((Object)e));
            }
            return new ScriptProcessor(processorTag, script, this.scriptService);
        }
    }
}

