/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetStoredScriptRequest
extends MasterNodeReadRequest<GetStoredScriptRequest> {
    protected String id;
    protected String lang;

    GetStoredScriptRequest() {
    }

    public GetStoredScriptRequest(String lang, String id) {
        this.lang = lang;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.lang == null) {
            validationException = ValidateActions.addValidationError("lang is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        return validationException;
    }

    public GetStoredScriptRequest lang(@Nullable String type) {
        this.lang = type;
        return this;
    }

    public GetStoredScriptRequest id(String id) {
        this.id = id;
        return this;
    }

    public String lang() {
        return this.lang;
    }

    public String id() {
        return this.id;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.lang = in.readString();
        this.id = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.lang);
        out.writeString(this.id);
    }

    public String toString() {
        return "get script [" + this.lang + "][" + this.id + "]";
    }
}

