/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.rest.RestRequest;

public class IndicesOptions {
    private static final IndicesOptions[] VALUES;
    private static final byte IGNORE_UNAVAILABLE = 1;
    private static final byte ALLOW_NO_INDICES = 2;
    private static final byte EXPAND_WILDCARDS_OPEN = 4;
    private static final byte EXPAND_WILDCARDS_CLOSED = 8;
    private static final byte FORBID_ALIASES_TO_MULTIPLE_INDICES = 16;
    private static final byte FORBID_CLOSED_INDICES = 32;
    private static final byte STRICT_EXPAND_OPEN = 6;
    private static final byte LENIENT_EXPAND_OPEN = 7;
    private static final byte STRICT_EXPAND_OPEN_CLOSED = 14;
    private static final byte STRICT_EXPAND_OPEN_FORBID_CLOSED = 38;
    private static final byte STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED = 48;
    private final byte id;

    private IndicesOptions(byte id) {
        this.id = id;
    }

    public boolean ignoreUnavailable() {
        return (this.id & 1) != 0;
    }

    public boolean allowNoIndices() {
        return (this.id & 2) != 0;
    }

    public boolean expandWildcardsOpen() {
        return (this.id & 4) != 0;
    }

    public boolean expandWildcardsClosed() {
        return (this.id & 8) != 0;
    }

    public boolean forbidClosedIndices() {
        return (this.id & 0x20) != 0;
    }

    public boolean allowAliasesToMultipleIndices() {
        return (this.id & 0x10) == 0;
    }

    public void writeIndicesOptions(StreamOutput out) throws IOException {
        out.write(this.id);
    }

    public static IndicesOptions readIndicesOptions(StreamInput in) throws IOException {
        byte id = in.readByte();
        if (id >= VALUES.length) {
            throw new IllegalArgumentException("No valid missing index type id: " + id);
        }
        return VALUES[id];
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, true, false);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, IndicesOptions defaultOptions) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, defaultOptions.allowAliasesToMultipleIndices(), defaultOptions.forbidClosedIndices());
    }

    static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, boolean allowAliasesToMultipleIndices, boolean forbidClosedIndices) {
        byte id = IndicesOptions.toByte(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, allowAliasesToMultipleIndices, forbidClosedIndices);
        return VALUES[id];
    }

    public static IndicesOptions fromRequest(RestRequest request, IndicesOptions defaultSettings) {
        return IndicesOptions.fromParameters(request.param("expand_wildcards"), request.param("ignore_unavailable"), request.param("allow_no_indices"), defaultSettings);
    }

    public static IndicesOptions fromMap(Map<String, Object> map, IndicesOptions defaultSettings) {
        return IndicesOptions.fromParameters(map.containsKey("expand_wildcards") ? map.get("expand_wildcards") : map.get("expandWildcards"), map.containsKey("ignore_unavailable") ? map.get("ignore_unavailable") : map.get("ignoreUnavailable"), map.containsKey("allow_no_indices") ? map.get("allow_no_indices") : map.get("allowNoIndices"), defaultSettings);
    }

    public static boolean isIndicesOptions(String name) {
        return "expand_wildcards".equals(name) || "expandWildcards".equals(name) || "ignore_unavailable".equals(name) || "ignoreUnavailable".equals(name) || "allow_no_indices".equals(name) || "allowNoIndices".equals(name);
    }

    public static IndicesOptions fromParameters(Object wildcardsString, Object ignoreUnavailableString, Object allowNoIndicesString, IndicesOptions defaultSettings) {
        if (wildcardsString == null && ignoreUnavailableString == null && allowNoIndicesString == null) {
            return defaultSettings;
        }
        boolean expandWildcardsOpen = false;
        boolean expandWildcardsClosed = false;
        if (wildcardsString == null) {
            expandWildcardsOpen = defaultSettings.expandWildcardsOpen();
            expandWildcardsClosed = defaultSettings.expandWildcardsClosed();
        } else {
            String[] wildcards;
            for (String wildcard : wildcards = XContentMapValues.nodeStringArrayValue(wildcardsString)) {
                if ("open".equals(wildcard)) {
                    expandWildcardsOpen = true;
                    continue;
                }
                if ("closed".equals(wildcard)) {
                    expandWildcardsClosed = true;
                    continue;
                }
                if ("none".equals(wildcard)) {
                    expandWildcardsOpen = false;
                    expandWildcardsClosed = false;
                    continue;
                }
                if ("all".equals(wildcard)) {
                    expandWildcardsOpen = true;
                    expandWildcardsClosed = true;
                    continue;
                }
                throw new IllegalArgumentException("No valid expand wildcard value [" + wildcard + "]");
            }
        }
        return IndicesOptions.fromOptions(XContentMapValues.lenientNodeBooleanValue(ignoreUnavailableString, defaultSettings.ignoreUnavailable()), XContentMapValues.lenientNodeBooleanValue(allowNoIndicesString, defaultSettings.allowNoIndices()), expandWildcardsOpen, expandWildcardsClosed, defaultSettings.allowAliasesToMultipleIndices(), defaultSettings.forbidClosedIndices());
    }

    public static IndicesOptions strictExpandOpen() {
        return VALUES[6];
    }

    public static IndicesOptions strictExpandOpenAndForbidClosed() {
        return VALUES[38];
    }

    public static IndicesOptions strictExpand() {
        return VALUES[14];
    }

    public static IndicesOptions strictSingleIndexNoExpandForbidClosed() {
        return VALUES[48];
    }

    public static IndicesOptions lenientExpandOpen() {
        return VALUES[7];
    }

    private static byte toByte(boolean ignoreUnavailable, boolean allowNoIndices, boolean wildcardExpandToOpen, boolean wildcardExpandToClosed, boolean allowAliasesToMultipleIndices, boolean forbidClosedIndices) {
        byte id = 0;
        if (ignoreUnavailable) {
            id = (byte)(id | 1);
        }
        if (allowNoIndices) {
            id = (byte)(id | 2);
        }
        if (wildcardExpandToOpen) {
            id = (byte)(id | 4);
        }
        if (wildcardExpandToClosed) {
            id = (byte)(id | 8);
        }
        if (!allowAliasesToMultipleIndices) {
            id = (byte)(id | 0x10);
        }
        if (forbidClosedIndices) {
            id = (byte)(id | 0x20);
        }
        return id;
    }

    public String toString() {
        return "IndicesOptions[id=" + this.id + ", ignore_unavailable=" + this.ignoreUnavailable() + ", allow_no_indices=" + this.allowNoIndices() + ", expand_wildcards_open=" + this.expandWildcardsOpen() + ", expand_wildcards_closed=" + this.expandWildcardsClosed() + ", allow_alisases_to_multiple_indices=" + this.allowAliasesToMultipleIndices() + ", forbid_closed_indices=" + this.forbidClosedIndices() + ']';
    }

    static {
        byte max = 64;
        VALUES = new IndicesOptions[max];
        for (byte id = 0; id < max; id = (byte)(id + 1)) {
            IndicesOptions.VALUES[id] = new IndicesOptions(id);
        }
    }
}

